/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import opennlp.maxent.io.BinaryGISModelReader;
import opennlp.model.AbstractModel;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.util.StringList;
import opennlp.tools.util.model.BaseModel;

public class CorefModel
extends BaseModel {
    private static final String COMPONENT_NAME = "Coref";
    private static final String MALE_NAMES_DICTIONARY_ENTRY_NAME = "maleNames.dictionary";
    private static final String FEMALE_NAMES_DICTIONARY_ENTRY_NAME = "femaleNames.dictionary";
    private static final String NUMBER_MODEL_ENTRY_NAME = "number.model";
    private static final String COMMON_NOUN_RESOLVER_MODEL_ENTRY_NAME = "commonNounResolver.model";
    private static final String DEFINITE_NOUN_RESOLVER_MODEL_ENTRY_NAME = "definiteNounResolver.model";
    private static final String SPEECH_PRONOUN_RESOLVER_MODEL_ENTRY_NAME = "speechPronounResolver.model";
    private static final String PLURAL_NOUN_RESOLVER_MODEL_ENTRY_NAME = "pluralNounResolver.model";
    private static final String SINGULAR_PRONOUN_RESOLVER_MODEL_ENTRY_NAME = "singularPronounResolver.model";
    private static final String PROPER_NOUN_RESOLVER_MODEL_ENTRY_NAME = "properNounResolver.model";
    private static final String SIM_MODEL_ENTRY_NAME = "sim.model";
    private static final String PLURAL_PRONOUN_RESOLVER_MODEL_ENTRY_NAME = "pluralPronounResolver.model";

    public CorefModel(String languageCode, String project) throws IOException {
        super(COMPONENT_NAME, languageCode, null);
        this.artifactMap.put(MALE_NAMES_DICTIONARY_ENTRY_NAME, CorefModel.readNames(project + File.separator + "gen.mas"));
        this.artifactMap.put(FEMALE_NAMES_DICTIONARY_ENTRY_NAME, CorefModel.readNames(project + File.separator + "gen.fem"));
        this.artifactMap.put(NUMBER_MODEL_ENTRY_NAME, this.createModel(project + File.separator + "num.bin.gz"));
        this.artifactMap.put(COMMON_NOUN_RESOLVER_MODEL_ENTRY_NAME, this.createModel(project + File.separator + "cmodel.bin.gz"));
        this.artifactMap.put(DEFINITE_NOUN_RESOLVER_MODEL_ENTRY_NAME, this.createModel(project + File.separator + "defmodel.bin.gz"));
        this.artifactMap.put(SPEECH_PRONOUN_RESOLVER_MODEL_ENTRY_NAME, this.createModel(project + File.separator + "fmodel.bin.gz"));
        this.artifactMap.put(PLURAL_NOUN_RESOLVER_MODEL_ENTRY_NAME, this.createModel(project + File.separator + "plmodel.bin.gz"));
        this.artifactMap.put(SINGULAR_PRONOUN_RESOLVER_MODEL_ENTRY_NAME, this.createModel(project + File.separator + "pmodel.bin.gz"));
        this.artifactMap.put(PROPER_NOUN_RESOLVER_MODEL_ENTRY_NAME, this.createModel(project + File.separator + "pnmodel.bin.gz"));
        this.artifactMap.put(SIM_MODEL_ENTRY_NAME, this.createModel(project + File.separator + "sim.bin.gz"));
        this.artifactMap.put(PLURAL_PRONOUN_RESOLVER_MODEL_ENTRY_NAME, this.createModel(project + File.separator + "tmodel.bin.gz"));
    }

    private AbstractModel createModel(String fileName) throws IOException {
        return new BinaryGISModelReader(new DataInputStream(new GZIPInputStream(new FileInputStream(fileName)))).getModel();
    }

    private static Dictionary readNames(String nameFile) throws IOException {
        Dictionary names = new Dictionary();
        BufferedReader nameReader = new BufferedReader(new FileReader(nameFile));
        String line = nameReader.readLine();
        while (line != null) {
            names.put(new StringList(line));
            line = nameReader.readLine();
        }
        return names;
    }

    public Dictionary getMaleNames() {
        return (Dictionary)this.artifactMap.get(MALE_NAMES_DICTIONARY_ENTRY_NAME);
    }

    public Dictionary getFemaleNames() {
        return (Dictionary)this.artifactMap.get(FEMALE_NAMES_DICTIONARY_ENTRY_NAME);
    }

    public AbstractModel getNumberModel() {
        return (AbstractModel)this.artifactMap.get(NUMBER_MODEL_ENTRY_NAME);
    }

    public AbstractModel getCommonNounResolverModel() {
        return (AbstractModel)this.artifactMap.get(COMMON_NOUN_RESOLVER_MODEL_ENTRY_NAME);
    }

    public AbstractModel getDefiniteNounResolverModel() {
        return (AbstractModel)this.artifactMap.get(DEFINITE_NOUN_RESOLVER_MODEL_ENTRY_NAME);
    }

    public AbstractModel getSpeechPronounResolverModel() {
        return (AbstractModel)this.artifactMap.get(SPEECH_PRONOUN_RESOLVER_MODEL_ENTRY_NAME);
    }

    public AbstractModel getPluralNounResolverModel() {
        return (AbstractModel)this.artifactMap.get(PLURAL_NOUN_RESOLVER_MODEL_ENTRY_NAME);
    }

    public AbstractModel getSingularPronounResolverModel() {
        return (AbstractModel)this.artifactMap.get(SINGULAR_PRONOUN_RESOLVER_MODEL_ENTRY_NAME);
    }

    public AbstractModel getProperNounResolverModel() {
        return (AbstractModel)this.artifactMap.get(PROPER_NOUN_RESOLVER_MODEL_ENTRY_NAME);
    }

    public AbstractModel getSimModel() {
        return (AbstractModel)this.artifactMap.get(SIM_MODEL_ENTRY_NAME);
    }

    public AbstractModel getPluralPronounResolverModel() {
        return (AbstractModel)this.artifactMap.get(PLURAL_PRONOUN_RESOLVER_MODEL_ENTRY_NAME);
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("Usage: CorefModel projectDirectory");
            System.exit(-1);
        }
        String projectDirectory = args[0];
        CorefModel model = new CorefModel("en", projectDirectory);
        model.serialize(new FileOutputStream("coref.model"));
    }
}

