/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.cmdline.AbstractConverterTool;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.formats.Conll02NameSampleStreamFactory;
import opennlp.tools.formats.Conll03NameSampleStreamFactory;
import opennlp.tools.formats.ad.ADNameSampleStreamFactory;
import opennlp.tools.namefind.NameSample;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenNameFinderConverterTool
extends AbstractConverterTool<NameSample> {
    private static final Map<String, ObjectStreamFactory<NameSample>> streamFactories;

    @Override
    public String getName() {
        return "TokenNameFinderConverter";
    }

    @Override
    public String getShortDescription() {
        return "converts foreign data formats to native format";
    }

    @Override
    protected ObjectStreamFactory<NameSample> createStreamFactory(String format) {
        return streamFactories.get(format);
    }

    static {
        HashMap<String, ObjectStreamFactory<NameSample>> mutableStreamFactories = new HashMap<String, ObjectStreamFactory<NameSample>>();
        mutableStreamFactories.put("conll02", new Conll02NameSampleStreamFactory());
        mutableStreamFactories.put("conll03", new Conll03NameSampleStreamFactory());
        mutableStreamFactories.put("ad", new ADNameSampleStreamFactory());
        streamFactories = Collections.unmodifiableMap(mutableStreamFactories);
    }
}

