/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import opennlp.tools.cmdline.CmdLineUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentParser
implements InvocationHandler {
    private final Map<String, Object> arguments;

    private ArgumentParser(Map<String, Object> arguments) {
        this.arguments = arguments;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (args != null) {
            throw new IllegalStateException();
        }
        return this.arguments.get(method.getName());
    }

    private static <T> void checkProxyInterface(Class<T> proxyInterface) {
        if (!proxyInterface.isInterface()) {
            throw new IllegalArgumentException("proxy interface is not an interface!");
        }
        Method[] methods = proxyInterface.getMethods();
        if (methods.length == 0) {
            throw new IllegalArgumentException("proxy interface must at least declare one method!");
        }
        for (Method method : methods) {
            if (!method.getName().startsWith("get") && method.getName().length() > 3) {
                throw new IllegalArgumentException(method.getName() + " method name does not start with get!");
            }
            if (method.getParameterTypes().length != 0) {
                throw new IllegalArgumentException(method.getName() + " method must have zero parameters!");
            }
            Class<?> returnType = method.getReturnType();
            HashSet<Class<String>> compatibleReturnTypes = new HashSet<Class<String>>();
            compatibleReturnTypes.add(Integer.class);
            compatibleReturnTypes.add(Boolean.class);
            compatibleReturnTypes.add(String.class);
            if (compatibleReturnTypes.contains(returnType)) continue;
            throw new IllegalArgumentException(method.getName() + " method must have compatible return type!");
        }
    }

    private static String methodNameToParameter(String methodName) {
        char[] parameterNameChars = methodName.toCharArray();
        parameterNameChars[3] = Character.toLowerCase(parameterNameChars[3]);
        String parameterName = "-" + new String(parameterNameChars).substring(3);
        return parameterName;
    }

    public static <T> String createUsage(Class<T> argProxyInterface) {
        ArgumentParser.checkProxyInterface(argProxyInterface);
        StringBuilder usage = new StringBuilder();
        for (Method method : argProxyInterface.getMethods()) {
            ParameterDescription desc = method.getAnnotation(ParameterDescription.class);
            OptionalParameter optional = method.getAnnotation(OptionalParameter.class);
            if (desc == null) continue;
            if (optional != null) {
                usage.append('[');
            }
            usage.append(ArgumentParser.methodNameToParameter(method.getName()));
            usage.append(' ');
            usage.append(desc.valueName());
            if (optional != null) {
                usage.append(']');
            }
            usage.append(' ');
        }
        if (usage.length() > 0) {
            usage.setLength(usage.length() - 1);
        }
        return usage.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> Map<String, Object> createArgumentMap(String[] args, Class<T> argProxyInterface) {
        if (args.length < 2 || args.length % 2 != 0) {
            return null;
        }
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        for (Method method : argProxyInterface.getMethods()) {
            Object value;
            String valueString = CmdLineUtil.getParameter(ArgumentParser.methodNameToParameter(method.getName()), args);
            if (valueString == null) {
                OptionalParameter optionalParam = method.getAnnotation(OptionalParameter.class);
                if (optionalParam == null) {
                    return null;
                }
                valueString = optionalParam.defaultValue().length() > 0 ? optionalParam.defaultValue() : null;
            }
            Class<?> returnType = method.getReturnType();
            if (valueString != null) {
                if (Integer.class.equals(returnType)) {
                    try {
                        value = Integer.parseInt(valueString);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                } else if (Boolean.class.equals(returnType)) {
                    value = Boolean.parseBoolean(valueString);
                } else {
                    if (!String.class.equals(returnType)) throw new IllegalStateException();
                    value = valueString;
                }
            } else {
                value = null;
            }
            arguments.put(method.getName(), value);
        }
        return arguments;
    }

    public static <T> boolean validateArguments(String[] args, Class<T> argProxyInterface) {
        return ArgumentParser.createArgumentMap(args, argProxyInterface) != null;
    }

    public static <T> T parse(String[] args, Class<T> argProxyInterface) {
        ArgumentParser.checkProxyInterface(argProxyInterface);
        Map<String, Object> argumentMap = ArgumentParser.createArgumentMap(args, argProxyInterface);
        if (argumentMap != null) {
            return (T)Proxy.newProxyInstance(argProxyInterface.getClassLoader(), new Class[]{argProxyInterface}, (InvocationHandler)new ArgumentParser(argumentMap));
        }
        return null;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ParameterDescription {
        public String valueName();

        public String description() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface OptionalParameter {
        public String defaultValue() default "";
    }
}

