/*
 * Decompiled with CFR 0.152.
 */
package opennlp.perceptron;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opennlp.model.AbstractModel;
import opennlp.model.AbstractModelWriter;
import opennlp.model.ComparablePredicate;
import opennlp.model.Context;
import opennlp.model.IndexHashTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PerceptronModelWriter
extends AbstractModelWriter {
    protected Context[] PARAMS;
    protected String[] OUTCOME_LABELS;
    protected String[] PRED_LABELS;
    int numOutcomes;

    public PerceptronModelWriter(AbstractModel model) {
        Object[] data = model.getDataStructures();
        this.numOutcomes = model.getNumOutcomes();
        this.PARAMS = (Context[])data[0];
        IndexHashTable pmap = (IndexHashTable)data[1];
        this.OUTCOME_LABELS = (String[])data[2];
        this.PRED_LABELS = new String[pmap.size()];
        pmap.toArray(this.PRED_LABELS);
    }

    protected ComparablePredicate[] sortValues() {
        int pid;
        ComparablePredicate[] tmpPreds = new ComparablePredicate[this.PARAMS.length];
        int[] tmpOutcomes = new int[this.numOutcomes];
        double[] tmpParams = new double[this.numOutcomes];
        int numPreds = 0;
        for (pid = 0; pid < this.PARAMS.length; ++pid) {
            int numParams = 0;
            double[] predParams = this.PARAMS[pid].getParameters();
            int[] outcomePattern = this.PARAMS[pid].getOutcomes();
            for (int pi = 0; pi < predParams.length; ++pi) {
                if (predParams[pi] == 0.0) continue;
                tmpOutcomes[numParams] = outcomePattern[pi];
                tmpParams[numParams] = predParams[pi];
                ++numParams;
            }
            int[] activeOutcomes = new int[numParams];
            double[] activeParams = new double[numParams];
            for (int pi = 0; pi < numParams; ++pi) {
                activeOutcomes[pi] = tmpOutcomes[pi];
                activeParams[pi] = tmpParams[pi];
            }
            if (numParams == 0) continue;
            tmpPreds[numPreds] = new ComparablePredicate(this.PRED_LABELS[pid], activeOutcomes, activeParams);
            ++numPreds;
        }
        System.err.println("Compressed " + this.PARAMS.length + " parameters to " + numPreds);
        Object[] sortPreds = new ComparablePredicate[numPreds];
        for (pid = 0; pid < numPreds; ++pid) {
            sortPreds[pid] = tmpPreds[pid];
        }
        Arrays.sort(sortPreds);
        return sortPreds;
    }

    protected List<List<ComparablePredicate>> computeOutcomePatterns(ComparablePredicate[] sorted) {
        ComparablePredicate cp = sorted[0];
        ArrayList<List<ComparablePredicate>> outcomePatterns = new ArrayList<List<ComparablePredicate>>();
        ArrayList<ComparablePredicate> newGroup = new ArrayList<ComparablePredicate>();
        for (int i = 0; i < sorted.length; ++i) {
            if (cp.compareTo(sorted[i]) == 0) {
                newGroup.add(sorted[i]);
                continue;
            }
            cp = sorted[i];
            outcomePatterns.add(newGroup);
            newGroup = new ArrayList();
            newGroup.add(sorted[i]);
        }
        outcomePatterns.add(newGroup);
        System.err.println(outcomePatterns.size() + " outcome patterns");
        return outcomePatterns;
    }

    @Override
    public void persist() throws IOException {
        int i;
        this.writeUTF("Perceptron");
        this.writeInt(this.OUTCOME_LABELS.length);
        for (int i2 = 0; i2 < this.OUTCOME_LABELS.length; ++i2) {
            this.writeUTF(this.OUTCOME_LABELS[i2]);
        }
        ComparablePredicate[] sorted = this.sortValues();
        List<List<ComparablePredicate>> compressed = this.computeOutcomePatterns(sorted);
        this.writeInt(compressed.size());
        for (i = 0; i < compressed.size(); ++i) {
            List<ComparablePredicate> a = compressed.get(i);
            this.writeUTF(a.size() + a.get(0).toString());
        }
        this.writeInt(sorted.length);
        for (i = 0; i < sorted.length; ++i) {
            this.writeUTF(sorted[i].name);
        }
        for (i = 0; i < sorted.length; ++i) {
            for (int j = 0; j < sorted[i].params.length; ++j) {
                this.writeDouble(sorted[i].params[j]);
            }
        }
        this.close();
    }
}

