/*
 * Decompiled with CFR 0.152.
 */
package opennlp.model;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opennlp.model.ComparableEvent;
import opennlp.model.DataIndexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataIndexer
implements DataIndexer {
    private int numEvents;
    protected int[][] contexts;
    protected int[] outcomeList;
    protected int[] numTimesEventsSeen;
    protected String[] predLabels;
    protected String[] outcomeLabels;
    protected int[] predCounts;

    @Override
    public int[][] getContexts() {
        return this.contexts;
    }

    @Override
    public int[] getNumTimesEventsSeen() {
        return this.numTimesEventsSeen;
    }

    @Override
    public int[] getOutcomeList() {
        return this.outcomeList;
    }

    @Override
    public String[] getPredLabels() {
        return this.predLabels;
    }

    @Override
    public String[] getOutcomeLabels() {
        return this.outcomeLabels;
    }

    @Override
    public int[] getPredCounts() {
        return this.predCounts;
    }

    protected int sortAndMerge(List eventsToCompare, boolean sort) {
        int numUniqueEvents = 1;
        this.numEvents = eventsToCompare.size();
        if (sort) {
            Collections.sort(eventsToCompare);
            if (this.numEvents <= 1) {
                return numUniqueEvents;
            }
            ComparableEvent ce = (ComparableEvent)eventsToCompare.get(0);
            for (int i = 1; i < this.numEvents; ++i) {
                ComparableEvent ce2 = (ComparableEvent)eventsToCompare.get(i);
                if (ce.compareTo(ce2) == 0) {
                    ++ce.seen;
                    eventsToCompare.set(i, null);
                    continue;
                }
                ce = ce2;
                ++numUniqueEvents;
            }
        } else {
            numUniqueEvents = eventsToCompare.size();
        }
        if (sort) {
            System.out.println("done. Reduced " + this.numEvents + " events to " + numUniqueEvents + ".");
        }
        this.contexts = new int[numUniqueEvents][];
        this.outcomeList = new int[numUniqueEvents];
        this.numTimesEventsSeen = new int[numUniqueEvents];
        int j = 0;
        for (int i = 0; i < this.numEvents; ++i) {
            ComparableEvent evt = (ComparableEvent)eventsToCompare.get(i);
            if (null == evt) continue;
            this.numTimesEventsSeen[j] = evt.seen;
            this.outcomeList[j] = evt.outcome;
            this.contexts[j] = evt.predIndexes;
            ++j;
        }
        return numUniqueEvents;
    }

    @Override
    public int getNumEvents() {
        return this.numEvents;
    }

    protected static void update(String[] ec, Set predicateSet, Map<String, Integer> counter, int cutoff) {
        for (int j = 0; j < ec.length; ++j) {
            Integer i = counter.get(ec[j]);
            if (i == null) {
                counter.put(ec[j], 1);
            } else {
                counter.put(ec[j], i + 1);
            }
            if (predicateSet.contains(ec[j]) || counter.get(ec[j]) < cutoff) continue;
            predicateSet.add(ec[j]);
        }
    }

    protected static String[] toIndexedStringArray(Map<String, Integer> labelToIndexMap) {
        String[] array = new String[labelToIndexMap.size()];
        Iterator<String> i$ = labelToIndexMap.keySet().iterator();
        while (i$.hasNext()) {
            String label;
            array[labelToIndexMap.get((Object)label).intValue()] = label = i$.next();
        }
        return array;
    }

    @Override
    public float[][] getValues() {
        return null;
    }
}

