/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.lib.conf.Value;

public class DoubleValue
extends Value {
    private double value;

    public DoubleValue(String prop) {
        super(prop);
    }

    public Class<Double> getValueType() {
        return Double.TYPE;
    }

    public void set(double value) {
        this.assertChangeable();
        double oldValue = this.value;
        this.value = value;
        if (oldValue != value) {
            this.valueChanged();
        }
    }

    @Override
    public Double get() {
        return this.value;
    }

    @Override
    protected String getInternalString() {
        return String.valueOf(this.value);
    }

    @Override
    protected void setInternalString(String val) {
        if (StringUtils.isEmpty(val)) {
            this.set(0.0);
        } else {
            this.set(Double.parseDouble(val));
        }
    }

    @Override
    protected void setInternalObject(Object obj) {
        if (obj == null) {
            this.set(0.0);
        } else {
            this.set(((Number)obj).doubleValue());
        }
    }
}

