/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.bval.jsr303.ConfigurationImpl;
import org.apache.bval.jsr303.util.IOUtils;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.bval.jsr303.xml.PropertyType;
import org.apache.bval.jsr303.xml.ValidationConfigType;
import org.apache.bval.util.PrivilegedActions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class ValidationParser {
    private static final String DEFAULT_VALIDATION_XML_FILE = "META-INF/validation.xml";
    private static final String VALIDATION_CONFIGURATION_XSD = "META-INF/validation-configuration-1.0.xsd";
    private static final Log log = LogFactory.getLog(ValidationParser.class);
    private final String validationXmlFile;

    public ValidationParser(String file) {
        this.validationXmlFile = file == null ? DEFAULT_VALIDATION_XML_FILE : file;
    }

    public void processValidationConfig(ConfigurationImpl targetConfig) {
        ValidationConfigType xmlConfig = this.parseXmlConfig();
        if (xmlConfig != null) {
            this.applyConfig(xmlConfig, targetConfig);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ValidationConfigType parseXmlConfig() {
        ValidationConfigType validationConfigType;
        InputStream inputStream;
        block8: {
            inputStream = null;
            inputStream = this.getInputStream(this.validationXmlFile);
            if (inputStream != null) break block8;
            if (log.isDebugEnabled()) {
                log.debug("No " + this.validationXmlFile + " found. Using annotation based configuration only.");
            }
            ValidationConfigType validationConfigType2 = null;
            IOUtils.closeQuietly(inputStream);
            return validationConfigType2;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug(this.validationXmlFile + " found.");
            }
            Schema schema = this.getSchema();
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ValidationConfigType.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            StreamSource stream = new StreamSource(inputStream);
            JAXBElement root = unmarshaller.unmarshal((Source)stream, ValidationConfigType.class);
            validationConfigType = (ValidationConfigType)root.getValue();
        }
        catch (JAXBException e) {
            try {
                throw new ValidationException("Unable to parse " + this.validationXmlFile, e);
                catch (IOException e2) {
                    throw new ValidationException("Unable to parse " + this.validationXmlFile, e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        return validationConfigType;
    }

    private InputStream getInputStream(String path) throws IOException {
        Enumeration<URL> urls;
        ClassLoader loader = PrivilegedActions.getClassLoader(this.getClass());
        InputStream inputStream = loader.getResourceAsStream(path);
        if (inputStream != null && path.equals(DEFAULT_VALIDATION_XML_FILE) && (urls = loader.getResources(path)).hasMoreElements() && urls.nextElement() != null && urls.hasMoreElements()) {
            throw new ValidationException("More than one " + path + " is found in the classpath");
        }
        return inputStream;
    }

    private Schema getSchema() {
        return ValidationParser.getSchema(VALIDATION_CONFIGURATION_XSD);
    }

    static Schema getSchema(String xsd) {
        ClassLoader loader = PrivilegedActions.getClassLoader(ValidationParser.class);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaUrl = loader.getResource(xsd);
        try {
            return sf.newSchema(schemaUrl);
        }
        catch (SAXException e) {
            log.warn("Unable to parse schema: " + xsd, e);
            return null;
        }
    }

    private void applyConfig(ValidationConfigType xmlConfig, ConfigurationImpl targetConfig) {
        this.applyProviderClass(xmlConfig, targetConfig);
        this.applyMessageInterpolator(xmlConfig, targetConfig);
        this.applyTraversableResolver(xmlConfig, targetConfig);
        this.applyConstraintFactory(xmlConfig, targetConfig);
        this.applyMappingStreams(xmlConfig, targetConfig);
        this.applyProperties(xmlConfig, targetConfig);
    }

    private void applyProperties(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        for (PropertyType property : xmlConfig.getProperty()) {
            if (log.isDebugEnabled()) {
                log.debug("Found property '" + property.getName() + "' with value '" + property.getValue() + "' in " + this.validationXmlFile);
            }
            target.addProperty(property.getName(), property.getValue());
        }
    }

    private void applyProviderClass(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        String providerClassName = xmlConfig.getDefaultProvider();
        if (providerClassName != null) {
            Class<?> clazz = SecureActions.loadClass(providerClassName, this.getClass());
            target.setProviderClass(clazz);
            if (log.isInfoEnabled()) {
                log.info("Using " + providerClassName + " as validation provider.");
            }
        }
    }

    private void applyMessageInterpolator(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        String messageInterpolatorClass = xmlConfig.getMessageInterpolator();
        if (target.getMessageInterpolator() == null && messageInterpolatorClass != null) {
            Class<?> clazz = SecureActions.loadClass(messageInterpolatorClass, this.getClass());
            target.messageInterpolator((MessageInterpolator)SecureActions.newInstance(clazz));
            if (log.isInfoEnabled()) {
                log.info("Using " + messageInterpolatorClass + " as message interpolator.");
            }
        }
    }

    private void applyTraversableResolver(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        String traversableResolverClass = xmlConfig.getTraversableResolver();
        if (target.getTraversableResolver() == null && traversableResolverClass != null) {
            Class<?> clazz = SecureActions.loadClass(traversableResolverClass, this.getClass());
            target.traversableResolver((TraversableResolver)SecureActions.newInstance(clazz));
            if (log.isInfoEnabled()) {
                log.info("Using " + traversableResolverClass + " as traversable resolver.");
            }
        }
    }

    private void applyConstraintFactory(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        String constraintFactoryClass = xmlConfig.getConstraintValidatorFactory();
        if (target.getConstraintValidatorFactory() == null && constraintFactoryClass != null) {
            Class<?> clazz = SecureActions.loadClass(constraintFactoryClass, this.getClass());
            target.constraintValidatorFactory((ConstraintValidatorFactory)SecureActions.newInstance(clazz));
            if (log.isInfoEnabled()) {
                log.info("Using " + constraintFactoryClass + " as constraint factory.");
            }
        }
    }

    private void applyMappingStreams(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        for (JAXBElement<String> mappingFileNameElement : xmlConfig.getConstraintMapping()) {
            String mappingFileName = (String)mappingFileNameElement.getValue();
            if (mappingFileName.startsWith("/")) {
                mappingFileName = mappingFileName.substring(1);
            }
            if (log.isDebugEnabled()) {
                log.debug("Trying to open input stream for " + mappingFileName);
            }
            InputStream in = null;
            try {
                in = this.getInputStream(mappingFileName);
                if (in == null) {
                    throw new ValidationException("Unable to open input stream for mapping file " + mappingFileName);
                }
            }
            catch (IOException e) {
                throw new ValidationException("Unable to open input stream for mapping file " + mappingFileName, e);
            }
            target.addMapping(in);
        }
    }
}

