/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.util.HashSet;
import java.util.Set;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import org.apache.bval.jsr303.ConstraintFinderImpl;
import org.apache.bval.jsr303.ConstraintValidation;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.Validation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementDescriptorImpl
implements ElementDescriptor {
    protected final MetaBean metaBean;
    protected final Class<?> elementClass;
    private Set<ConstraintDescriptor<?>> constraintDescriptors;

    protected ElementDescriptorImpl(MetaBean metaBean, Class<?> elementClass, Validation[] validations) {
        this.metaBean = metaBean;
        this.elementClass = elementClass;
        this.createConstraintDescriptors(validations);
    }

    protected ElementDescriptorImpl(Class<?> elementClass, Validation[] validations) {
        this.metaBean = null;
        this.elementClass = elementClass;
        this.createConstraintDescriptors(validations);
    }

    @Override
    public Class<?> getElementClass() {
        return this.elementClass;
    }

    @Override
    public ElementDescriptor.ConstraintFinder findConstraints() {
        return new ConstraintFinderImpl(this.metaBean, this.constraintDescriptors);
    }

    @Override
    public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
        return this.constraintDescriptors;
    }

    @Override
    public boolean hasConstraints() {
        return !this.constraintDescriptors.isEmpty();
    }

    private void createConstraintDescriptors(Validation[] validations) {
        HashSet cds = new HashSet(validations.length);
        for (Validation validation : validations) {
            if (!(validation instanceof ConstraintValidation)) continue;
            ConstraintValidation cval = (ConstraintValidation)validation;
            cds.add(cval);
        }
        this.setConstraintDescriptors(cds);
    }

    public void setConstraintDescriptors(Set<ConstraintDescriptor<?>> constraintDescriptors) {
        this.constraintDescriptors = constraintDescriptors;
    }

    public MetaBean getMetaBean() {
        return this.metaBean;
    }
}

