/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval;

import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.bval.model.FeaturesCapable;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.model.ValidationContext;
import org.apache.bval.model.ValidationListener;
import org.apache.bval.util.AccessStrategy;
import org.apache.bval.util.PropertyAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidationContext<T extends ValidationListener>
implements ValidationContext<T> {
    private static final Object UNKNOWN = new Object();
    private MetaBean metaBean;
    private Object bean;
    private MetaProperty metaProperty;
    private Object propertyValue = UNKNOWN;
    private AccessStrategy access;
    protected Map validatedObjects;
    private boolean fixed;
    private T listener;

    public BeanValidationContext(T listener) {
        this(listener, new IdentityHashMap());
    }

    protected BeanValidationContext(T listener, Map validatedMap) {
        this.listener = listener;
        this.validatedObjects = validatedMap;
    }

    @Override
    public T getListener() {
        return this.listener;
    }

    public void setListener(T listener) {
        this.listener = listener;
    }

    @Override
    public boolean collectValidated() {
        return this.validatedObjects.put(this.getBean(), Boolean.TRUE) == null;
    }

    public boolean isValidated(Object object) {
        return this.validatedObjects.containsKey(object);
    }

    public void resetValidated() {
        this.validatedObjects.clear();
    }

    @Override
    public void setBean(Object aBean, MetaBean aMetaBean) {
        this.bean = aBean;
        this.metaBean = aMetaBean;
        this.metaProperty = null;
        this.unknownValue();
    }

    @Override
    public Object getPropertyValue() {
        if (this.access == null) {
            return this.getPropertyValue(new PropertyAccess(this.bean.getClass(), this.metaProperty.getName()));
        }
        return this.getPropertyValue(this.access);
    }

    @Override
    public Object getPropertyValue(AccessStrategy access) throws IllegalArgumentException, IllegalStateException {
        if (this.propertyValue == UNKNOWN || this.access != access && !this.fixed) {
            this.propertyValue = access.get(this.bean);
            this.access = access;
        }
        return this.propertyValue;
    }

    @Override
    public String getPropertyName() {
        return this.metaProperty == null ? null : this.metaProperty.getName();
    }

    public void setPropertyValue(Object propertyValue) {
        this.propertyValue = propertyValue;
    }

    public void setFixedValue(Object value) {
        this.setPropertyValue(value);
        this.setFixed(true);
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public FeaturesCapable getMeta() {
        return this.metaProperty == null ? this.metaBean : this.metaProperty;
    }

    public void unknownValue() {
        this.propertyValue = UNKNOWN;
        this.access = null;
    }

    @Override
    public MetaBean getMetaBean() {
        return this.metaBean;
    }

    @Override
    public Object getBean() {
        return this.bean;
    }

    @Override
    public MetaProperty getMetaProperty() {
        return this.metaProperty;
    }

    @Override
    public void setMetaBean(MetaBean metaBean) {
        this.metaBean = metaBean;
    }

    @Override
    public void setBean(Object bean) {
        this.bean = bean;
        this.unknownValue();
    }

    @Override
    public void setMetaProperty(MetaProperty metaProperty) {
        this.metaProperty = metaProperty;
        this.unknownValue();
    }

    public String toString() {
        return "BeanValidationContext{ bean=" + this.bean + ", metaProperty=" + this.metaProperty + ", propertyValue=" + this.propertyValue + '}';
    }

    @Override
    public void moveDown(MetaProperty prop, AccessStrategy access) {
        this.setMetaProperty(prop);
        this.setBean(this.getPropertyValue(access), prop.getMetaBean());
    }

    @Override
    public void moveUp(Object bean, MetaBean aMetaBean) {
        this.setBean(bean, aMetaBean);
    }

    @Override
    public void setCurrentIndex(Integer index) {
    }

    @Override
    public void setCurrentKey(Object key) {
    }

    @Override
    public AccessStrategy getAccess() {
        return this.access;
    }
}

