/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.FileTestUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.ChecksumObserver;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.util.FileUtils;
import org.easymock.AbstractMatcher;
import org.easymock.ArgumentsMatcher;
import org.easymock.MockControl;

public abstract class WagonTestCase
extends PlexusTestCase {
    protected static String POM = "pom.xml";
    protected Repository localRepository;
    protected Repository testRepository;
    protected String localRepositoryPath;
    protected File sourceFile;
    protected File destFile;
    protected String resource;
    protected File artifactSourceFile;
    protected File artifactDestFile;
    protected ChecksumObserver checksumObserver;
    protected TransferListener mockTransferListener;
    protected MockControl mockTransferListenerControl;

    protected void setUp() throws Exception {
        this.checksumObserver = new ChecksumObserver();
        this.mockTransferListenerControl = MockControl.createControl((Class)TransferListener.class);
        this.mockTransferListener = (TransferListener)this.mockTransferListenerControl.getMock();
        super.setUp();
    }

    protected abstract String getTestRepositoryUrl() throws IOException;

    protected abstract String getProtocol();

    protected void setupRepositories() throws Exception {
        this.resource = "test-resource";
        this.testRepository = new Repository();
        this.testRepository.setUrl(this.getTestRepositoryUrl());
        this.testRepository.setPermissions(this.getPermissions());
        this.localRepositoryPath = FileTestUtils.createDir("local-repository").getPath();
        this.localRepository = this.createFileRepository("file://" + this.localRepositoryPath);
        this.message("Local repository: " + this.localRepository);
        File f = new File(this.localRepositoryPath);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    protected void customizeContext() throws Exception {
        this.getContainer().addContextValue((Object)"test.repository", (Object)this.localRepositoryPath);
    }

    protected void setupWagonTestingFixtures() throws Exception {
    }

    protected void tearDownWagonTestingFixtures() throws Exception {
    }

    protected AuthenticationInfo getAuthInfo() {
        return new AuthenticationInfo();
    }

    protected RepositoryPermissions getPermissions() {
        return new RepositoryPermissions();
    }

    protected Wagon getWagon() throws Exception {
        Wagon wagon = (Wagon)this.lookup(Wagon.ROLE, this.getProtocol());
        Debug debug = new Debug();
        wagon.addSessionListener((SessionListener)debug);
        wagon.addTransferListener((TransferListener)debug);
        return wagon;
    }

    protected void message(String message) {
        System.out.println(message);
    }

    public void testWagon() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        this.fileRoundTripTesting();
        this.tearDownWagonTestingFixtures();
    }

    public void testWagonGetIfNewerIsNewer() throws Exception {
        if (this.supportsGetIfNewer()) {
            this.setupRepositories();
            this.setupWagonTestingFixtures();
            int expectedSize = this.putFile();
            this.getIfNewer(this.getExpectedLastModifiedOnGet(this.testRepository, new Resource(this.resource)) + 30000L, false, expectedSize);
        }
    }

    protected boolean supportsGetIfNewer() {
        return true;
    }

    public void testWagonGetIfNewerIsOlder() throws Exception {
        if (this.supportsGetIfNewer()) {
            this.setupRepositories();
            this.setupWagonTestingFixtures();
            int expectedSize = this.putFile();
            this.getIfNewer(new SimpleDateFormat("yyyy-MM-dd").parse("2006-01-01").getTime(), true, expectedSize);
        }
    }

    public void testWagonGetIfNewerIsSame() throws Exception {
        if (this.supportsGetIfNewer()) {
            this.setupRepositories();
            this.setupWagonTestingFixtures();
            int expectedSize = this.putFile();
            this.getIfNewer(this.getExpectedLastModifiedOnGet(this.testRepository, new Resource(this.resource)), false, expectedSize);
        }
    }

    private void getIfNewer(long timestamp, boolean expectedResult, int expectedSize) throws Exception, NoSuchAlgorithmException, IOException, ConnectionException, AuthenticationException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Wagon wagon = this.getWagon();
        ProgressArgumentMatcher progressArgumentMatcher = this.setupGetIfNewerTest(wagon, expectedResult, expectedSize);
        this.connectWagon(wagon);
        boolean result = wagon.getIfNewer(this.resource, this.destFile, timestamp);
        WagonTestCase.assertEquals((boolean)expectedResult, (boolean)result);
        this.disconnectWagon(wagon);
        this.assertGetIfNewerTest(progressArgumentMatcher, expectedResult, expectedSize);
        this.tearDownWagonTestingFixtures();
    }

    protected void assertGetIfNewerTest(ProgressArgumentMatcher progressArgumentMatcher, boolean expectedResult, int expectedSize) throws IOException {
        if (expectedResult) {
            this.verifyMock(progressArgumentMatcher, expectedSize);
            WagonTestCase.assertNotNull((String)"check checksum is not null", (Object)this.checksumObserver.getActualChecksum());
            WagonTestCase.assertEquals((String)"compare checksums", (String)"6b144b7285ffd6b0bc8300da162120b9", (String)this.checksumObserver.getActualChecksum());
            String sourceContent = FileUtils.fileRead((File)this.sourceFile);
            String destContent = FileUtils.fileRead((File)this.destFile);
            WagonTestCase.assertEquals((String)sourceContent, (String)destContent);
        } else {
            this.mockTransferListenerControl.verify();
            this.mockTransferListenerControl.reset();
            WagonTestCase.assertNull((String)"check checksum is null", (Object)this.checksumObserver.getActualChecksum());
            WagonTestCase.assertFalse((boolean)this.destFile.exists());
        }
    }

    protected ProgressArgumentMatcher setupGetIfNewerTest(Wagon wagon, boolean expectedResult, int expectedSize) throws NoSuchAlgorithmException, IOException {
        this.checksumObserver = new ChecksumObserver();
        this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
        this.destFile.delete();
        WagonTestCase.assertFalse((boolean)this.destFile.exists());
        this.destFile.deleteOnExit();
        ProgressArgumentMatcher progressArgumentMatcher = null;
        if (expectedResult) {
            progressArgumentMatcher = this.replaceMockForGet(wagon, expectedSize);
        } else {
            this.replaceMockForSkippedGetIfNewer(wagon, expectedSize);
        }
        return progressArgumentMatcher;
    }

    private void replaceMockForSkippedGetIfNewer(Wagon wagon, int expectedSize) {
        Resource resource = new Resource(this.resource);
        this.mockTransferListener.transferInitiated(this.createTransferEvent(wagon, resource, 0, 5, this.destFile));
        resource = new Resource(this.resource);
        resource.setContentLength((long)this.getExpectedContentLengthOnGet(expectedSize));
        resource.setLastModified(this.getExpectedLastModifiedOnGet(this.testRepository, resource));
        this.mockTransferListener.debug(null);
        this.mockTransferListenerControl.setMatcher(MockControl.ALWAYS_MATCHER);
        this.mockTransferListenerControl.setVoidCallable(MockControl.ZERO_OR_MORE);
        this.mockTransferListenerControl.replay();
    }

    public void testWagonPutDirectory() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        Wagon wagon = this.getWagon();
        if (wagon.supportsDirectoryCopy()) {
            this.sourceFile = new File(FileTestUtils.getTestOutputDir(), "directory-copy");
            FileUtils.deleteDirectory((File)this.sourceFile);
            this.writeTestFile("test-resource-1.txt");
            this.writeTestFile("a/test-resource-2.txt");
            this.writeTestFile("a/b/test-resource-3.txt");
            this.writeTestFile("c/test-resource-4.txt");
            this.writeTestFile("d/e/f/test-resource-5.txt");
            wagon.connect(this.testRepository, this.getAuthInfo());
            wagon.putDirectory(this.sourceFile, "directory-copy");
            this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
            this.destFile.deleteOnExit();
            wagon.get("directory-copy/test-resource-1.txt", this.destFile);
            wagon.get("directory-copy/a/test-resource-2.txt", this.destFile);
            wagon.get("directory-copy/a/b/test-resource-3.txt", this.destFile);
            wagon.get("directory-copy/c/test-resource-4.txt", this.destFile);
            wagon.get("directory-copy/d/e/f/test-resource-5.txt", this.destFile);
            wagon.disconnect();
        }
        this.tearDownWagonTestingFixtures();
    }

    public void testWagonPutDirectoryDeepDestination() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        Wagon wagon = this.getWagon();
        if (wagon.supportsDirectoryCopy()) {
            this.sourceFile = new File(FileTestUtils.getTestOutputDir(), "deep0/deep1/deep2");
            FileUtils.deleteDirectory((File)this.sourceFile);
            this.writeTestFile("test-resource-1.txt");
            this.writeTestFile("a/test-resource-2.txt");
            this.writeTestFile("a/b/test-resource-3.txt");
            this.writeTestFile("c/test-resource-4.txt");
            this.writeTestFile("d/e/f/test-resource-5.txt");
            wagon.connect(this.testRepository, this.getAuthInfo());
            wagon.putDirectory(this.sourceFile, "deep0/deep1/deep2");
            this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
            this.destFile.deleteOnExit();
            wagon.get("deep0/deep1/deep2/test-resource-1.txt", this.destFile);
            wagon.get("deep0/deep1/deep2/a/test-resource-2.txt", this.destFile);
            wagon.get("deep0/deep1/deep2/a/b/test-resource-3.txt", this.destFile);
            wagon.get("deep0/deep1/deep2/c/test-resource-4.txt", this.destFile);
            wagon.get("deep0/deep1/deep2/d/e/f/test-resource-5.txt", this.destFile);
            wagon.disconnect();
        }
        this.tearDownWagonTestingFixtures();
    }

    public void testWagonPutDirectoryWhenDirectoryAlreadyExists() throws Exception {
        String dirName = "directory-copy-existing";
        String resourceToCreate = "test-resource-1.txt";
        String[] resources = new String[]{"a/test-resource-2.txt", "a/b/test-resource-3.txt", "c/test-resource-4.txt"};
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        Wagon wagon = this.getWagon();
        if (wagon.supportsDirectoryCopy()) {
            this.sourceFile = new File(FileTestUtils.getTestOutputDir(), "directory-copy-existing");
            FileUtils.deleteDirectory((File)this.sourceFile);
            this.createDirectory(wagon, "test-resource-1.txt", "directory-copy-existing");
            for (int i = 0; i < resources.length; ++i) {
                this.writeTestFile(resources[i]);
            }
            wagon.connect(this.testRepository, this.getAuthInfo());
            wagon.putDirectory(this.sourceFile, "directory-copy-existing");
            ArrayList<String> resourceNames = new ArrayList<String>(resources.length + 1);
            resourceNames.add("directory-copy-existing/test-resource-1.txt");
            for (int i = 0; i < resources.length; ++i) {
                resourceNames.add("directory-copy-existing/" + resources[i]);
            }
            this.assertResourcesAreInRemoteSide(wagon, resourceNames);
            wagon.disconnect();
        }
        this.tearDownWagonTestingFixtures();
    }

    public void testWagonPutDirectoryForDot() throws Exception {
        String resourceToCreate = "test-resource-1.txt";
        String[] resources = new String[]{"a/test-resource-2.txt", "a/b/test-resource-3.txt", "c/test-resource-4.txt"};
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        Wagon wagon = this.getWagon();
        if (wagon.supportsDirectoryCopy()) {
            this.sourceFile = new File(FileTestUtils.getTestOutputDir(), "dot-repo");
            FileUtils.deleteDirectory((File)this.sourceFile);
            this.createDirectory(wagon, "test-resource-1.txt", ".");
            for (int i = 0; i < resources.length; ++i) {
                this.writeTestFile(resources[i]);
            }
            wagon.connect(this.testRepository, this.getAuthInfo());
            wagon.putDirectory(this.sourceFile, ".");
            ArrayList<String> resourceNames = new ArrayList<String>(resources.length + 1);
            resourceNames.add("test-resource-1.txt");
            for (int i = 0; i < resources.length; ++i) {
                resourceNames.add(resources[i]);
            }
            this.assertResourcesAreInRemoteSide(wagon, resourceNames);
            wagon.disconnect();
        }
        this.tearDownWagonTestingFixtures();
    }

    protected void createDirectory(Wagon wagon, String resourceToCreate, String dirName) throws Exception {
        this.writeTestFile(resourceToCreate);
    }

    protected void assertResourcesAreInRemoteSide(Wagon wagon, List resourceNames) throws IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Iterator iter = resourceNames.iterator();
        while (iter.hasNext()) {
            String resourceName = (String)iter.next();
            File destFile = FileTestUtils.createUniqueFile(this.getName(), resourceName);
            destFile.deleteOnExit();
            wagon.get(resourceName, destFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertNotExists(Wagon wagon, String resourceName) throws IOException, TransferFailedException, AuthorizationException {
        File tmpFile = File.createTempFile("wagon", null);
        try {
            wagon.get(resourceName, tmpFile);
            WagonTestCase.fail((String)("Resource exists: " + resourceName));
        }
        catch (ResourceDoesNotExistException e) {
        }
        finally {
            tmpFile.delete();
        }
    }

    private void writeTestFile(String child) throws IOException {
        File dir = new File(this.sourceFile, child);
        dir.getParentFile().mkdirs();
        FileUtils.fileWrite((String)dir.getAbsolutePath(), (String)child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailedGet() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        this.message("Getting test artifact from test repository " + this.testRepository);
        Wagon wagon = this.getWagon();
        wagon.addTransferListener((TransferListener)this.checksumObserver);
        wagon.connect(this.testRepository, this.getAuthInfo());
        this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
        this.destFile.deleteOnExit();
        try {
            wagon.get("fubar.txt", this.destFile);
            WagonTestCase.fail((String)"File was found when it shouldn't have been");
        }
        catch (ResourceDoesNotExistException e) {
            WagonTestCase.assertTrue((boolean)true);
        }
        finally {
            wagon.removeTransferListener((TransferListener)this.checksumObserver);
            wagon.disconnect();
            this.tearDownWagonTestingFixtures();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailedGetIfNewer() throws Exception {
        if (this.supportsGetIfNewer()) {
            this.setupRepositories();
            this.setupWagonTestingFixtures();
            this.message("Getting test artifact from test repository " + this.testRepository);
            Wagon wagon = this.getWagon();
            wagon.addTransferListener((TransferListener)this.checksumObserver);
            wagon.connect(this.testRepository, this.getAuthInfo());
            this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
            this.destFile.deleteOnExit();
            try {
                wagon.getIfNewer("fubar.txt", this.destFile, 0L);
                WagonTestCase.fail((String)"File was found when it shouldn't have been");
            }
            catch (ResourceDoesNotExistException e) {
                WagonTestCase.assertTrue((boolean)true);
            }
            finally {
                wagon.removeTransferListener((TransferListener)this.checksumObserver);
                wagon.disconnect();
                this.tearDownWagonTestingFixtures();
            }
        }
    }

    public void testWagonGetFileList() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        String dirName = "file-list";
        String[] filenames = new String[]{"test-resource.txt", "test-resource.pom", "test-resource b.txt", "more-resources.dat", ".index.txt"};
        for (int i = 0; i < filenames.length; ++i) {
            this.putFile(dirName + "/" + filenames[i], dirName + "/" + filenames[i], filenames[i] + "\n");
        }
        Wagon wagon = this.getWagon();
        wagon.connect(this.testRepository, this.getAuthInfo());
        List list = wagon.getFileList(dirName);
        WagonTestCase.assertNotNull((String)"file list should not be null.", (Object)list);
        WagonTestCase.assertTrue((String)("file list should contain more items (actually contains '" + list + "')."), (list.size() >= filenames.length ? 1 : 0) != 0);
        for (int i = 0; i < filenames.length; ++i) {
            WagonTestCase.assertTrue((String)("Filename '" + filenames[i] + "' should be in list."), (boolean)list.contains(filenames[i]));
        }
        list = wagon.getFileList("");
        WagonTestCase.assertNotNull((String)"file list should not be null.", (Object)list);
        WagonTestCase.assertTrue((String)("file list should contain items (actually contains '" + list + "')."), (!list.isEmpty() ? 1 : 0) != 0);
        WagonTestCase.assertTrue((boolean)list.contains("file-list/"));
        WagonTestCase.assertFalse((boolean)list.contains("file-list"));
        WagonTestCase.assertFalse((boolean)list.contains("."));
        WagonTestCase.assertFalse((boolean)list.contains(".."));
        WagonTestCase.assertFalse((boolean)list.contains("./"));
        WagonTestCase.assertFalse((boolean)list.contains("../"));
        wagon.disconnect();
        this.tearDownWagonTestingFixtures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWagonGetFileListWhenDirectoryDoesNotExist() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        String dirName = "file-list-unexisting";
        Wagon wagon = this.getWagon();
        wagon.connect(this.testRepository, this.getAuthInfo());
        try {
            wagon.getFileList(dirName);
            WagonTestCase.fail((String)"getFileList on unexisting directory must throw ResourceDoesNotExistException");
        }
        catch (ResourceDoesNotExistException resourceDoesNotExistException) {
        }
        finally {
            wagon.disconnect();
            this.tearDownWagonTestingFixtures();
        }
    }

    public void testWagonResourceExists() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        Wagon wagon = this.getWagon();
        this.putFile();
        wagon.connect(this.testRepository, this.getAuthInfo());
        WagonTestCase.assertTrue((String)(this.sourceFile.getName() + " does not exist"), (boolean)wagon.resourceExists(this.sourceFile.getName()));
        wagon.disconnect();
        this.tearDownWagonTestingFixtures();
    }

    public void testWagonResourceNotExists() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        Wagon wagon = this.getWagon();
        wagon.connect(this.testRepository, this.getAuthInfo());
        WagonTestCase.assertFalse((boolean)wagon.resourceExists("a/bad/resource/name/that/should/not/exist.txt"));
        wagon.disconnect();
        this.tearDownWagonTestingFixtures();
    }

    protected void putFile(String resourceName, String testFileName, String content) throws Exception {
        this.sourceFile = new File(FileTestUtils.getTestOutputDir(), testFileName);
        this.sourceFile.getParentFile().mkdirs();
        FileUtils.fileWrite((String)this.sourceFile.getAbsolutePath(), (String)content);
        Wagon wagon = this.getWagon();
        ProgressArgumentMatcher progressArgumentMatcher = this.replayMockForPut(resourceName, content, wagon);
        this.message("Putting test artifact: " + resourceName + " into test repository " + this.testRepository);
        this.connectWagon(wagon);
        wagon.put(this.sourceFile, resourceName);
        this.disconnectWagon(wagon);
        this.verifyMock(progressArgumentMatcher, content.length());
    }

    protected ProgressArgumentMatcher replayMockForPut(String resourceName, String content, Wagon wagon) {
        Resource resource = new Resource(resourceName);
        this.mockTransferListener.transferInitiated(this.createTransferEvent(wagon, resource, 0, 6, this.sourceFile));
        resource = new Resource(resourceName);
        resource.setContentLength((long)content.length());
        resource.setLastModified(this.sourceFile.lastModified());
        this.mockTransferListener.transferStarted(this.createTransferEvent(wagon, resource, 1, 6, this.sourceFile));
        this.mockTransferListener.transferProgress(this.createTransferEvent(wagon, resource, 3, 6, this.sourceFile), new byte[0], 0);
        ProgressArgumentMatcher progressArgumentMatcher = new ProgressArgumentMatcher();
        this.mockTransferListenerControl.setMatcher((ArgumentsMatcher)progressArgumentMatcher);
        this.mockTransferListener.debug(null);
        this.mockTransferListenerControl.setMatcher(MockControl.ALWAYS_MATCHER);
        this.mockTransferListenerControl.setVoidCallable(MockControl.ZERO_OR_MORE);
        this.mockTransferListener.transferCompleted(this.createTransferEvent(wagon, resource, 2, 6, this.sourceFile));
        this.mockTransferListenerControl.replay();
        return progressArgumentMatcher;
    }

    protected TransferEvent createTransferEvent(Wagon wagon, Resource resource, int eventType, int requestType, File file) {
        TransferEvent transferEvent = new TransferEvent(wagon, resource, eventType, requestType);
        transferEvent.setLocalFile(file);
        return transferEvent;
    }

    protected int putFile() throws Exception {
        String content = "test-resource.txt\n";
        this.putFile(this.resource, "test-resource", content);
        return content.length();
    }

    protected void getFile(int expectedSize) throws Exception {
        this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
        this.destFile.deleteOnExit();
        Wagon wagon = this.getWagon();
        ProgressArgumentMatcher progressArgumentMatcher = this.replaceMockForGet(wagon, expectedSize);
        this.message("Getting test artifact from test repository " + this.testRepository);
        this.connectWagon(wagon);
        wagon.get(this.resource, this.destFile);
        this.disconnectWagon(wagon);
        this.verifyMock(progressArgumentMatcher, expectedSize);
    }

    protected void verifyMock(ProgressArgumentMatcher progressArgumentMatcher, int length) {
        this.mockTransferListenerControl.verify();
        WagonTestCase.assertEquals((int)length, (int)progressArgumentMatcher.getSize());
        this.mockTransferListenerControl.reset();
    }

    protected void disconnectWagon(Wagon wagon) throws ConnectionException {
        wagon.removeTransferListener(this.mockTransferListener);
        wagon.removeTransferListener((TransferListener)this.checksumObserver);
        wagon.disconnect();
    }

    protected void connectWagon(Wagon wagon) throws ConnectionException, AuthenticationException {
        wagon.addTransferListener((TransferListener)this.checksumObserver);
        wagon.addTransferListener(this.mockTransferListener);
        wagon.connect(this.testRepository, this.getAuthInfo());
    }

    protected ProgressArgumentMatcher replaceMockForGet(Wagon wagon, int expectedSize) {
        Resource resource = new Resource(this.resource);
        this.mockTransferListener.transferInitiated(this.createTransferEvent(wagon, resource, 0, 5, this.destFile));
        resource = new Resource(this.resource);
        resource.setContentLength((long)this.getExpectedContentLengthOnGet(expectedSize));
        resource.setLastModified(this.getExpectedLastModifiedOnGet(this.testRepository, resource));
        this.mockTransferListener.transferStarted(this.createTransferEvent(wagon, resource, 1, 5, this.destFile));
        this.mockTransferListener.transferProgress(new TransferEvent(wagon, resource, 3, 5), new byte[0], 0);
        ProgressArgumentMatcher progressArgumentMatcher = new ProgressArgumentMatcher();
        this.mockTransferListenerControl.setMatcher((ArgumentsMatcher)progressArgumentMatcher);
        this.mockTransferListener.debug(null);
        this.mockTransferListenerControl.setMatcher(MockControl.ALWAYS_MATCHER);
        this.mockTransferListenerControl.setVoidCallable(MockControl.ZERO_OR_MORE);
        this.mockTransferListener.transferCompleted(this.createTransferEvent(wagon, resource, 2, 5, this.destFile));
        this.mockTransferListenerControl.replay();
        return progressArgumentMatcher;
    }

    protected int getExpectedContentLengthOnGet(int expectedSize) {
        return expectedSize;
    }

    protected long getExpectedLastModifiedOnGet(Repository repository, Resource resource) {
        return this.sourceFile.lastModified();
    }

    protected void fileRoundTripTesting() throws Exception {
        this.message("File round trip testing ...");
        int expectedSize = this.putFile();
        WagonTestCase.assertNotNull((String)"check checksum is not null", (Object)this.checksumObserver.getActualChecksum());
        WagonTestCase.assertEquals((String)"compare checksums", (String)"6b144b7285ffd6b0bc8300da162120b9", (String)this.checksumObserver.getActualChecksum());
        this.checksumObserver = new ChecksumObserver();
        this.getFile(expectedSize);
        WagonTestCase.assertNotNull((String)"check checksum is not null", (Object)this.checksumObserver.getActualChecksum());
        WagonTestCase.assertEquals((String)"compare checksums", (String)"6b144b7285ffd6b0bc8300da162120b9", (String)this.checksumObserver.getActualChecksum());
        String sourceContent = FileUtils.fileRead((File)this.sourceFile);
        String destContent = FileUtils.fileRead((File)this.destFile);
        WagonTestCase.assertEquals((String)sourceContent, (String)destContent);
    }

    protected Repository createFileRepository(String url) {
        File path = new File(url.substring(7));
        path.mkdirs();
        Repository repository = new Repository();
        repository.setUrl(url);
        return repository;
    }

    static final class ProgressArgumentMatcher
    extends AbstractMatcher {
        private int size;

        ProgressArgumentMatcher() {
        }

        protected boolean argumentMatches(Object expected, Object actual) {
            if (actual instanceof byte[]) {
                return true;
            }
            if (actual instanceof Integer) {
                this.size += ((Integer)actual).intValue();
                return true;
            }
            return super.argumentMatches(expected, actual);
        }

        public int getSize() {
            return this.size;
        }
    }
}

