/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.surefire.ConfigurableProviderInfo;
import org.apache.maven.plugin.surefire.InPluginVMSurefireStarter;
import org.apache.maven.plugin.surefire.ProviderInfo;
import org.apache.maven.plugin.surefire.ProviderList;
import org.apache.maven.plugin.surefire.Summary;
import org.apache.maven.plugin.surefire.SurefireDependencyResolver;
import org.apache.maven.plugin.surefire.SurefireExecutionParameters;
import org.apache.maven.plugin.surefire.booterclient.ChecksumCalculator;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.ForkStarter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.StartupReportConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.testset.RunOrderParameters;
import org.apache.maven.surefire.testset.TestArtifactInfo;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.surefire.util.NestedRuntimeException;
import org.apache.maven.surefire.util.RunOrder;
import org.apache.maven.toolchain.Toolchain;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractSurefireMojo
extends AbstractMojo
implements SurefireExecutionParameters {
    private SurefireDependencyResolver dependencyResolver;
    private Artifact surefireBooterArtifact;

    protected abstract String getPluginName();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.verifyParameters() && !this.hasExecutedBefore()) {
            this.logReportsDirectory();
            this.executeAfterPreconditionsChecked();
        }
    }

    boolean verifyParameters() throws MojoFailureException {
        if (this.isSkipExecution()) {
            this.getLog().info((CharSequence)"Tests are skipped.");
            return false;
        }
        if (!this.getTestClassesDirectory().exists()) {
            if (Boolean.TRUE.equals(this.getFailIfNoTests())) {
                throw new MojoFailureException("No tests to run!");
            }
            this.getLog().info((CharSequence)"No tests to run.");
        } else {
            this.ensureWorkingDirectoryExists();
            this.ensureParallelRunningCompatibility();
            this.warnIfUselessUseSystemClassLoaderParameter();
        }
        return true;
    }

    protected abstract boolean isSkipExecution();

    protected void executeAfterPreconditionsChecked() throws MojoExecutionException, MojoFailureException {
        this.createDependencyResolver();
        Summary summary = this.executeAllProviders();
        this.restoreOriginalSystemPropertiesWhenNotForking(summary);
        this.handleSummary(summary);
    }

    private void createDependencyResolver() {
        this.dependencyResolver = new SurefireDependencyResolver(this.getArtifactResolver(), this.getArtifactFactory(), this.getLog(), this.getLocalRepository(), this.getRemoteRepositories(), this.getMetadataSource(), this.getPluginName());
    }

    protected List createProviders() throws MojoFailureException {
        try {
            Artifact junitDepArtifact = this.getJunitDepArtifact();
            ProviderList wellKnownProviders = new ProviderList(new ProviderInfo[]{new TestNgProviderInfo(this.getTestNgArtifact()), new JUnitCoreProviderInfo(this.getJunitArtifact(), junitDepArtifact), new JUnit4ProviderInfo(this.getJunitArtifact(), junitDepArtifact), new JUnit3ProviderInfo()}, new DynamicProviderInfo(null));
            return wellKnownProviders.resolve(this.getLog());
        }
        catch (InvalidVersionSpecificationException e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    private Summary executeAllProviders() throws MojoExecutionException, MojoFailureException {
        List providers = this.createProviders();
        Summary summary = new Summary();
        Iterator iter = providers.iterator();
        while (iter.hasNext()) {
            ProviderInfo provider = (ProviderInfo)iter.next();
            this.executeProvider(provider, summary);
        }
        return summary;
    }

    private void executeProvider(ProviderInfo provider, Summary summary) throws MojoExecutionException, MojoFailureException {
        ForkConfiguration forkConfiguration = this.getForkConfiguration();
        summary.reportForkConfiguration(forkConfiguration);
        ClassLoaderConfiguration classLoaderConfiguration = this.getClassLoaderConfiguration(forkConfiguration);
        try {
            RunResult result;
            if ("never".equals(forkConfiguration.getForkMode())) {
                InPluginVMSurefireStarter surefireStarter = this.createInprocessStarter(provider, forkConfiguration, classLoaderConfiguration);
                result = surefireStarter.runSuitesInProcess();
            } else {
                ForkStarter forkStarter = this.createForkStarter(provider, forkConfiguration, classLoaderConfiguration);
                result = forkStarter.run();
            }
            summary.registerRunResult(result);
        }
        catch (SurefireBooterForkException e) {
            summary.registerException((Exception)((Object)e));
        }
        catch (SurefireExecutionException e) {
            summary.registerException((Exception)((Object)e));
        }
    }

    protected abstract void handleSummary(Summary var1) throws MojoExecutionException, MojoFailureException;

    protected void restoreOriginalSystemPropertiesWhenNotForking(Summary summary) {
        if (this.getOriginalSystemProperties() != null && summary.isForking()) {
            System.setProperties(this.getOriginalSystemProperties());
        }
    }

    protected void logReportsDirectory() {
        this.getLog().info((CharSequence)(StringUtils.capitalizeFirstLetter((String)this.getPluginName()) + " report directory: " + this.getReportsDirectory()));
    }

    final Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.getToolchainManager() != null) {
            tc = this.getToolchainManager().getToolchainFromBuildContext("jdk", this.getSession());
        }
        return tc;
    }

    private void convertTestNGParameters() {
        if (this.getProperties() == null) {
            this.setProperties(new Properties());
        }
        if (this.getParallel() != null) {
            this.getProperties().setProperty("parallel", this.getParallel());
        }
        this.convertGroupParameters();
        if (this.getThreadCount() > 0) {
            this.getProperties().setProperty("threadcount", Integer.toString(this.getThreadCount()));
        }
        if (this.getObjectFactory() != null) {
            this.getProperties().setProperty("objectfactory", this.getObjectFactory());
        }
        if (this.getTestClassesDirectory() != null) {
            this.getProperties().setProperty("testng.test.classpath", this.getTestClassesDirectory().getAbsolutePath());
        }
    }

    private void convertGroupParameters() {
        if (this.getProperties() == null) {
            this.setProperties(new Properties());
        }
        if (this.getExcludedGroups() != null) {
            this.getProperties().setProperty("excludedgroups", this.getExcludedGroups());
        }
        if (this.getGroups() != null) {
            this.getProperties().setProperty("groups", this.getGroups());
        }
    }

    protected boolean isAnyConcurrencySelected() {
        return this.getParallel() != null && this.getParallel().trim().length() > 0;
    }

    protected boolean isAnyGroupsSelected() {
        return this.getGroups() != null && this.getExcludedGroups() != null;
    }

    private void convertJunitCoreParameters() {
        if (this.getProperties() == null) {
            this.setProperties(new Properties());
        }
        if (this.getParallel() != null) {
            this.getProperties().setProperty("parallel", this.getParallel());
        }
        if (this.getThreadCount() > 0) {
            this.getProperties().setProperty("threadCount", Integer.toString(this.getThreadCount()));
        }
        this.getProperties().setProperty("perCoreThreadCount", Boolean.toString(this.getPerCoreThreadCount()));
        this.getProperties().setProperty("useUnlimitedThreads", Boolean.toString(this.getUseUnlimitedThreads()));
    }

    private boolean isJunit47Compatible(Artifact artifact) {
        return this.dependencyResolver.isWithinVersionSpec(artifact, "[4.7,)");
    }

    private boolean isAnyJunit4(Artifact artifact) {
        return this.dependencyResolver.isWithinVersionSpec(artifact, "[4.0,)");
    }

    boolean isForkModeNever() {
        return "never".equals(this.getForkMode());
    }

    private List getRunOrders() {
        String runOrderString = this.getRunOrder();
        RunOrder[] runOrder = runOrderString == null ? RunOrder.DEFAULT : RunOrder.valueOfMulti((String)runOrderString);
        return Arrays.asList(runOrder);
    }

    private boolean requiresRunHistory() {
        List runOrders = this.getRunOrders();
        return runOrders.contains(RunOrder.BALANCED) || runOrders.contains(RunOrder.FAILEDFIRST);
    }

    protected ProviderConfiguration createProviderConfiguration(String configurationHash) throws MojoExecutionException, MojoFailureException {
        Properties providerProperties;
        boolean failIfNoTests;
        Artifact testNgArtifact;
        ReporterConfiguration reporterConfiguration = new ReporterConfiguration(this.getReportsDirectory(), Boolean.valueOf(this.isTrimStackTrace()));
        try {
            testNgArtifact = this.getTestNgArtifact();
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Error determining the TestNG version requested: " + e.getMessage(), (Exception)((Object)e));
        }
        DirectoryScannerParameters directoryScannerParameters = null;
        boolean isTestNg = testNgArtifact != null;
        TestArtifactInfo testNg = isTestNg ? new TestArtifactInfo(testNgArtifact.getVersion(), testNgArtifact.getClassifier()) : null;
        List<File> testXml = this.getSuiteXmlFiles() != null ? Arrays.asList(this.getSuiteXmlFiles()) : null;
        TestRequest testSuiteDefinition = new TestRequest(testXml, this.getTestSourceDirectory(), this.getTest(), this.getTestMethod());
        if (this.isValidSuiteXmlFileConfig() && this.getTest() == null) {
            boolean bl = failIfNoTests = this.getFailIfNoTests() != null && this.getFailIfNoTests() != false;
            if (!isTestNg) {
                throw new MojoExecutionException("suiteXmlFiles is configured, but there is no TestNG dependency");
            }
        } else {
            if (this.isSpecificTestSpecified() && this.getFailIfNoTests() == null) {
                this.setFailIfNoTests(Boolean.TRUE);
            }
            failIfNoTests = this.getFailIfNoTests() != null && this.getFailIfNoTests() != false;
            List includes = this.getIncludeList();
            List excludes = this.getExcludeList();
            directoryScannerParameters = new DirectoryScannerParameters(this.getTestClassesDirectory(), includes, excludes, Boolean.valueOf(failIfNoTests), this.getRunOrder());
        }
        if ((providerProperties = this.getProperties()) == null) {
            providerProperties = new Properties();
        }
        RunOrderParameters runOrderParameters = new RunOrderParameters(this.getRunOrder(), this.getStatisticsFileName(configurationHash));
        return new ProviderConfiguration(directoryScannerParameters, runOrderParameters, failIfNoTests, reporterConfiguration, testNg, testSuiteDefinition, providerProperties, null);
    }

    public File getStatisticsFile(String configurationHash) {
        return new File(this.getStatisticsFileName(configurationHash));
    }

    public String getStatisticsFileName(String configurationHash) {
        return this.getReportsDirectory().getParentFile().getParentFile() + File.separator + ".surefire-" + configurationHash;
    }

    StartupConfiguration createStartupConfiguration(ForkConfiguration forkConfiguration, ProviderInfo provider, ClassLoaderConfiguration classLoaderConfiguration) throws MojoExecutionException, MojoFailureException {
        try {
            provider.addProviderProperties();
            String providerName = provider.getProviderName();
            Classpath providerClasspath = provider.getProviderClasspath();
            Classpath inprocClassPath = new Classpath(providerClasspath);
            Artifact surefireArtifact = this.getCommonArtifact();
            inprocClassPath.addClassPathElementUrl(surefireArtifact.getFile().getAbsolutePath());
            Classpath testClasspath = this.generateTestClasspath();
            this.logClasspath(testClasspath, "test classpath");
            this.logClasspath(providerClasspath, "provider classpath");
            ClasspathConfiguration classpathConfiguration = new ClasspathConfiguration(testClasspath, providerClasspath, inprocClassPath, this.isEnableAssertions(), this.isChildDelegation());
            return new StartupConfiguration(providerName, classpathConfiguration, classLoaderConfiguration, forkConfiguration.getForkMode(), false);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to generate classpath: " + (Object)((Object)e), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to generate classpath: " + (Object)((Object)e), (Exception)((Object)e));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Unable to generate classpath: " + (Object)((Object)e), (Exception)((Object)e));
        }
    }

    private Artifact getCommonArtifact() {
        return (Artifact)this.getPluginArtifactMap().get("org.apache.maven.surefire:maven-surefire-common");
    }

    private StartupReportConfiguration getStartupReportConfiguration(String configChecksum) {
        return new StartupReportConfiguration(this.isUseFile(), this.isPrintSummary(), this.getReportFormat(), this.isRedirectTestOutputToFile(), this.isDisableXmlReport(), this.getReportsDirectory(), this.isTrimStackTrace(), this.getReportNameSuffix(), configChecksum, this.requiresRunHistory());
    }

    void logClasspath(Classpath classpath, String descriptor) {
        this.getLog().debug((CharSequence)(descriptor + " classpath:"));
        Iterator i = classpath.getClassPath().iterator();
        while (i.hasNext()) {
            String classpathElement = (String)i.next();
            if (classpathElement == null) {
                this.getLog().warn((CharSequence)"The test classpath contains a null element.");
                continue;
            }
            this.getLog().debug((CharSequence)("  " + classpathElement));
        }
    }

    private boolean isSpecificTestSpecified() {
        return this.getTest() != null;
    }

    private boolean isValidSuiteXmlFileConfig() {
        return this.getSuiteXmlFiles() != null && this.getSuiteXmlFiles().length > 0;
    }

    private List getExcludeList() {
        ArrayList<Object> excludes;
        if (this.isSpecificTestSpecified()) {
            excludes = new ArrayList();
        } else {
            excludes = this.getExcludes();
            if (excludes == null || excludes.size() == 0) {
                excludes = new ArrayList<String>(Arrays.asList("**/*$*"));
            }
        }
        return excludes;
    }

    private List getIncludeList() {
        ArrayList<Object> includes;
        if (this.isSpecificTestSpecified()) {
            includes = new ArrayList();
            String[] testRegexes = StringUtils.split((String)this.getTest(), (String)",");
            for (int i = 0; i < testRegexes.length; ++i) {
                String testRegex = testRegexes[i];
                if (testRegex.endsWith(".java")) {
                    testRegex = testRegex.substring(0, testRegex.length() - 5);
                }
                testRegex = testRegex.replace('.', '/');
                includes.add("**/" + testRegex + ".java");
            }
        } else {
            includes = this.getIncludes();
            if (includes == null || includes.size() == 0) {
                includes = new ArrayList<String>(Arrays.asList(this.getDefaultIncludes()));
            }
        }
        return includes;
    }

    private Artifact getTestNgArtifact() throws MojoFailureException, InvalidVersionSpecificationException {
        VersionRange range;
        Artifact artifact = (Artifact)this.getProjectArtifactMap().get(this.getTestNGArtifactName());
        if (artifact != null && !(range = VersionRange.createFromVersionSpec((String)"[4.7,)")).containsVersion((ArtifactVersion)new DefaultArtifactVersion(artifact.getVersion()))) {
            throw new MojoFailureException("TestNG support requires version 4.7 or above. You have declared version " + artifact.getVersion());
        }
        return artifact;
    }

    private Artifact getJunitArtifact() {
        return (Artifact)this.getProjectArtifactMap().get(this.getJunitArtifactName());
    }

    private Artifact getJunitDepArtifact() {
        return (Artifact)this.getProjectArtifactMap().get("junit:junit-dep");
    }

    protected ForkStarter createForkStarter(ProviderInfo provider, ForkConfiguration forkConfiguration, ClassLoaderConfiguration classLoaderConfiguration) throws MojoExecutionException, MojoFailureException {
        StartupConfiguration startupConfiguration = this.createStartupConfiguration(forkConfiguration, provider, classLoaderConfiguration);
        String configChecksum = this.getConfigChecksum();
        StartupReportConfiguration startupReportConfiguration = this.getStartupReportConfiguration(configChecksum);
        ProviderConfiguration providerConfiguration = this.createProviderConfiguration(configChecksum);
        return new ForkStarter(providerConfiguration, startupConfiguration, forkConfiguration, this.getForkedProcessTimeoutInSeconds(), startupReportConfiguration);
    }

    protected InPluginVMSurefireStarter createInprocessStarter(ProviderInfo provider, ForkConfiguration forkConfiguration, ClassLoaderConfiguration classLoaderConfiguration) throws MojoExecutionException, MojoFailureException {
        StartupConfiguration startupConfiguration = this.createStartupConfiguration(forkConfiguration, provider, classLoaderConfiguration);
        String configChecksum = this.getConfigChecksum();
        StartupReportConfiguration startupReportConfiguration = this.getStartupReportConfiguration(configChecksum);
        ProviderConfiguration providerConfiguration = this.createProviderConfiguration(configChecksum);
        return new InPluginVMSurefireStarter(startupConfiguration, providerConfiguration, startupReportConfiguration);
    }

    protected ForkConfiguration getForkConfiguration() {
        Toolchain tc;
        File tmpDir = this.getSurefireTempDir();
        tmpDir.mkdirs();
        Artifact shadeFire = (Artifact)this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-shadefire");
        this.surefireBooterArtifact = (Artifact)this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-booter");
        if (this.surefireBooterArtifact == null) {
            throw new RuntimeException("Unable to locate surefire-booter in the list of plugin artifacts");
        }
        this.surefireBooterArtifact.isSnapshot();
        Classpath bootClasspathConfiguration = this.getArtifactClasspath(shadeFire != null ? shadeFire : this.surefireBooterArtifact);
        ForkConfiguration fork = new ForkConfiguration(bootClasspathConfiguration, this.getForkMode(), tmpDir);
        fork.setTempDirectory(tmpDir);
        this.processSystemProperties(!fork.isForking());
        this.verifyLegalSystemProperties();
        if (this.getLog().isDebugEnabled()) {
            this.showMap(this.getInternalSystemProperties(), "system property");
        }
        if ((tc = this.getToolchain()) != null) {
            this.getLog().info((CharSequence)("Toolchain in " + this.getPluginName() + "-plugin: " + tc));
            if (this.isForkModeNever()) {
                this.setForkMode("once");
            }
            if (this.getJvm() != null) {
                this.getLog().warn((CharSequence)("Toolchains are ignored, 'executable' parameter is set to " + this.getJvm()));
            } else {
                this.setJvm(tc.findTool("java"));
            }
        }
        if (fork.isForking()) {
            List<String> args;
            this.setUseSystemClassLoader(this.isUseSystemClassLoader());
            fork.setSystemProperties(this.getInternalSystemProperties());
            if ("true".equals(this.getDebugForkedProcess())) {
                this.setDebugForkedProcess("-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005");
            }
            fork.setDebugLine(this.getDebugForkedProcess());
            if (this.getJvm() == null || "".equals(this.getJvm())) {
                this.setJvm(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
                this.getLog().debug((CharSequence)("Using JVM: " + this.getJvm()));
            }
            fork.setJvmExecutable(this.getJvm());
            if (this.getWorkingDirectory() != null) {
                fork.setWorkingDirectory(this.getWorkingDirectory());
            } else {
                fork.setWorkingDirectory(this.getBasedir());
            }
            fork.setArgLine(this.getArgLine());
            fork.setEnvironmentVariables(this.getEnvironmentVariables());
            if (this.getLog().isDebugEnabled()) {
                this.showMap(this.getEnvironmentVariables(), "environment variable");
                fork.setDebug(true);
            }
            if (this.getArgLine() != null && ((args = Arrays.asList(this.getArgLine().split(" "))).contains("-da") || args.contains("-disableassertions"))) {
                this.setEnableAssertions(false);
            }
        }
        return fork;
    }

    private void verifyLegalSystemProperties() {
        Properties properties = this.getInternalSystemProperties();
        Iterator<Object> iter = properties.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!"java.library.path".equals(key)) continue;
            this.getLog().warn((CharSequence)"java.library.path cannot be set as system property, use <argLine>-Djava.library.path=...<argLine> instead");
        }
    }

    private File getSurefireTempDir() {
        return new File(this.getReportsDirectory().getParentFile(), "surefire");
    }

    private String getConfigChecksum() {
        ChecksumCalculator checksum = new ChecksumCalculator();
        checksum.add(this.getPluginName());
        checksum.add(this.isSkipTests());
        checksum.add(this.isSkipExec());
        checksum.add(this.isSkip());
        checksum.add(this.getTestClassesDirectory());
        checksum.add(this.getClassesDirectory());
        checksum.add(this.getClasspathDependencyExcludes());
        checksum.add(this.getClasspathDependencyScopeExclude());
        checksum.add(this.getAdditionalClasspathElements());
        checksum.add(this.getReportsDirectory());
        checksum.add(this.getTestSourceDirectory());
        checksum.add(this.getTest());
        checksum.add(this.getIncludes());
        checksum.add(this.getExcludes());
        checksum.add(this.getLocalRepository());
        checksum.add(this.getSystemProperties());
        checksum.add(this.getSystemPropertyVariables());
        checksum.add(this.getSystemPropertiesFile());
        checksum.add(this.getProperties());
        checksum.add(this.isPrintSummary());
        checksum.add(this.getReportFormat());
        checksum.add(this.getReportNameSuffix());
        checksum.add(this.isUseFile());
        checksum.add(this.isRedirectTestOutputToFile());
        checksum.add(this.getForkMode());
        checksum.add(this.getJvm());
        checksum.add(this.getArgLine());
        checksum.add(this.getDebugForkedProcess());
        checksum.add(this.getForkedProcessTimeoutInSeconds());
        checksum.add(this.getEnvironmentVariables());
        checksum.add(this.getWorkingDirectory());
        checksum.add(this.isChildDelegation());
        checksum.add(this.getGroups());
        checksum.add(this.getExcludedGroups());
        checksum.add(this.getSuiteXmlFiles());
        checksum.add(this.getJunitArtifact());
        checksum.add(this.getTestNGArtifactName());
        checksum.add(this.getThreadCount());
        checksum.add(this.getPerCoreThreadCount());
        checksum.add(this.getUseUnlimitedThreads());
        checksum.add(this.getParallel());
        checksum.add(this.isTrimStackTrace());
        checksum.add(this.getRemoteRepositories());
        checksum.add(this.isDisableXmlReport());
        checksum.add(this.isUseSystemClassLoader());
        checksum.add(this.isUseManifestOnlyJar());
        checksum.add(this.isEnableAssertions());
        checksum.add(this.getObjectFactory());
        checksum.add(this.getFailIfNoTests());
        checksum.add(this.getRunOrder());
        this.addPluginSpecificChecksumItems(checksum);
        return checksum.getSha1();
    }

    protected abstract void addPluginSpecificChecksumItems(ChecksumCalculator var1);

    protected boolean hasExecutedBefore() {
        String configChecksum = this.getConfigChecksum();
        Map pluginContext = this.getPluginContext();
        if (pluginContext.containsKey(configChecksum)) {
            this.getLog().info((CharSequence)"Skipping execution of surefire because it has already been run for this configuration");
            return true;
        }
        pluginContext.put(configChecksum, configChecksum);
        return false;
    }

    protected ClassLoaderConfiguration getClassLoaderConfiguration(ForkConfiguration fork) {
        return fork.isForking() ? new ClassLoaderConfiguration(this.isUseSystemClassLoader(), this.isUseManifestOnlyJar()) : new ClassLoaderConfiguration(false, false);
    }

    protected abstract String[] getDefaultIncludes();

    Classpath generateTestClasspath() throws InvalidVersionSpecificationException, MojoFailureException, ArtifactResolutionException, ArtifactNotFoundException {
        PatternIncludesArtifactFilter dependencyFilter;
        ArrayList<String> classpath = new ArrayList<String>(2 + this.getProject().getArtifacts().size());
        classpath.add(this.getTestClassesDirectory().getAbsolutePath());
        classpath.add(this.getClassesDirectory().getAbsolutePath());
        Set classpathArtifacts = this.getProject().getArtifacts();
        if (this.getClasspathDependencyScopeExclude() != null && !this.getClasspathDependencyScopeExclude().equals("")) {
            dependencyFilter = new ScopeArtifactFilter(this.getClasspathDependencyScopeExclude());
            classpathArtifacts = this.filterArtifacts(classpathArtifacts, (ArtifactFilter)dependencyFilter);
        }
        if (this.getClasspathDependencyExcludes() != null) {
            dependencyFilter = new PatternIncludesArtifactFilter(this.getClasspathDependencyExcludes());
            classpathArtifacts = this.filterArtifacts(classpathArtifacts, (ArtifactFilter)dependencyFilter);
        }
        Iterator iter = classpathArtifacts.iterator();
        while (iter.hasNext()) {
            File file;
            Artifact artifact = (Artifact)iter.next();
            if (!artifact.getArtifactHandler().isAddedToClasspath() || (file = artifact.getFile()) == null) continue;
            classpath.add(file.getPath());
        }
        if (this.getAdditionalClasspathElements() != null) {
            iter = this.getAdditionalClasspathElements().iterator();
            while (iter.hasNext()) {
                String classpathElement = (String)iter.next();
                if (classpathElement == null) continue;
                classpath.add(classpathElement);
            }
        }
        if (this.getTestNgArtifact() != null) {
            Artifact testNgUtils = this.getTestNgUtilsArtifact();
            String path = testNgUtils.getFile().getPath();
            classpath.add(path);
        }
        return new Classpath(classpath);
    }

    Artifact getTestNgUtilsArtifact() throws ArtifactResolutionException, ArtifactNotFoundException {
        Artifact surefireArtifact = (Artifact)this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-booter");
        String surefireVersion = surefireArtifact.getBaseVersion();
        Artifact testNgUtils = this.getArtifactFactory().createArtifact("org.apache.maven.surefire", "surefire-testng-utils", surefireVersion, "runtime", "jar");
        this.getArtifactResolver().resolve(testNgUtils, this.getRemoteRepositories(), this.getLocalRepository());
        return testNgUtils;
    }

    private Set filterArtifacts(Set artifacts, ArtifactFilter filter) {
        LinkedHashSet<Artifact> filteredArtifacts = new LinkedHashSet<Artifact>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (filter.include(artifact)) continue;
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    private void showMap(Map map, String setting) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)map.get(key);
            this.getLog().debug((CharSequence)("Setting " + setting + " [" + key + "]=[" + value + "]"));
        }
    }

    private ArtifactResolutionResult resolveArtifact(Artifact filteredArtifact, Artifact providerArtifact) {
        ExcludesArtifactFilter filter = null;
        if (filteredArtifact != null) {
            filter = new ExcludesArtifactFilter(Collections.singletonList(filteredArtifact.getGroupId() + ":" + filteredArtifact.getArtifactId()));
        }
        Artifact originatingArtifact = this.getArtifactFactory().createBuildArtifact("dummy", "dummy", "1.0", "jar");
        try {
            return this.getArtifactResolver().resolveTransitively(Collections.singleton(providerArtifact), originatingArtifact, this.getLocalRepository(), this.getRemoteRepositories(), this.getMetadataSource(), (ArtifactFilter)filter);
        }
        catch (ArtifactResolutionException e) {
            throw new NestedRuntimeException((Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    private Classpath getArtifactClasspath(Artifact surefireArtifact) {
        ArtifactResolutionResult result = this.resolveArtifact(null, surefireArtifact);
        ArrayList<String> items = new ArrayList<String>();
        Iterator i = result.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            this.getLog().debug((CharSequence)("Adding to " + this.getPluginName() + " booter test classpath: " + artifact.getFile().getAbsolutePath() + " Scope: " + artifact.getScope()));
            items.add(artifact.getFile().getAbsolutePath());
        }
        return new Classpath(items);
    }

    void processSystemProperties(boolean setInSystem) {
        String value;
        String key;
        this.copyPropertiesToInternalSystemProperties(this.getSystemProperties());
        if (this.getSystemPropertiesFile() != null) {
            Properties props = new Properties();
            try {
                FileInputStream fis = new FileInputStream(this.getSystemPropertiesFile());
                props.load(fis);
                fis.close();
            }
            catch (IOException e) {
                String msg = "The system property file '" + this.getSystemPropertiesFile().getAbsolutePath() + "' can't be read.";
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().warn((CharSequence)msg, (Throwable)e);
                }
                this.getLog().warn((CharSequence)msg);
            }
            Enumeration<?> keys = props.propertyNames();
            while (keys.hasMoreElements()) {
                String key2 = (String)keys.nextElement();
                String value2 = props.getProperty(key2);
                this.getInternalSystemProperties().setProperty(key2, value2);
            }
        }
        if (this.getSystemPropertyVariables() != null) {
            Iterator i = this.getSystemPropertyVariables().keySet().iterator();
            while (i.hasNext()) {
                key = (String)i.next();
                value = (String)this.getSystemPropertyVariables().get(key);
                if (value == null) continue;
                this.getInternalSystemProperties().setProperty(key, value);
            }
        }
        this.setOriginalSystemProperties((Properties)System.getProperties().clone());
        this.copyPropertiesToInternalSystemProperties(this.getUserProperties());
        this.getInternalSystemProperties().setProperty("basedir", this.getBasedir().getAbsolutePath());
        this.getInternalSystemProperties().setProperty("user.dir", this.getWorkingDirectory().getAbsolutePath());
        this.getInternalSystemProperties().setProperty("localRepository", this.getLocalRepository().getBasedir());
        if (setInSystem) {
            Iterator<Object> iter = this.getInternalSystemProperties().keySet().iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                value = this.getInternalSystemProperties().getProperty(key);
                System.setProperty(key, value);
            }
        }
    }

    private void copyPropertiesToInternalSystemProperties(Properties properties) {
        if (properties != null) {
            Iterator<Object> i = properties.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = properties.getProperty(key);
                this.getInternalSystemProperties().setProperty(key, value);
            }
        }
    }

    private Properties getUserProperties() {
        Properties props = null;
        try {
            Method getUserProperties = this.getSession().getClass().getMethod("getUserProperties", null);
            props = (Properties)getUserProperties.invoke((Object)this.getSession(), null);
        }
        catch (Exception e) {
            String msg = "Build uses Maven 2.0.x, cannot propagate system properties from command line to tests (cf. SUREFIRE-121)";
            if (this.getLog().isDebugEnabled()) {
                this.getLog().warn((CharSequence)msg, (Throwable)e);
            }
            this.getLog().warn((CharSequence)msg);
        }
        if (props == null) {
            props = new Properties();
        }
        return props;
    }

    void ensureWorkingDirectoryExists() throws MojoFailureException {
        if (this.getWorkingDirectory() == null) {
            throw new MojoFailureException("workingDirectory cannot be null");
        }
        if (!this.getWorkingDirectory().exists() && !this.getWorkingDirectory().mkdirs()) {
            throw new MojoFailureException("Cannot create workingDirectory " + this.getWorkingDirectory());
        }
        if (!this.getWorkingDirectory().isDirectory()) {
            throw new MojoFailureException("workingDirectory " + this.getWorkingDirectory() + " exists and is not a directory");
        }
    }

    void ensureParallelRunningCompatibility() throws MojoFailureException {
        if (this.isMavenParallel() && this.isForkModeNever()) {
            throw new MojoFailureException("parallel maven execution is not compatible with surefire forkmode NEVER");
        }
    }

    void warnIfUselessUseSystemClassLoaderParameter() {
        if (this.isUseSystemClassLoader() && this.isForkModeNever()) {
            this.getLog().warn((CharSequence)"useSystemClassloader setting has no effect when not forking");
        }
    }

    public class DynamicProviderInfo
    implements ConfigurableProviderInfo {
        final String providerName;

        DynamicProviderInfo(String providerName) {
            this.providerName = providerName;
        }

        public ProviderInfo instantiate(String providerName) {
            return new DynamicProviderInfo(providerName);
        }

        public String getProviderName() {
            return this.providerName;
        }

        public boolean isApplicable() {
            return true;
        }

        public void addProviderProperties() {
            AbstractSurefireMojo.this.convertJunitCoreParameters();
            AbstractSurefireMojo.this.convertTestNGParameters();
        }

        public Classpath getProviderClasspath() throws ArtifactResolutionException, ArtifactNotFoundException {
            Map pluginArtifactMap = AbstractSurefireMojo.this.getPluginArtifactMap();
            Artifact plugin = (Artifact)pluginArtifactMap.get("org.apache.maven.plugins:maven-surefire-plugin");
            return AbstractSurefireMojo.this.dependencyResolver.addProviderToClasspath(pluginArtifactMap, plugin);
        }
    }

    class JUnitCoreProviderInfo
    implements ProviderInfo {
        private final Artifact junitArtifact;
        private final Artifact junitDepArtifact;

        JUnitCoreProviderInfo(Artifact junitArtifact, Artifact junitDepArtifact) {
            this.junitArtifact = junitArtifact;
            this.junitDepArtifact = junitDepArtifact;
        }

        public String getProviderName() {
            return "org.apache.maven.surefire.junitcore.JUnitCoreProvider";
        }

        private boolean is47CompatibleJunitDep() {
            return this.junitDepArtifact != null && AbstractSurefireMojo.this.isJunit47Compatible(this.junitDepArtifact);
        }

        public boolean isApplicable() {
            boolean isJunitArtifact47 = AbstractSurefireMojo.this.isAnyJunit4(this.junitArtifact) && AbstractSurefireMojo.this.isJunit47Compatible(this.junitArtifact);
            boolean isAny47ProvidersForcers = AbstractSurefireMojo.this.isAnyConcurrencySelected() || AbstractSurefireMojo.this.isAnyGroupsSelected();
            return isAny47ProvidersForcers && (isJunitArtifact47 || this.is47CompatibleJunitDep());
        }

        public void addProviderProperties() {
            AbstractSurefireMojo.this.convertJunitCoreParameters();
            AbstractSurefireMojo.this.convertGroupParameters();
        }

        public Classpath getProviderClasspath() throws ArtifactResolutionException, ArtifactNotFoundException {
            return AbstractSurefireMojo.this.dependencyResolver.getProviderClasspath("surefire-junit47", AbstractSurefireMojo.this.surefireBooterArtifact.getBaseVersion(), null);
        }
    }

    class JUnit4ProviderInfo
    implements ProviderInfo {
        private final Artifact junitArtifact;
        private final Artifact junitDepArtifact;

        JUnit4ProviderInfo(Artifact junitArtifact, Artifact junitDepArtifact) {
            this.junitArtifact = junitArtifact;
            this.junitDepArtifact = junitDepArtifact;
        }

        public String getProviderName() {
            return "org.apache.maven.surefire.junit4.JUnit4Provider";
        }

        public boolean isApplicable() {
            return this.junitDepArtifact != null || AbstractSurefireMojo.this.isAnyJunit4(this.junitArtifact);
        }

        public void addProviderProperties() {
        }

        public Classpath getProviderClasspath() throws ArtifactResolutionException, ArtifactNotFoundException {
            return AbstractSurefireMojo.this.dependencyResolver.getProviderClasspath("surefire-junit4", AbstractSurefireMojo.this.surefireBooterArtifact.getBaseVersion(), null);
        }
    }

    class JUnit3ProviderInfo
    implements ProviderInfo {
        JUnit3ProviderInfo() {
        }

        public String getProviderName() {
            return "org.apache.maven.surefire.junit.JUnit3Provider";
        }

        public boolean isApplicable() {
            return true;
        }

        public void addProviderProperties() {
        }

        public Classpath getProviderClasspath() throws ArtifactResolutionException, ArtifactNotFoundException {
            return AbstractSurefireMojo.this.dependencyResolver.getProviderClasspath("surefire-junit3", AbstractSurefireMojo.this.surefireBooterArtifact.getBaseVersion(), null);
        }
    }

    class TestNgProviderInfo
    implements ProviderInfo {
        private final Artifact testNgArtifact;

        TestNgProviderInfo(Artifact testNgArtifact) {
            this.testNgArtifact = testNgArtifact;
        }

        public String getProviderName() {
            return "org.apache.maven.surefire.testng.TestNGProvider";
        }

        public boolean isApplicable() {
            return this.testNgArtifact != null;
        }

        public void addProviderProperties() {
            AbstractSurefireMojo.this.convertTestNGParameters();
        }

        public Classpath getProviderClasspath() throws ArtifactResolutionException, ArtifactNotFoundException {
            Artifact surefireArtifact = (Artifact)AbstractSurefireMojo.this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-booter");
            return AbstractSurefireMojo.this.dependencyResolver.getProviderClasspath("surefire-testng", surefireArtifact.getBaseVersion(), this.testNgArtifact);
        }
    }
}

