/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.accurev.commands.add;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AbstractAddCommand;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.accurev.AccuRevScmProvider;
import org.apache.maven.scm.provider.accurev.AccuRevScmProviderRepository;
import org.apache.maven.scm.provider.accurev.commands.add.AddCommandStreamConsumer;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class AccuRevAddCommand
extends AbstractAddCommand {
    private final String accurevExecutable;

    public AccuRevAddCommand(String accurevExec) {
        this.accurevExecutable = accurevExec;
    }

    protected ScmResult executeAddCommand(ScmProviderRepository repository, ScmFileSet fileSet, String message, boolean binary) throws ScmException {
        Commandline cl = new Commandline();
        cl.setExecutable(this.accurevExecutable);
        cl.setWorkingDirectory(fileSet.getBasedir().getPath());
        cl.addArguments(new String[]{"add"});
        ArrayList params = new ArrayList();
        AccuRevScmProvider.appendHostToParamsIfNeeded((AccuRevScmProviderRepository)repository, params);
        cl.addArguments(params.toArray(new String[params.size()]));
        cl.addArguments(this.makeFileArgs(fileSet.getFileList()));
        ArrayList filesAdded = new ArrayList();
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        try {
            if (0 != CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)new AddCommandStreamConsumer((StreamConsumer)stdout, filesAdded), (StreamConsumer)stdout)) {
                return new AddScmResult(cl.toString(), null, stdout.getOutput(), false);
            }
        }
        catch (CommandLineException e) {
            throw new ScmRepositoryException("Cannot exeucute add command", (Throwable)e);
        }
        return new AddScmResult(cl.toString(), filesAdded);
    }

    private String[] makeFileArgs(List fileList) {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < fileList.size(); ++i) {
            File file = (File)fileList.get(i);
            res.add(file.getAbsolutePath());
        }
        return res.toArray(new String[res.size()]);
    }
}

