/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.versions.DefaultVersionInfo;
import org.apache.maven.shared.release.versions.VersionInfo;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public class CheckDependencySnapshotsPhase
extends AbstractReleasePhase {
    public static final String RESOLVE_SNAPSHOT_MESSAGE = "There are still some remaining snapshot dependencies.";
    public static final String RESOLVE_SNAPSHOT_PROMPT = "Do you want to resolve them now?";
    public static final String RESOLVE_SNAPSHOT_TYPE_MESSAGE = "Dependency type to resolve,";
    public static final String RESOLVE_SNAPSHOT_TYPE_PROMPT = "specify the selection number ( 0:All 1:Project Dependencies 2:Plugins 3:Reports 4:Extensions ):";
    public static final String RESOLVE_ALL_SNAPSHOT_MESSAGE = "Resolve All Snapshots.";
    public static final String RESOLVE_ALL_PROJECT_DEPENDENCIES_SNAPSHOT_MESSAGE = "Resolve Project Dependency Snapshots.";
    public static final String RESOLVE_ALL_REPORTS_SNAPSHOT_MESSAGE = "Resolve Report Dependency Snapshots.";
    public static final String RESOLVE_ALL_EXTENSIONS_SNAPSHOT_MESSAGE = "Resolve Extension Dependency Snapshots.";
    public static final String RESOLVE_ALL_PLUGIN_SNAPSHOT_MESSAGE = "Resolve Plugin Dependency Snapshots.";
    private Prompter prompter;
    private ArtifactFactory artifactFactory;

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        this.logInfo(result, "Checking dependencies and plugins for snapshots ...");
        Map originalVersions = releaseDescriptor.getOriginalVersions(reactorProjects);
        Iterator i = reactorProjects.iterator();
        while (i.hasNext()) {
            MavenProject project = (MavenProject)i.next();
            this.checkProject(project, originalVersions, releaseDescriptor);
        }
        result.setResultCode(0);
        return result;
    }

    private void checkProject(MavenProject project, Map originalVersions, ReleaseDescriptor releaseDescriptor) throws ReleaseFailureException, ReleaseExecutionException {
        Artifact artifact;
        Map artifactMap = ArtifactUtils.artifactMapByVersionlessId((Collection)project.getArtifacts());
        HashSet<Artifact> snapshotDependencies = new HashSet<Artifact>();
        HashSet<Artifact> snapshotReportDependencies = new HashSet<Artifact>();
        HashSet<Artifact> snapshotExtensionsDependencies = new HashSet<Artifact>();
        HashSet<Artifact> snapshotPluginDependencies = new HashSet<Artifact>();
        if (project.getParentArtifact() != null && CheckDependencySnapshotsPhase.checkArtifact(project.getParentArtifact(), originalVersions, artifactMap, releaseDescriptor)) {
            snapshotDependencies.add(project.getParentArtifact());
        }
        try {
            Set dependencyArtifacts = project.createArtifacts(this.artifactFactory, null, null);
            Iterator i = dependencyArtifacts.iterator();
            while (i.hasNext()) {
                Artifact artifact2 = (Artifact)i.next();
                if (!CheckDependencySnapshotsPhase.checkArtifact(artifact2, originalVersions, artifactMap, releaseDescriptor)) continue;
                snapshotDependencies.add(artifact2);
            }
        }
        catch (InvalidDependencyVersionException e) {
            throw new ReleaseExecutionException("Failed to create dependency artifacts", e);
        }
        Iterator i = project.getPluginArtifacts().iterator();
        while (i.hasNext()) {
            artifact = (Artifact)i.next();
            if (!CheckDependencySnapshotsPhase.checkArtifact(artifact, originalVersions, artifactMap, releaseDescriptor)) continue;
            boolean addToFailures = true;
            if ("org.apache.maven.plugins".equals(artifact.getGroupId()) && "maven-release-plugin".equals(artifact.getArtifactId()) && releaseDescriptor.isInteractive()) {
                try {
                    String result = "no";
                    if (!releaseDescriptor.isSnapshotReleasePluginAllowed()) {
                        this.prompter.showMessage("This project relies on a SNAPSHOT of the release plugin. This may be necessary during testing.");
                        result = this.prompter.prompt("Do you want to continue with the release?", Arrays.asList("yes", "no"), "no");
                    } else {
                        result = "yes";
                    }
                    if (result.toLowerCase(Locale.ENGLISH).startsWith("y")) {
                        addToFailures = false;
                        releaseDescriptor.setSnapshotReleasePluginAllowed(true);
                    }
                }
                catch (PrompterException e) {
                    throw new ReleaseExecutionException(e.getMessage(), e);
                }
            }
            if (!addToFailures) continue;
            snapshotPluginDependencies.add(artifact);
        }
        i = project.getReportArtifacts().iterator();
        while (i.hasNext()) {
            artifact = (Artifact)i.next();
            if (!CheckDependencySnapshotsPhase.checkArtifact(artifact, originalVersions, artifactMap, releaseDescriptor)) continue;
            snapshotReportDependencies.add(artifact);
        }
        i = project.getExtensionArtifacts().iterator();
        while (i.hasNext()) {
            artifact = (Artifact)i.next();
            if (!CheckDependencySnapshotsPhase.checkArtifact(artifact, originalVersions, artifactMap, releaseDescriptor)) continue;
            snapshotExtensionsDependencies.add(artifact);
        }
        if (!(snapshotDependencies.isEmpty() && snapshotReportDependencies.isEmpty() && snapshotExtensionsDependencies.isEmpty() && snapshotPluginDependencies.isEmpty())) {
            if (releaseDescriptor.isInteractive()) {
                this.resolveSnapshots(snapshotDependencies, snapshotReportDependencies, snapshotExtensionsDependencies, snapshotPluginDependencies, releaseDescriptor);
            }
            if (!(snapshotDependencies.isEmpty() && snapshotReportDependencies.isEmpty() && snapshotExtensionsDependencies.isEmpty() && snapshotPluginDependencies.isEmpty())) {
                StringBuffer message = new StringBuffer();
                this.printSnapshotDependencies(snapshotDependencies, message);
                this.printSnapshotDependencies(snapshotReportDependencies, message);
                this.printSnapshotDependencies(snapshotExtensionsDependencies, message);
                this.printSnapshotDependencies(snapshotPluginDependencies, message);
                message.append("in project '" + project.getName() + "' (" + project.getId() + ")");
                throw new ReleaseFailureException("Can't release project due to non released dependencies :\n" + message);
            }
        }
    }

    private static boolean checkArtifact(Artifact artifact, Map originalVersions, Map artifactMapByVersionlessId, ReleaseDescriptor releaseDescriptor) {
        String versionlessId = ArtifactUtils.versionlessKey((Artifact)artifact);
        Artifact checkArtifact = (Artifact)artifactMapByVersionlessId.get(versionlessId);
        if (checkArtifact == null) {
            checkArtifact = artifact;
        }
        return CheckDependencySnapshotsPhase.checkArtifact(checkArtifact, originalVersions, releaseDescriptor);
    }

    private static boolean checkArtifact(Artifact artifact, Map originalVersions, ReleaseDescriptor releaseDescriptor) {
        boolean result;
        String versionlessArtifactKey = ArtifactUtils.versionlessKey((String)artifact.getGroupId(), (String)artifact.getArtifactId());
        boolean bl = result = artifact.isSnapshot() && !artifact.getBaseVersion().equals(originalVersions.get(versionlessArtifactKey));
        if (result && releaseDescriptor.isAllowTimestampedSnapshots()) {
            result = artifact.getVersion().indexOf("SNAPSHOT") >= 0;
        }
        return result;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
    }

    public void setPrompter(Prompter prompter) {
        this.prompter = prompter;
    }

    private StringBuffer printSnapshotDependencies(Set snapshotsSet, StringBuffer message) {
        ArrayList snapshotsList = new ArrayList(snapshotsSet);
        Collections.sort(snapshotsList);
        Iterator i = snapshotsList.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            message.append("    ");
            message.append(artifact);
            message.append("\n");
        }
        return message;
    }

    private void resolveSnapshots(Set projectDependencies, Set reportDependencies, Set extensionDependencies, Set pluginDependencies, ReleaseDescriptor releaseDescriptor) throws ReleaseExecutionException {
        try {
            this.prompter.showMessage(RESOLVE_SNAPSHOT_MESSAGE);
            String result = this.prompter.prompt(RESOLVE_SNAPSHOT_PROMPT, Arrays.asList("yes", "no"), "no");
            if (result.toLowerCase(Locale.ENGLISH).startsWith("y")) {
                HashSet snapshotSet = new HashSet();
                Map resolvedSnapshots = null;
                this.prompter.showMessage(RESOLVE_SNAPSHOT_TYPE_MESSAGE);
                result = this.prompter.prompt(RESOLVE_SNAPSHOT_TYPE_PROMPT, Arrays.asList("0", "1", "2", "3"), "1");
                switch (Integer.parseInt(result.toLowerCase(Locale.ENGLISH))) {
                    case 0: {
                        this.prompter.showMessage(RESOLVE_ALL_SNAPSHOT_MESSAGE);
                        snapshotSet.addAll(projectDependencies);
                        snapshotSet.addAll(reportDependencies);
                        snapshotSet.addAll(extensionDependencies);
                        snapshotSet.addAll(pluginDependencies);
                        resolvedSnapshots = this.processSnapshot(snapshotSet);
                        break;
                    }
                    case 1: {
                        this.prompter.showMessage(RESOLVE_ALL_PROJECT_DEPENDENCIES_SNAPSHOT_MESSAGE);
                        resolvedSnapshots = this.processSnapshot(projectDependencies);
                        break;
                    }
                    case 2: {
                        this.prompter.showMessage(RESOLVE_ALL_PLUGIN_SNAPSHOT_MESSAGE);
                        resolvedSnapshots = this.processSnapshot(pluginDependencies);
                        break;
                    }
                    case 3: {
                        this.prompter.showMessage(RESOLVE_ALL_REPORTS_SNAPSHOT_MESSAGE);
                        resolvedSnapshots = this.processSnapshot(reportDependencies);
                        break;
                    }
                    case 4: {
                        this.prompter.showMessage(RESOLVE_ALL_EXTENSIONS_SNAPSHOT_MESSAGE);
                        resolvedSnapshots = this.processSnapshot(extensionDependencies);
                    }
                }
                releaseDescriptor.setResolvedSnapshotDependencies(resolvedSnapshots);
            }
        }
        catch (PrompterException e) {
            throw new ReleaseExecutionException(e.getMessage(), e);
        }
        catch (VersionParseException e) {
            throw new ReleaseExecutionException(e.getMessage(), e);
        }
    }

    private Map processSnapshot(Set snapshotSet) throws PrompterException, VersionParseException {
        HashMap resolvedSnapshots = new HashMap();
        Iterator iterator = snapshotSet.iterator();
        while (iterator.hasNext()) {
            Artifact currentArtifact = (Artifact)iterator.next();
            String versionlessKey = ArtifactUtils.versionlessKey((Artifact)currentArtifact);
            String result = this.prompter.prompt("'" + versionlessKey + "' set to release?", Arrays.asList("yes", "no"), "yes");
            if (!result.toLowerCase(Locale.ENGLISH).startsWith("y")) continue;
            iterator.remove();
            DefaultVersionInfo versionInfo = new DefaultVersionInfo(currentArtifact.getVersion());
            VersionInfo nextVersionInfo = versionInfo.getNextVersion();
            String nextVersion = nextVersionInfo != null ? nextVersionInfo.getSnapshotVersionString() : "1.0-SNAPSHOT";
            result = this.prompter.prompt("What is the next development version?", Collections.singletonList(nextVersion), nextVersion);
            DefaultVersionInfo nextDevelopmentVersion = new DefaultVersionInfo(result);
            HashMap<String, String> versionMap = new HashMap<String, String>();
            versionMap.put("original", ((Object)versionInfo).toString());
            versionMap.put("dev", nextDevelopmentVersion.getSnapshotVersionString());
            versionMap.put("rel", versionInfo.getReleaseVersionString());
            resolvedSnapshots.put(versionlessKey, versionMap);
        }
        return resolvedSnapshots;
    }
}

