/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.release.AbstractScmReleaseMojo;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="stage", aggregator=true, requiresProject=false)
public class StageReleaseMojo
extends AbstractScmReleaseMojo {
    @Parameter(property="goals")
    private String goals;
    @Parameter(property="releaseProfiles")
    private String releaseProfiles;
    @Parameter(defaultValue="${project.build.directory}/checkout", property="workingDirectory", required=true)
    private File workingDirectory;
    @Parameter(property="connectionUrl")
    private String connectionUrl;
    @Parameter(defaultValue="true", property="useReleaseProfile")
    private boolean useReleaseProfile;
    @Parameter(property="stagingRepository", required=true)
    private String stagingRepository;

    protected String getAdditionalProfiles() {
        return this.releaseProfiles;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.goals != null) {
            this.goals = StringUtils.join((Object[])StringUtils.split((String)this.goals), (String)" ");
        }
        try {
            this.addArgument("-DaltDeploymentRepository=\"" + this.stagingRepository + "\"");
            ReleaseDescriptor releaseDescriptor = this.createReleaseDescriptor();
            if (this.connectionUrl != null) {
                releaseDescriptor.setScmSourceUrl(this.connectionUrl);
            }
            releaseDescriptor.setCheckoutDirectory(this.workingDirectory.getAbsolutePath());
            releaseDescriptor.setUseReleaseProfile(this.useReleaseProfile);
            if (this.goals == null) {
                this.goals = "deploy";
                if (this.project.getDistributionManagement() != null && this.project.getDistributionManagement().getSite() != null) {
                    this.goals = this.goals + " site:stage-deploy";
                }
            }
            this.goals = StringUtils.replace((String)this.goals, (String)"site-deploy", (String)"site:stage-deploy");
            this.goals = StringUtils.replace((String)this.goals, (String)"site:deploy", (String)"site:stage-deploy");
            releaseDescriptor.setPerformGoals(this.goals);
            this.releaseManager.perform(releaseDescriptor, this.getReleaseEnvironment(), this.getReactorProjects(), false);
        }
        catch (ReleaseExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ReleaseFailureException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

