/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.myeclipse;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.ide.IdeUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;

public class MyEclipseStrutsDataWriter
extends AbstractEclipseWriter {
    private static final String MYECLIPSE_MYSTRUTSDATA_FILENAME = ".mystrutsdata";
    private static final String MYECLIPSE_STRUTS_PROPERTIES = "MyEclipseStrutsProperties";
    private static final String MYECLIPSE_STRUTS_VERSION = "strutsVersion";
    private static final String MYECLIPSE_STRUTS_BASE_PACKAGE = "basePackage";
    private static final String MYECLIPSE_STRUTS_PATTERN = "strutsPattern";
    private static final String MYECLIPSE_STRUTS_SERVLET_NAME = "servletName";
    private static final String MYECLIPSE_STRUTS_DEFAULT_PATTERN = "*.do";
    private static final String MYECLIPSE_STRUTS_SERVLET_DEFAULT_NAME = "action";
    private static Map strutsPatterns;
    private Map strutsProps;

    public MyEclipseStrutsDataWriter(Map strutsProps) {
        this.strutsProps = strutsProps;
        strutsPatterns = new HashMap();
        strutsPatterns.put(MYECLIPSE_STRUTS_DEFAULT_PATTERN, "0");
        strutsPatterns.put("/do/*", "1");
    }

    public void write() throws MojoExecutionException {
        String packaging = this.config.getProject().getPackaging();
        if ("war".equals(packaging)) {
            FileWriter w;
            try {
                w = new FileWriter(new File(this.config.getEclipseProjectDirectory(), MYECLIPSE_MYSTRUTSDATA_FILENAME));
            }
            catch (IOException ex) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
            }
            PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, "UTF-8", null);
            writer.startElement(MYECLIPSE_STRUTS_PROPERTIES);
            writer.startElement(MYECLIPSE_STRUTS_VERSION);
            writer.writeText(this.getStrutsVersion());
            writer.endElement();
            writer.startElement(MYECLIPSE_STRUTS_BASE_PACKAGE);
            writer.writeText(this.getBasePackage());
            writer.endElement();
            writer.startElement(MYECLIPSE_STRUTS_PATTERN);
            writer.writeText(this.getStrutsPattern());
            writer.endElement();
            writer.startElement(MYECLIPSE_STRUTS_SERVLET_NAME);
            writer.writeText(this.getStrutsServletName());
            writer.endElement();
            writer.endElement();
            IOUtil.close((Writer)w);
        }
    }

    private String getStrutsVersion() {
        String version;
        if (this.strutsProps != null && this.strutsProps.get("version") != null) {
            version = (String)this.strutsProps.get("version");
        } else {
            version = IdeUtils.getArtifactVersion(new String[]{"struts", "struts-core"}, this.config.getProject().getDependencies(), 5);
            if (version == null) {
                version = "1.2.9";
            }
        }
        int firstDotIndex = version.indexOf(46);
        int secondDotIndex = version.indexOf(46, firstDotIndex + 1);
        String majorVersion = version.substring(firstDotIndex + 1, secondDotIndex);
        int v = Integer.parseInt(majorVersion);
        return v > 2 ? "2" : majorVersion;
    }

    private String getBasePackage() {
        if (this.strutsProps != null && this.strutsProps.get("base-package") != null) {
            return (String)this.strutsProps.get("base-package");
        }
        return this.config.getProject().getGroupId();
    }

    private String getStrutsPattern() {
        if (this.strutsProps != null && this.strutsProps.get("pattern") != null) {
            String pattern = (String)strutsPatterns.get(this.strutsProps.get("pattern"));
            return pattern != null ? pattern : (String)strutsPatterns.get(MYECLIPSE_STRUTS_DEFAULT_PATTERN);
        }
        return (String)strutsPatterns.get(MYECLIPSE_STRUTS_DEFAULT_PATTERN);
    }

    private String getStrutsServletName() {
        if (this.strutsProps != null && this.strutsProps.get("servlet-name") != null) {
            return (String)this.strutsProps.get("servlet-name");
        }
        return MYECLIPSE_STRUTS_SERVLET_DEFAULT_NAME;
    }
}

