/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear.util;

import java.util.List;
import java.util.Set;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.ear.EarModule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarMavenArchiver
extends MavenArchiver {
    public static final String CLASS_PATH_KEY = "Class-Path";
    private final List<EarModule> earModules;

    public EarMavenArchiver(List<EarModule> earModules) {
        this.earModules = earModules;
    }

    public Manifest getManifest(MavenProject project, MavenArchiveConfiguration config) throws ManifestException, DependencyResolutionRequiredException {
        Manifest manifest = super.getManifest(project, config);
        if (config.getManifest().isAddClasspath()) {
            Manifest.Attribute classPathAttr;
            String earManifestClassPathEntry = this.generateClassPathEntry(config.getManifest().getClasspathPrefix());
            String userSuppliedClassPathEntry = this.getUserSuppliedClassPathEntry(config);
            if (userSuppliedClassPathEntry != null) {
                earManifestClassPathEntry = userSuppliedClassPathEntry + " " + earManifestClassPathEntry;
            }
            if ((classPathAttr = manifest.getMainSection().getAttribute(CLASS_PATH_KEY)) != null) {
                classPathAttr.setValue(earManifestClassPathEntry);
            } else {
                Manifest.Attribute attr = new Manifest.Attribute(CLASS_PATH_KEY, earManifestClassPathEntry);
                manifest.addConfiguredAttribute(attr);
            }
        }
        return manifest;
    }

    protected String generateClassPathEntry(String classPathPrefix) {
        StringBuffer classpath = new StringBuffer();
        for (EarModule earModule : this.earModules) {
            if (earModule.isExcluded()) continue;
            classpath.append(classPathPrefix).append(earModule.getUri()).append(" ");
        }
        return classpath.toString().trim();
    }

    protected String getUserSuppliedClassPathEntry(MavenArchiveConfiguration config) {
        if (config.getManifestEntries() != null) {
            Set keys = config.getManifestEntries().keySet();
            for (String key : keys) {
                String value = (String)config.getManifestEntries().get(key);
                if (!CLASS_PATH_KEY.equals(key) || value == null) continue;
                return value;
            }
        }
        return null;
    }
}

