/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.ear.AbstractEarModule;
import org.apache.maven.plugin.ear.EarPluginException;
import org.codehaus.plexus.util.xml.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarModule
extends AbstractEarModule {
    private Boolean includeInApplicationXml = Boolean.FALSE;

    public JarModule() {
    }

    public JarModule(Artifact a, String defaultLibBundleDir, Boolean includeInApplicationXml) {
        super(a);
        this.setLibBundleDir(defaultLibBundleDir);
        this.includeInApplicationXml = includeInApplicationXml;
    }

    @Override
    public void appendModule(XMLWriter writer, String version, Boolean generateId) {
        if (this.includeInApplicationXml.booleanValue()) {
            this.startModuleElement(writer, generateId);
            writer.startElement("java");
            writer.writeText(this.getUri());
            writer.endElement();
            this.writeAltDeploymentDescriptor(writer, version);
            writer.endElement();
        }
    }

    @Override
    public void resolveArtifact(Set<Artifact> artifacts) throws EarPluginException, MojoFailureException {
        super.resolveArtifact(artifacts);
        this.setLibBundleDir(this.earExecutionContext.getDefaultLibBundleDir());
    }

    @Override
    public String getType() {
        return "jar";
    }

    private void setLibBundleDir(String defaultLibBundleDir) {
        if (defaultLibBundleDir != null && this.bundleDir == null) {
            this.bundleDir = defaultLibBundleDir;
        }
    }

    @Override
    public boolean changeManifestClasspath() {
        return false;
    }
}

