package org.apache.maven.plugin;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

/**
 * @author Jason van Zyl
 * @version $Id: PluginConfigurationException.java 958295 2010-06-26 23:16:18Z hboutemy $
 */
public class PluginConfigurationException
    extends Exception
{
    private PluginDescriptor pluginDescriptor;

    private String originalMessage;

    public PluginConfigurationException( PluginDescriptor pluginDescriptor, String originalMessage )
    {
        super( originalMessage );
        this.pluginDescriptor = pluginDescriptor;
        this.originalMessage = originalMessage;
    }

    public PluginConfigurationException( PluginDescriptor pluginDescriptor, String originalMessage, Throwable cause )
    {
        super( originalMessage, cause );
        this.pluginDescriptor = pluginDescriptor;
        this.originalMessage = originalMessage;
    }

    public PluginConfigurationException( PluginDescriptor pluginDescriptor, String originalMessage,
                                         ExpressionEvaluationException cause )
    {
        super( originalMessage, cause );
        this.pluginDescriptor = pluginDescriptor;
        this.originalMessage = originalMessage;
    }

    public PluginConfigurationException( PluginDescriptor pluginDescriptor, String originalMessage,
                                         ComponentConfigurationException cause )
    {
        super( originalMessage, cause );
        this.pluginDescriptor = pluginDescriptor;
        this.originalMessage = originalMessage;
    }

    public PluginConfigurationException( PluginDescriptor pluginDescriptor, String originalMessage,
                                         ComponentLookupException cause )
    {
        super( originalMessage, cause );
        this.pluginDescriptor = pluginDescriptor;
        this.originalMessage = originalMessage;
    }
}
