/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DebugResolutionListener;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.resolver.WarningResolutionListener;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.transform.ArtifactTransformationManager;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;

public class DefaultArtifactResolver
extends AbstractLogEnabled
implements ArtifactResolver {
    private WagonManager wagonManager;
    private ArtifactTransformationManager transformationManager;
    protected ArtifactFactory artifactFactory;
    private ArtifactCollector artifactCollector;

    public void resolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        this.resolve(artifact, remoteRepositories, localRepository, false);
    }

    public void resolveAlways(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        this.resolve(artifact, remoteRepositories, localRepository, true);
    }

    private void resolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository, boolean force) throws ArtifactResolutionException, ArtifactNotFoundException {
        if (artifact == null) {
            return;
        }
        if ("system".equals(artifact.getScope())) {
            File systemFile = artifact.getFile();
            if (systemFile == null) {
                throw new ArtifactNotFoundException("System artifact: " + artifact + " has no file attached", artifact);
            }
            if (!systemFile.isFile()) {
                throw new ArtifactNotFoundException("System artifact: " + artifact + " is not a file: " + systemFile, artifact);
            }
            if (!systemFile.exists()) {
                throw new ArtifactNotFoundException("System artifact: " + artifact + " not found in path: " + systemFile, artifact);
            }
            artifact.setResolved(true);
        } else if (!artifact.isResolved()) {
            String localPath = localRepository.pathOf(artifact);
            artifact.setFile(new File(localRepository.getBasedir(), localPath));
            this.transformationManager.transformForResolve(artifact, (List)remoteRepositories, localRepository);
            boolean localCopy = false;
            Iterator i = artifact.getMetadataList().iterator();
            while (i.hasNext()) {
                Snapshot snapshot;
                Versioning versioning;
                SnapshotArtifactRepositoryMetadata snapshotMetadata;
                Metadata metadata;
                ArtifactMetadata m = (ArtifactMetadata)i.next();
                if (!(m instanceof SnapshotArtifactRepositoryMetadata) || (metadata = (snapshotMetadata = (SnapshotArtifactRepositoryMetadata)m).getMetadata()) == null || (versioning = metadata.getVersioning()) == null || (snapshot = versioning.getSnapshot()) == null) continue;
                localCopy = snapshot.isLocalCopy();
            }
            File destination = artifact.getFile();
            ArrayList repositories = remoteRepositories;
            if (artifact.isSnapshot() && artifact.getBaseVersion().equals(artifact.getVersion()) && destination.exists() && !localCopy && this.wagonManager.isOnline()) {
                Date comparisonDate = new Date(destination.lastModified());
                repositories = new ArrayList(remoteRepositories);
                Iterator i2 = repositories.iterator();
                while (i2.hasNext()) {
                    ArtifactRepository repository = (ArtifactRepository)i2.next();
                    ArtifactRepositoryPolicy policy = repository.getSnapshots();
                    if (policy.isEnabled() && policy.checkOutOfDate(comparisonDate)) continue;
                    i2.remove();
                }
                if (!repositories.isEmpty()) {
                    force = true;
                }
            }
            boolean resolved = false;
            if (!destination.exists() || force) {
                if (!this.wagonManager.isOnline()) {
                    throw new ArtifactNotFoundException("System is offline.", artifact);
                }
                try {
                    if (artifact.getRepository() != null) {
                        this.wagonManager.getArtifact(artifact, artifact.getRepository());
                    } else {
                        this.wagonManager.getArtifact(artifact, repositories);
                    }
                    if (!artifact.isResolved() && !destination.exists()) {
                        throw new ArtifactResolutionException("Failed to resolve artifact, possibly due to a repository list that is not appropriately equipped for this artifact's metadata.", artifact, this.getMirroredRepositories(remoteRepositories));
                    }
                }
                catch (ResourceDoesNotExistException e) {
                    throw new ArtifactNotFoundException(e.getMessage(), artifact, this.getMirroredRepositories(remoteRepositories), (Throwable)e);
                }
                catch (TransferFailedException e) {
                    throw new ArtifactResolutionException(e.getMessage(), artifact, this.getMirroredRepositories(remoteRepositories), (Throwable)e);
                }
                resolved = true;
            } else if (destination.exists()) {
                artifact.setResolved(true);
            }
            if (artifact.isSnapshot() && !artifact.getBaseVersion().equals(artifact.getVersion())) {
                String version = artifact.getVersion();
                artifact.selectVersion(artifact.getBaseVersion());
                File copy = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
                if (resolved || !copy.exists()) {
                    try {
                        FileUtils.copyFile((File)destination, (File)copy);
                    }
                    catch (IOException e) {
                        throw new ArtifactResolutionException("Unable to copy resolved artifact for local use: " + e.getMessage(), artifact, this.getMirroredRepositories(remoteRepositories), (Throwable)e);
                    }
                }
                artifact.setFile(copy);
                artifact.selectVersion(version);
            }
        }
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, filter);
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, null);
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArrayList<Object> listeners = new ArrayList<Object>();
        if (this.getLogger().isDebugEnabled()) {
            listeners.add(new DebugResolutionListener(this.getLogger()));
        }
        listeners.add(new WarningResolutionListener(this.getLogger()));
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, listeners);
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List listeners) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArtifactResolutionResult artifactResolutionResult = this.artifactCollector.collect(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, listeners);
        ArrayList<Artifact> resolvedArtifacts = new ArrayList<Artifact>();
        ArrayList<Artifact> missingArtifacts = new ArrayList<Artifact>();
        Iterator i = artifactResolutionResult.getArtifactResolutionNodes().iterator();
        while (i.hasNext()) {
            ResolutionNode node = (ResolutionNode)i.next();
            try {
                this.resolve(node.getArtifact(), node.getRemoteRepositories(), localRepository);
                resolvedArtifacts.add(node.getArtifact());
            }
            catch (ArtifactNotFoundException anfe) {
                this.getLogger().debug(anfe.getMessage(), (Throwable)anfe);
                missingArtifacts.add(node.getArtifact());
            }
        }
        if (missingArtifacts.size() > 0) {
            throw new MultipleArtifactsNotFoundException(originatingArtifact, resolvedArtifacts, missingArtifacts, this.getMirroredRepositories(remoteRepositories));
        }
        return artifactResolutionResult;
    }

    private List getMirroredRepositories(List remoteRepositories) {
        HashMap<String, ArtifactRepository> repos = new HashMap<String, ArtifactRepository>();
        Iterator i = remoteRepositories.iterator();
        while (i.hasNext()) {
            ArtifactRepository repository = (ArtifactRepository)i.next();
            ArtifactRepository repo = this.wagonManager.getMirrorRepository(repository);
            repos.put(repo.getId(), repo);
        }
        return new ArrayList(repos.values());
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, List remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, localRepository, remoteRepositories, source, null);
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, List remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source, List listeners) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, null, listeners);
    }
}

