/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DeprecatedUTF8;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.JournalStream;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.UpgradeManagerNamenode;
import org.apache.hadoop.hdfs.server.protocol.CheckpointCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FSImage
extends Storage {
    private static final SimpleDateFormat DATE_FORM = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected FSNamesystem namesystem = null;
    protected long checkpointTime = -1L;
    protected FSEditLog editLog = null;
    private boolean isUpgradeFinalized = false;
    private boolean restoreFailedStorage = false;
    protected List<Storage.StorageDirectory> removedStorageDirs = new ArrayList<Storage.StorageDirectory>();
    private Collection<URI> checkpointDirs;
    private Collection<URI> checkpointEditsDirs;
    protected volatile CheckpointStates ckptState = CheckpointStates.START;
    private static final FsPermission FILE_PERM = new FsPermission(0);
    private static final byte[] PATH_SEPARATOR = DFSUtil.string2Bytes("/");
    private static final DeprecatedUTF8 U_STR = new DeprecatedUTF8();

    FSImage() {
        this((FSNamesystem)null);
    }

    FSImage(FSNamesystem ns) {
        super(HdfsConstants.NodeType.NAME_NODE);
        this.editLog = new FSEditLog(this);
        this.setFSNamesystem(ns);
    }

    FSImage(Collection<URI> fsDirs, Collection<URI> fsEditsDirs) throws IOException {
        this();
        this.setStorageDirectories(fsDirs, fsEditsDirs);
    }

    public FSImage(StorageInfo storageInfo) {
        super(HdfsConstants.NodeType.NAME_NODE, storageInfo);
    }

    FSImage(URI imageDir) throws IOException {
        this();
        ArrayList<URI> dirs = new ArrayList<URI>(1);
        ArrayList<URI> editsDirs = new ArrayList<URI>(1);
        dirs.add(imageDir);
        editsDirs.add(imageDir);
        this.setStorageDirectories(dirs, editsDirs);
    }

    protected FSNamesystem getFSNamesystem() {
        return this.namesystem;
    }

    void setFSNamesystem(FSNamesystem ns) {
        this.namesystem = ns;
    }

    public void setRestoreFailedStorage(boolean val) {
        LOG.info((Object)("set restore failed storage to " + val));
        this.restoreFailedStorage = val;
    }

    public boolean getRestoreFailedStorage() {
        return this.restoreFailedStorage;
    }

    void setStorageDirectories(Collection<URI> fsNameDirs, Collection<URI> fsEditsDirs) throws IOException {
        this.storageDirs = new ArrayList();
        this.removedStorageDirs = new ArrayList<Storage.StorageDirectory>();
        for (URI dirName : fsNameDirs) {
            NameNodeDirType dirType;
            FSImage.checkSchemeConsistency(dirName);
            boolean isAlsoEdits = false;
            for (URI editsDirName : fsEditsDirs) {
                if (editsDirName.compareTo(dirName) != 0) continue;
                isAlsoEdits = true;
                fsEditsDirs.remove(editsDirName);
                break;
            }
            NameNodeDirType nameNodeDirType = dirType = isAlsoEdits ? NameNodeDirType.IMAGE_AND_EDITS : NameNodeDirType.IMAGE;
            if (dirName.getScheme().compareTo(JournalStream.JournalType.FILE.name().toLowerCase()) != 0) continue;
            this.addStorageDir(new Storage.StorageDirectory(new File(dirName.getPath()), dirType));
        }
        for (URI dirName : fsEditsDirs) {
            FSImage.checkSchemeConsistency(dirName);
            if (dirName.getScheme().compareTo(JournalStream.JournalType.FILE.name().toLowerCase()) != 0) continue;
            this.addStorageDir(new Storage.StorageDirectory(new File(dirName.getPath()), NameNodeDirType.EDITS));
        }
    }

    static void checkSchemeConsistency(URI u) throws IOException {
        String scheme = u.getScheme();
        if (scheme == null) {
            throw new IOException("Undefined scheme for " + u);
        }
        try {
            JournalStream.JournalType.valueOf(scheme.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            throw new IOException("Unknown scheme " + scheme + ". It should correspond to a JournalType enumeration value");
        }
    }

    void setCheckpointDirectories(Collection<URI> dirs, Collection<URI> editsDirs) {
        this.checkpointDirs = dirs;
        this.checkpointEditsDirs = editsDirs;
    }

    static File getImageFile(Storage.StorageDirectory sd, NameNodeFile type) {
        return new File(sd.getCurrentDir(), type.getName());
    }

    List<Storage.StorageDirectory> getRemovedStorageDirs() {
        return this.removedStorageDirs;
    }

    File getEditFile(Storage.StorageDirectory sd) {
        return FSImage.getImageFile(sd, NameNodeFile.EDITS);
    }

    File getEditNewFile(Storage.StorageDirectory sd) {
        return FSImage.getImageFile(sd, NameNodeFile.EDITS_NEW);
    }

    Collection<File> getFiles(NameNodeFile type, NameNodeDirType dirType) {
        Iterator<Storage.StorageDirectory> it;
        ArrayList<File> list = new ArrayList<File>();
        Iterator<Storage.StorageDirectory> iterator = it = dirType == null ? this.dirIterator() : this.dirIterator(dirType);
        while (it.hasNext()) {
            list.add(FSImage.getImageFile(it.next(), type));
        }
        return list;
    }

    Collection<URI> getDirectories(NameNodeDirType dirType) throws IOException {
        Iterator<Storage.StorageDirectory> it;
        ArrayList<URI> list = new ArrayList<URI>();
        Iterator<Storage.StorageDirectory> iterator = it = dirType == null ? this.dirIterator() : this.dirIterator(dirType);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            try {
                list.add(Util.fileAsURI(sd.getRoot()));
            }
            catch (IOException e) {
                throw new IOException("Exception while processing StorageDirectory " + sd.getRoot(), e);
            }
        }
        return list;
    }

    Collection<URI> getImageDirectories() throws IOException {
        return this.getDirectories(NameNodeDirType.IMAGE);
    }

    Collection<URI> getEditsDirectories() throws IOException {
        return this.getDirectories(NameNodeDirType.EDITS);
    }

    int getNumStorageDirs(NameNodeDirType dirType) {
        if (dirType == null) {
            return this.getNumStorageDirs();
        }
        Iterator<Storage.StorageDirectory> it = this.dirIterator(dirType);
        int numDirs = 0;
        while (it.hasNext()) {
            ++numDirs;
            it.next();
        }
        return numDirs;
    }

    boolean recoverTransitionRead(Collection<URI> dataDirs, Collection<URI> editsDirs, HdfsConstants.StartupOption startOpt) throws IOException {
        Storage.StorageState curState;
        Storage.StorageDirectory sd;
        assert (startOpt != HdfsConstants.StartupOption.FORMAT) : "NameNode formatting should be performed before reading the image";
        if ((dataDirs.size() == 0 || editsDirs.size() == 0) && startOpt != HdfsConstants.StartupOption.IMPORT) {
            throw new IOException("All specified directories are not accessible or do not exist.");
        }
        if (startOpt == HdfsConstants.StartupOption.IMPORT && (this.checkpointDirs == null || this.checkpointDirs.isEmpty())) {
            throw new IOException("Cannot import image from a checkpoint. \"dfs.namenode.checkpoint.dir\" is not set.");
        }
        if (startOpt == HdfsConstants.StartupOption.IMPORT && (this.checkpointEditsDirs == null || this.checkpointEditsDirs.isEmpty())) {
            throw new IOException("Cannot import image from a checkpoint. \"dfs.namenode.checkpoint.dir\" is not set.");
        }
        this.setStorageDirectories(dataDirs, editsDirs);
        HashMap<Storage.StorageDirectory, Storage.StorageState> dataDirStates = new HashMap<Storage.StorageDirectory, Storage.StorageState>();
        boolean isFormatted = false;
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            sd = it.next();
            try {
                curState = sd.analyzeStorage(startOpt);
                switch (curState) {
                    case NON_EXISTENT: {
                        throw new InconsistentFSStateException(sd.getRoot(), "storage directory does not exist or is not accessible.");
                    }
                    case NOT_FORMATTED: {
                        break;
                    }
                    case NORMAL: {
                        break;
                    }
                    default: {
                        sd.doRecover(curState);
                    }
                }
                if (curState != Storage.StorageState.NOT_FORMATTED && startOpt != HdfsConstants.StartupOption.ROLLBACK) {
                    sd.read();
                    isFormatted = true;
                }
                if (startOpt == HdfsConstants.StartupOption.IMPORT && isFormatted) {
                    throw new IOException("Cannot import image from a checkpoint.  NameNode already contains an image in " + sd.getRoot());
                }
            }
            catch (IOException ioe) {
                sd.unlock();
                throw ioe;
            }
            dataDirStates.put(sd, curState);
        }
        if (!isFormatted && startOpt != HdfsConstants.StartupOption.ROLLBACK && startOpt != HdfsConstants.StartupOption.IMPORT) {
            throw new IOException("NameNode is not formatted.");
        }
        if (this.layoutVersion < -3) {
            FSImage.checkVersionUpgradable(this.layoutVersion);
        }
        if (startOpt != HdfsConstants.StartupOption.UPGRADE && this.layoutVersion < -3 && this.layoutVersion != -24) {
            throw new IOException("\nFile system image contains an old layout version " + this.layoutVersion + ".\nAn upgrade to version " + -24 + " is required.\nPlease restart NameNode with -upgrade option.");
        }
        this.verifyDistributedUpgradeProgress(startOpt);
        this.checkpointTime = 0L;
        it = this.dirIterator();
        while (it.hasNext()) {
            sd = it.next();
            curState = (Storage.StorageState)((Object)dataDirStates.get(sd));
            switch (curState) {
                case NON_EXISTENT: {
                    throw new IOException((Object)((Object)Storage.StorageState.NON_EXISTENT) + " state cannot be here");
                }
                case NOT_FORMATTED: {
                    LOG.info((Object)("Storage directory " + sd.getRoot() + " is not formatted."));
                    LOG.info((Object)"Formatting ...");
                    sd.clearDirectory();
                    break;
                }
            }
        }
        switch (startOpt) {
            case UPGRADE: {
                this.doUpgrade();
                return false;
            }
            case IMPORT: {
                this.doImportCheckpoint();
                return false;
            }
            case ROLLBACK: {
                this.doRollback();
                break;
            }
        }
        boolean needToSave = this.loadFSImage();
        assert (this.editLog != null) : "editLog must be initialized";
        if (!this.editLog.isOpen()) {
            this.editLog.open();
        }
        return needToSave;
    }

    private void doUpgrade() throws IOException {
        if (this.getDistributedUpgradeState()) {
            this.loadFSImage();
            this.initializeDistributedUpgrade();
            return;
        }
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            if (!sd.getPreviousDir().exists()) continue;
            throw new InconsistentFSStateException(sd.getRoot(), "previous fs state should not exist during upgrade. Finalize or rollback first.");
        }
        this.loadFSImage();
        long oldCTime = this.getCTime();
        this.cTime = FSNamesystem.now();
        int oldLV = this.getLayoutVersion();
        this.layoutVersion = -24;
        this.checkpointTime = FSNamesystem.now();
        Iterator<Storage.StorageDirectory> it2 = this.dirIterator();
        while (it2.hasNext()) {
            Storage.StorageDirectory sd = it2.next();
            LOG.info((Object)("Upgrading image directory " + sd.getRoot() + ".\n   old LV = " + oldLV + "; old CTime = " + oldCTime + ".\n   new LV = " + this.getLayoutVersion() + "; new CTime = " + this.getCTime()));
            File curDir = sd.getCurrentDir();
            File prevDir = sd.getPreviousDir();
            File tmpDir = sd.getPreviousTmp();
            assert (curDir.exists()) : "Current directory must exist.";
            assert (!prevDir.exists()) : "prvious directory must not exist.";
            assert (!tmpDir.exists()) : "prvious.tmp directory must not exist.";
            assert (!this.editLog.isOpen()) : "Edits log must not be open.";
            FSImage.rename(curDir, tmpDir);
            this.saveCurrent(sd);
            FSImage.rename(tmpDir, prevDir);
            this.isUpgradeFinalized = false;
            LOG.info((Object)("Upgrade of " + sd.getRoot() + " is complete."));
        }
        this.initializeDistributedUpgrade();
        this.editLog.open();
    }

    private void doRollback() throws IOException {
        File prevDir;
        Storage.StorageDirectory sd;
        boolean canRollback = false;
        FSImage prevState = new FSImage(this.getFSNamesystem());
        prevState.layoutVersion = -24;
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            sd = it.next();
            prevDir = sd.getPreviousDir();
            if (!prevDir.exists()) {
                LOG.info((Object)("Storage directory " + sd.getRoot() + " does not contain previous fs state."));
                sd.read();
                continue;
            }
            FSImage fSImage = prevState;
            fSImage.getClass();
            Storage.StorageDirectory sdPrev = fSImage.new Storage.StorageDirectory(sd.getRoot());
            sdPrev.read(sdPrev.getPreviousVersionFile());
            canRollback = true;
        }
        if (!canRollback) {
            throw new IOException("Cannot rollback. None of the storage directories contain previous fs state.");
        }
        it = this.dirIterator();
        while (it.hasNext()) {
            sd = it.next();
            prevDir = sd.getPreviousDir();
            if (!prevDir.exists()) continue;
            LOG.info((Object)("Rolling back storage directory " + sd.getRoot() + ".\n   new LV = " + prevState.getLayoutVersion() + "; new CTime = " + prevState.getCTime()));
            File tmpDir = sd.getRemovedTmp();
            assert (!tmpDir.exists()) : "removed.tmp directory must not exist.";
            File curDir = sd.getCurrentDir();
            assert (curDir.exists()) : "Current directory must exist.";
            FSImage.rename(curDir, tmpDir);
            FSImage.rename(prevDir, curDir);
            FSImage.deleteDir(tmpDir);
            LOG.info((Object)("Rollback of " + sd.getRoot() + " is complete."));
        }
        this.isUpgradeFinalized = true;
        this.verifyDistributedUpgradeProgress(HdfsConstants.StartupOption.REGULAR);
    }

    private void doFinalize(Storage.StorageDirectory sd) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            LOG.info((Object)("Directory " + prevDir + " does not exist."));
            LOG.info((Object)("Finalize upgrade for " + sd.getRoot() + " is not required."));
            return;
        }
        LOG.info((Object)("Finalizing upgrade for storage directory " + sd.getRoot() + "." + (this.getLayoutVersion() == 0 ? "" : "\n   cur LV = " + this.getLayoutVersion() + "; cur CTime = " + this.getCTime())));
        assert (sd.getCurrentDir().exists()) : "Current directory must exist.";
        File tmpDir = sd.getFinalizedTmp();
        FSImage.rename(prevDir, tmpDir);
        FSImage.deleteDir(tmpDir);
        this.isUpgradeFinalized = true;
        LOG.info((Object)("Finalize upgrade for " + sd.getRoot() + " is complete."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doImportCheckpoint() throws IOException {
        FSNamesystem fsNamesys = this.getFSNamesystem();
        FSImage ckptImage = new FSImage(fsNamesys);
        FSImage realImage = fsNamesys.getFSImage();
        assert (realImage == this);
        fsNamesys.dir.fsImage = ckptImage;
        try {
            ckptImage.recoverTransitionRead(this.checkpointDirs, this.checkpointEditsDirs, HdfsConstants.StartupOption.REGULAR);
        }
        finally {
            ckptImage.close();
        }
        realImage.setStorageInfo(ckptImage);
        this.checkpointTime = ckptImage.checkpointTime;
        fsNamesys.dir.fsImage = realImage;
        this.saveNamespace(false);
    }

    void finalizeUpgrade() throws IOException {
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            this.doFinalize(it.next());
        }
    }

    boolean isUpgradeFinalized() {
        return this.isUpgradeFinalized;
    }

    @Override
    protected void getFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        super.getFields(props, sd);
        if (this.layoutVersion == 0) {
            throw new IOException("NameNode directory " + sd.getRoot() + " is not formatted.");
        }
        String sDUS = props.getProperty("distributedUpgradeState");
        String sDUV = props.getProperty("distributedUpgradeVersion");
        this.setDistributedUpgradeState(sDUS == null ? false : Boolean.parseBoolean(sDUS), sDUV == null ? this.getLayoutVersion() : Integer.parseInt(sDUV));
        this.checkpointTime = this.readCheckpointTime(sd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long readCheckpointTime(Storage.StorageDirectory sd) throws IOException {
        File timeFile = FSImage.getImageFile(sd, NameNodeFile.TIME);
        long timeStamp = 0L;
        if (timeFile.exists() && timeFile.canRead()) {
            DataInputStream in = new DataInputStream(new FileInputStream(timeFile));
            try {
                timeStamp = in.readLong();
            }
            finally {
                in.close();
            }
        }
        return timeStamp;
    }

    @Override
    protected void setFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        super.setFields(props, sd);
        boolean uState = this.getDistributedUpgradeState();
        int uVersion = this.getDistributedUpgradeVersion();
        if (uState && uVersion != this.getLayoutVersion()) {
            props.setProperty("distributedUpgradeState", Boolean.toString(uState));
            props.setProperty("distributedUpgradeVersion", Integer.toString(uVersion));
        }
        this.writeCheckpointTime(sd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCheckpointTime(Storage.StorageDirectory sd) throws IOException {
        if (this.checkpointTime < 0L) {
            return;
        }
        File timeFile = FSImage.getImageFile(sd, NameNodeFile.TIME);
        if (timeFile.exists() && !timeFile.delete()) {
            LOG.error((Object)("Cannot delete chekpoint time file: " + timeFile.getCanonicalPath()));
        }
        DataOutputStream out = new DataOutputStream(new FileOutputStream(timeFile));
        try {
            out.writeLong(this.checkpointTime);
        }
        finally {
            out.close();
        }
    }

    void incrementCheckpointTime() {
        this.setCheckpointTime(this.checkpointTime + 1L);
    }

    long getCheckpointTime() {
        return this.checkpointTime;
    }

    void setCheckpointTime(long newCpT) {
        this.checkpointTime = newCpT;
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            try {
                this.writeCheckpointTime(sd);
            }
            catch (IOException e) {
                LOG.warn((Object)("incrementCheckpointTime failed on " + sd.getRoot().getPath() + ";type=" + sd.getStorageDirType()));
            }
        }
    }

    void processIOError(ArrayList<Storage.StorageDirectory> sds, boolean propagate) {
        ArrayList<EditLogOutputStream> al = null;
        block2: for (Storage.StorageDirectory sd : sds) {
            if (propagate && sd.getStorageDirType().isOfType(NameNodeDirType.EDITS)) {
                EditLogOutputStream eStream = this.editLog.getEditsStream(sd);
                if (al == null) {
                    al = new ArrayList<EditLogOutputStream>(1);
                }
                al.add(eStream);
            }
            Iterator<Storage.StorageDirectory> it = this.dirIterator();
            while (it.hasNext()) {
                Storage.StorageDirectory sd1 = it.next();
                if (!sd.equals(sd1)) continue;
                LOG.warn((Object)("FSImage:processIOError: removing storage: " + sd.getRoot().getPath()));
                try {
                    sd1.unlock();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.removedStorageDirs.add(sd1);
                it.remove();
                continue block2;
            }
        }
        if (propagate && al != null) {
            this.editLog.processIOError(al, false);
        }
        if (propagate) {
            this.incrementCheckpointTime();
        }
    }

    public FSEditLog getEditLog() {
        return this.editLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConversionNeeded(Storage.StorageDirectory sd) throws IOException {
        File oldImageDir = new File(sd.getRoot(), "image");
        if (!oldImageDir.exists()) {
            if (sd.getVersionFile().exists()) {
                throw new InconsistentFSStateException(sd.getRoot(), oldImageDir + " does not exist.");
            }
            return false;
        }
        File oldF = new File(oldImageDir, "fsimage");
        RandomAccessFile oldFile = new RandomAccessFile(oldF, "rws");
        try {
            oldFile.seek(0L);
            int odlVersion = oldFile.readInt();
            if (odlVersion < -3) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            oldFile.close();
        }
        return true;
    }

    boolean recoverInterruptedCheckpoint(Storage.StorageDirectory nameSD, Storage.StorageDirectory editsSD) throws IOException {
        boolean needToSave = false;
        File curFile = FSImage.getImageFile(nameSD, NameNodeFile.IMAGE);
        File ckptFile = FSImage.getImageFile(nameSD, NameNodeFile.IMAGE_NEW);
        if (ckptFile.exists()) {
            needToSave = true;
            if (FSImage.getImageFile(editsSD, NameNodeFile.EDITS_NEW).exists()) {
                if (!ckptFile.delete()) {
                    throw new IOException("Unable to delete " + ckptFile);
                }
            } else if (!ckptFile.renameTo(curFile)) {
                if (!curFile.delete()) {
                    LOG.warn((Object)("Unable to delete dir " + curFile + " before rename"));
                }
                if (!ckptFile.renameTo(curFile)) {
                    throw new IOException("Unable to rename " + ckptFile + " to " + curFile);
                }
            }
        }
        return needToSave;
    }

    boolean loadFSImage() throws IOException {
        long latestNameCheckpointTime = Long.MIN_VALUE;
        long latestEditsCheckpointTime = Long.MIN_VALUE;
        boolean needToSave = false;
        this.isUpgradeFinalized = true;
        Storage.StorageDirectory latestNameSD = null;
        Storage.StorageDirectory latestEditsSD = null;
        ArrayList<String> imageDirs = new ArrayList<String>();
        ArrayList<String> editsDirs = new ArrayList<String>();
        HashSet<Long> checkpointTimes = new HashSet<Long>();
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            if (!sd.getVersionFile().exists()) {
                needToSave |= true;
                continue;
            }
            boolean imageExists = false;
            boolean editsExists = false;
            if (sd.getStorageDirType().isOfType(NameNodeDirType.IMAGE)) {
                imageExists = FSImage.getImageFile(sd, NameNodeFile.IMAGE).exists();
                imageDirs.add(sd.getRoot().getCanonicalPath());
            }
            if (sd.getStorageDirType().isOfType(NameNodeDirType.EDITS)) {
                editsExists = FSImage.getImageFile(sd, NameNodeFile.EDITS).exists();
                editsDirs.add(sd.getRoot().getCanonicalPath());
            }
            this.checkpointTime = this.readCheckpointTime(sd);
            checkpointTimes.add(this.checkpointTime);
            if (sd.getStorageDirType().isOfType(NameNodeDirType.IMAGE) && latestNameCheckpointTime < this.checkpointTime && imageExists) {
                latestNameCheckpointTime = this.checkpointTime;
                latestNameSD = sd;
            }
            if (sd.getStorageDirType().isOfType(NameNodeDirType.EDITS) && latestEditsCheckpointTime < this.checkpointTime && editsExists) {
                latestEditsCheckpointTime = this.checkpointTime;
                latestEditsSD = sd;
            }
            if (this.checkpointTime <= 0L) {
                needToSave |= true;
            }
            this.isUpgradeFinalized = this.isUpgradeFinalized && !sd.getPreviousDir().exists();
        }
        if (latestNameSD == null) {
            throw new IOException("Image file is not found in " + imageDirs);
        }
        if (latestEditsSD == null) {
            throw new IOException("Edits file is not found in " + editsDirs);
        }
        if (latestNameCheckpointTime > latestEditsCheckpointTime && latestNameSD != latestEditsSD && latestNameSD.getStorageDirType() == NameNodeDirType.IMAGE && latestEditsSD.getStorageDirType() == NameNodeDirType.EDITS) {
            LOG.error((Object)"This is a rare failure scenario!!!");
            LOG.error((Object)("Image checkpoint time " + latestNameCheckpointTime + " > edits checkpoint time " + latestEditsCheckpointTime));
            LOG.error((Object)"Name-node will treat the image as the latest state of the namespace. Old edits will be discarded.");
        } else if (latestNameCheckpointTime != latestEditsCheckpointTime) {
            throw new IOException("Inconsistent storage detected, image and edits checkpoint times do not match. image checkpoint time = " + latestNameCheckpointTime + "edits checkpoint time = " + latestEditsCheckpointTime);
        }
        needToSave |= checkpointTimes.size() != 1;
        needToSave |= this.recoverInterruptedCheckpoint(latestNameSD, latestEditsSD);
        long startTime = FSNamesystem.now();
        long imageSize = FSImage.getImageFile(latestNameSD, NameNodeFile.IMAGE).length();
        latestNameSD.read();
        needToSave |= this.loadFSImage(FSImage.getImageFile(latestNameSD, NameNodeFile.IMAGE));
        LOG.info((Object)("Image file of size " + imageSize + " loaded in " + (FSNamesystem.now() - startTime) / 1000L + " seconds."));
        needToSave = latestNameCheckpointTime > latestEditsCheckpointTime ? (needToSave |= true) : (needToSave |= this.loadFSEdits(latestEditsSD) > 0);
        return needToSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean loadFSImage(File curFile) throws IOException {
        assert (this.getLayoutVersion() < 0) : "Negative layout version is expected.";
        assert (curFile != null) : "curFile is null";
        FSNamesystem fsNamesys = this.getFSNamesystem();
        FSDirectory fsDir = fsNamesys.dir;
        boolean needToSave = true;
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(curFile)));
        try {
            int imgVersion = in.readInt();
            this.namespaceID = in.readInt();
            long numFiles = imgVersion <= -16 ? in.readLong() : (long)in.readInt();
            this.layoutVersion = imgVersion;
            if (imgVersion <= -12) {
                long genstamp = in.readLong();
                fsNamesys.setGenerationStamp(genstamp);
            }
            needToSave = imgVersion != -24;
            short replication = fsNamesys.getDefaultReplication();
            LOG.info((Object)("Number of files = " + numFiles));
            String parentPath = "";
            INodeDirectory parentINode = fsDir.rootDir;
            for (long i = 0L; i < numFiles; ++i) {
                long modificationTime = 0L;
                long atime = 0L;
                long blockSize = 0L;
                String path = FSImage.readString(in);
                replication = in.readShort();
                replication = this.editLog.adjustReplication(replication);
                modificationTime = in.readLong();
                if (imgVersion <= -17) {
                    atime = in.readLong();
                }
                if (imgVersion <= -8) {
                    blockSize = in.readLong();
                }
                int numBlocks = in.readInt();
                Block[] blocks = null;
                if (-9 <= imgVersion && numBlocks > 0 || imgVersion < -9 && numBlocks >= 0) {
                    blocks = new Block[numBlocks];
                    for (int j = 0; j < numBlocks; ++j) {
                        blocks[j] = new Block();
                        if (-14 < imgVersion) {
                            blocks[j].set(in.readLong(), in.readLong(), 0L);
                            continue;
                        }
                        blocks[j].readFields(in);
                    }
                }
                if (-8 <= imgVersion && blockSize == 0L) {
                    if (numBlocks > 1) {
                        blockSize = blocks[0].getNumBytes();
                    } else {
                        long first = numBlocks == 1 ? blocks[0].getNumBytes() : 0L;
                        blockSize = Math.max(fsNamesys.getDefaultBlockSize(), first);
                    }
                }
                long nsQuota = -1L;
                if (imgVersion <= -16 && blocks == null && numBlocks == -1) {
                    nsQuota = in.readLong();
                }
                long dsQuota = -1L;
                if (imgVersion <= -18 && blocks == null && numBlocks == -1) {
                    dsQuota = in.readLong();
                }
                String symlink = "";
                if (imgVersion <= -23 && numBlocks == -2) {
                    symlink = Text.readString((DataInput)in);
                }
                PermissionStatus permissions = fsNamesys.getUpgradePermission();
                if (imgVersion <= -11) {
                    permissions = PermissionStatus.read((DataInput)in);
                }
                if (path.length() == 0) {
                    if (nsQuota != -1L || dsQuota != -1L) {
                        fsDir.rootDir.setQuota(nsQuota, dsQuota);
                    }
                    fsDir.rootDir.setModificationTime(modificationTime);
                    fsDir.rootDir.setPermissionStatus(permissions);
                    continue;
                }
                if (!this.isParent(path, parentPath)) {
                    parentINode = null;
                    parentPath = this.getParent(path);
                }
                parentINode = fsDir.addToParent(path, parentINode, permissions, blocks, symlink, replication, modificationTime, atime, nsQuota, dsQuota, blockSize);
            }
            this.loadDatanodes(imgVersion, in);
            this.loadFilesUnderConstruction(imgVersion, in, fsNamesys);
            this.loadSecretManagerState(imgVersion, in, fsNamesys);
        }
        finally {
            in.close();
        }
        return needToSave;
    }

    String getParent(String path) {
        return path.substring(0, path.lastIndexOf("/"));
    }

    private boolean isParent(String path, String parent) {
        return parent != null && path != null && path.indexOf(parent) == 0 && path.lastIndexOf("/") == parent.length();
    }

    int loadFSEdits(Storage.StorageDirectory sd) throws IOException {
        int numEdits = 0;
        EditLogFileInputStream edits = new EditLogFileInputStream(FSImage.getImageFile(sd, NameNodeFile.EDITS));
        numEdits = this.editLog.loadFSEdits(edits);
        edits.close();
        File editsNew = FSImage.getImageFile(sd, NameNodeFile.EDITS_NEW);
        if (editsNew.exists() && editsNew.length() > 0L) {
            edits = new EditLogFileInputStream(editsNew);
            numEdits += this.editLog.loadFSEdits(edits);
            edits.close();
        }
        this.getFSNamesystem().dir.updateCountForINodeWithQuota();
        return numEdits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveFSImage(File newFile) throws IOException {
        FSNamesystem fsNamesys = this.getFSNamesystem();
        FSDirectory fsDir = fsNamesys.dir;
        long startTime = FSNamesystem.now();
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(newFile)));
        try {
            out.writeInt(-24);
            out.writeInt(this.namespaceID);
            out.writeLong(fsDir.rootDir.numItemsInTree());
            out.writeLong(fsNamesys.getGenerationStamp());
            byte[] byteStore = new byte[32000];
            ByteBuffer strbuf = ByteBuffer.wrap(byteStore);
            FSImage.saveINode2Image(strbuf, fsDir.rootDir, out);
            FSImage.saveImage(strbuf, 0, fsDir.rootDir, out);
            fsNamesys.saveFilesUnderConstruction(out);
            fsNamesys.saveSecretManagerState(out);
            strbuf = null;
        }
        finally {
            out.close();
        }
        LOG.info((Object)("Image file of size " + newFile.length() + " saved in " + (FSNamesystem.now() - startTime) / 1000L + " seconds."));
    }

    void saveNamespace(boolean renewCheckpointTime) throws IOException {
        Storage.StorageDirectory sd;
        assert (this.editLog != null) : "editLog must be initialized";
        this.editLog.close();
        if (renewCheckpointTime) {
            this.checkpointTime = FSNamesystem.now();
        }
        ArrayList<Storage.StorageDirectory> errorSDs = new ArrayList<Storage.StorageDirectory>();
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            sd = it.next();
            try {
                this.moveCurrent(sd);
            }
            catch (IOException ie) {
                LOG.error((Object)("Unable to move current for " + sd.getRoot()), (Throwable)ie);
                errorSDs.add(sd);
            }
        }
        it = this.dirIterator(NameNodeDirType.IMAGE);
        while (it.hasNext()) {
            sd = it.next();
            try {
                this.saveCurrent(sd);
            }
            catch (IOException ie) {
                LOG.error((Object)("Unable to save image for " + sd.getRoot()), (Throwable)ie);
                errorSDs.add(sd);
            }
        }
        it = this.dirIterator(NameNodeDirType.EDITS);
        while (it.hasNext()) {
            sd = it.next();
            try {
                this.saveCurrent(sd);
            }
            catch (IOException ie) {
                LOG.error((Object)("Unable to save edits for " + sd.getRoot()), (Throwable)ie);
                errorSDs.add(sd);
            }
        }
        it = this.dirIterator();
        while (it.hasNext()) {
            sd = it.next();
            try {
                this.moveLastCheckpoint(sd);
            }
            catch (IOException ie) {
                LOG.error((Object)("Unable to move last checkpoint for " + sd.getRoot()), (Throwable)ie);
                errorSDs.add(sd);
            }
        }
        this.processIOError(errorSDs, false);
        if (!this.editLog.isOpen()) {
            this.editLog.open();
        }
        this.ckptState = CheckpointStates.UPLOAD_DONE;
    }

    protected void saveCurrent(Storage.StorageDirectory sd) throws IOException {
        File curDir = sd.getCurrentDir();
        NameNodeDirType dirType = (NameNodeDirType)sd.getStorageDirType();
        if (!curDir.exists() && !curDir.mkdir()) {
            throw new IOException("Cannot create directory " + curDir);
        }
        if (dirType.isOfType(NameNodeDirType.IMAGE)) {
            this.saveFSImage(FSImage.getImageFile(sd, NameNodeFile.IMAGE));
        }
        if (dirType.isOfType(NameNodeDirType.EDITS)) {
            this.editLog.createEditLogFile(FSImage.getImageFile(sd, NameNodeFile.EDITS));
        }
        sd.write();
    }

    protected void moveCurrent(Storage.StorageDirectory sd) throws IOException {
        File curDir = sd.getCurrentDir();
        File tmpCkptDir = sd.getLastCheckpointTmp();
        if (sd.getVersionFile().exists()) {
            assert (curDir.exists()) : curDir + " directory must exist.";
            assert (!tmpCkptDir.exists()) : tmpCkptDir + " directory must not exist.";
            FSImage.rename(curDir, tmpCkptDir);
        }
        if (!curDir.exists() && !curDir.mkdir()) {
            throw new IOException("Cannot create directory " + curDir);
        }
    }

    protected void moveLastCheckpoint(Storage.StorageDirectory sd) throws IOException {
        File tmpCkptDir = sd.getLastCheckpointTmp();
        File prevCkptDir = sd.getPreviousCheckpoint();
        if (prevCkptDir.exists()) {
            FSImage.deleteDir(prevCkptDir);
        }
        if (tmpCkptDir.exists()) {
            FSImage.rename(tmpCkptDir, prevCkptDir);
        }
    }

    private int newNamespaceID() {
        Random r = new Random();
        r.setSeed(FSNamesystem.now());
        int newID = 0;
        while (newID == 0) {
            newID = r.nextInt(Integer.MAX_VALUE);
        }
        return newID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void format(Storage.StorageDirectory sd) throws IOException {
        sd.clearDirectory();
        sd.lock();
        try {
            this.saveCurrent(sd);
        }
        finally {
            sd.unlock();
        }
        LOG.info((Object)("Storage directory " + sd.getRoot() + " has been successfully formatted."));
    }

    public void format() throws IOException {
        this.layoutVersion = -24;
        this.namespaceID = this.newNamespaceID();
        this.cTime = 0L;
        this.checkpointTime = FSNamesystem.now();
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            this.format(sd);
        }
    }

    private static void saveINode2Image(ByteBuffer name, INode node, DataOutputStream out) throws IOException {
        int nameLen = name.position();
        out.writeShort(nameLen);
        out.write(name.array(), name.arrayOffset(), nameLen);
        if (node.isDirectory()) {
            out.writeShort(0);
            out.writeLong(node.getModificationTime());
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeInt(-1);
            out.writeLong(node.getNsQuota());
            out.writeLong(node.getDsQuota());
            FILE_PERM.fromShort(node.getFsPermissionShort());
            PermissionStatus.write((DataOutput)out, (String)node.getUserName(), (String)node.getGroupName(), (FsPermission)FILE_PERM);
        } else if (node.isLink()) {
            out.writeShort(0);
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeInt(-2);
            Text.writeString((DataOutput)out, (String)((INodeSymlink)node).getLinkValue());
            FILE_PERM.fromShort(node.getFsPermissionShort());
            PermissionStatus.write((DataOutput)out, (String)node.getUserName(), (String)node.getGroupName(), (FsPermission)FILE_PERM);
        } else {
            INodeFile fileINode = (INodeFile)node;
            out.writeShort(fileINode.getReplication());
            out.writeLong(fileINode.getModificationTime());
            out.writeLong(fileINode.getAccessTime());
            out.writeLong(fileINode.getPreferredBlockSize());
            BlockInfo[] blocks = fileINode.getBlocks();
            out.writeInt(blocks.length);
            for (BlockInfo blk : blocks) {
                blk.write(out);
            }
            FILE_PERM.fromShort(fileINode.getFsPermissionShort());
            PermissionStatus.write((DataOutput)out, (String)fileINode.getUserName(), (String)fileINode.getGroupName(), (FsPermission)FILE_PERM);
        }
    }

    private static void saveImage(ByteBuffer parentPrefix, int prefixLength, INodeDirectory current, DataOutputStream out) throws IOException {
        int newPrefixLength = prefixLength;
        if (current.getChildrenRaw() == null) {
            return;
        }
        for (INode child : current.getChildren()) {
            parentPrefix.position(prefixLength);
            parentPrefix.put(PATH_SEPARATOR).put(child.getLocalNameBytes());
            FSImage.saveINode2Image(parentPrefix, child, out);
        }
        for (INode child : current.getChildren()) {
            if (!child.isDirectory()) continue;
            parentPrefix.position(prefixLength);
            parentPrefix.put(PATH_SEPARATOR).put(child.getLocalNameBytes());
            newPrefixLength = parentPrefix.position();
            FSImage.saveImage(parentPrefix, newPrefixLength, (INodeDirectory)child, out);
        }
        parentPrefix.position(prefixLength);
    }

    void loadDatanodes(int version, DataInputStream in) throws IOException {
        if (version > -3) {
            return;
        }
        if (version <= -12) {
            return;
        }
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            DatanodeImage nodeImage = new DatanodeImage();
            nodeImage.readFields(in);
        }
    }

    private void loadFilesUnderConstruction(int version, DataInputStream in, FSNamesystem fs) throws IOException {
        FSDirectory fsDir = fs.dir;
        if (version > -13) {
            return;
        }
        int size = in.readInt();
        LOG.info((Object)("Number of files under construction = " + size));
        for (int i = 0; i < size; ++i) {
            INodeFileUnderConstruction cons = FSImage.readINodeUnderConstruction(in);
            String path = cons.getLocalName();
            INodeFile old = fsDir.getFileINode(path);
            if (old == null) {
                throw new IOException("Found lease for non-existent file " + path);
            }
            if (((INode)old).isDirectory()) {
                throw new IOException("Found lease for directory " + path);
            }
            INodeFile oldnode = old;
            fsDir.replaceNode(path, oldnode, cons);
            fs.leaseManager.addLease(cons.getClientName(), path);
        }
    }

    private void loadSecretManagerState(int version, DataInputStream in, FSNamesystem fs) throws IOException {
        if (version > -23) {
            return;
        }
        fs.loadSecretManagerState(in);
    }

    static INodeFileUnderConstruction readINodeUnderConstruction(DataInputStream in) throws IOException {
        int i;
        byte[] name = FSImage.readBytes(in);
        short blockReplication = in.readShort();
        long modificationTime = in.readLong();
        long preferredBlockSize = in.readLong();
        int numBlocks = in.readInt();
        BlockInfo[] blocks = new BlockInfo[numBlocks];
        Block blk = new Block();
        for (i = 0; i < numBlocks - 1; ++i) {
            blk.readFields(in);
            blocks[i] = new BlockInfo(blk, blockReplication);
        }
        if (numBlocks > 0) {
            blk.readFields(in);
            blocks[i] = new BlockInfoUnderConstruction(blk, blockReplication, HdfsConstants.BlockUCState.UNDER_CONSTRUCTION, null);
        }
        PermissionStatus perm = PermissionStatus.read((DataInput)in);
        String clientName = FSImage.readString(in);
        String clientMachine = FSImage.readString(in);
        int numLocs = in.readInt();
        DatanodeDescriptor[] locations = new DatanodeDescriptor[numLocs];
        for (i = 0; i < numLocs; ++i) {
            locations[i] = new DatanodeDescriptor();
            locations[i].readFields(in);
        }
        return new INodeFileUnderConstruction(name, blockReplication, modificationTime, preferredBlockSize, blocks, perm, clientName, clientMachine, null);
    }

    static void writeINodeUnderConstruction(DataOutputStream out, INodeFileUnderConstruction cons, String path) throws IOException {
        FSImage.writeString(path, out);
        out.writeShort(cons.getReplication());
        out.writeLong(cons.getModificationTime());
        out.writeLong(cons.getPreferredBlockSize());
        int nrBlocks = cons.getBlocks().length;
        out.writeInt(nrBlocks);
        for (int i = 0; i < nrBlocks; ++i) {
            cons.getBlocks()[i].write(out);
        }
        cons.getPermissionStatus().write((DataOutput)out);
        FSImage.writeString(cons.getClientName(), out);
        FSImage.writeString(cons.getClientMachine(), out);
        out.writeInt(0);
    }

    void rollFSImage() throws IOException {
        this.rollFSImage(true);
    }

    void rollFSImage(boolean renewCheckpointTime) throws IOException {
        if (this.ckptState != CheckpointStates.UPLOAD_DONE && (this.ckptState != CheckpointStates.ROLLED_EDITS || this.getNumStorageDirs(NameNodeDirType.IMAGE) != 0)) {
            throw new IOException("Cannot roll fsImage before rolling edits log.");
        }
        Iterator<Storage.StorageDirectory> it = this.dirIterator(NameNodeDirType.IMAGE);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            File ckpt = FSImage.getImageFile(sd, NameNodeFile.IMAGE_NEW);
            if (ckpt.exists()) continue;
            throw new IOException("Checkpoint file " + ckpt + " does not exist");
        }
        this.editLog.purgeEditLog();
        LOG.debug((Object)("rollFSImage after purgeEditLog: storageList=" + this.listStorageDirectories()));
        this.renameCheckpoint();
        this.resetVersion(renewCheckpointTime);
    }

    void renameCheckpoint() {
        ArrayList<Storage.StorageDirectory> al = null;
        Iterator<Storage.StorageDirectory> it = this.dirIterator(NameNodeDirType.IMAGE);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            File ckpt = FSImage.getImageFile(sd, NameNodeFile.IMAGE_NEW);
            File curFile = FSImage.getImageFile(sd, NameNodeFile.IMAGE);
            LOG.debug((Object)("renaming  " + ckpt.getAbsolutePath() + " to " + curFile.getAbsolutePath()));
            if (ckpt.renameTo(curFile) || curFile.delete() && ckpt.renameTo(curFile)) continue;
            LOG.warn((Object)("renaming  " + ckpt.getAbsolutePath() + " to " + curFile.getAbsolutePath() + " FAILED"));
            if (al == null) {
                al = new ArrayList<Storage.StorageDirectory>(1);
            }
            al.add(sd);
        }
        if (al != null) {
            this.processIOError(al, true);
        }
    }

    void resetVersion(boolean renewCheckpointTime) throws IOException {
        this.layoutVersion = -24;
        if (renewCheckpointTime) {
            this.checkpointTime = FSNamesystem.now();
        }
        ArrayList<Storage.StorageDirectory> al = null;
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            File imageFile;
            File editsFile;
            Storage.StorageDirectory sd = it.next();
            if (!sd.getStorageDirType().isOfType(NameNodeDirType.EDITS) && (editsFile = FSImage.getImageFile(sd, NameNodeFile.EDITS)).exists() && !editsFile.delete()) {
                throw new IOException("Cannot delete edits file " + editsFile.getCanonicalPath());
            }
            if (!sd.getStorageDirType().isOfType(NameNodeDirType.IMAGE) && (imageFile = FSImage.getImageFile(sd, NameNodeFile.IMAGE)).exists() && !imageFile.delete()) {
                throw new IOException("Cannot delete image file " + imageFile.getCanonicalPath());
            }
            try {
                sd.write();
            }
            catch (IOException e) {
                LOG.error((Object)("Cannot write file " + sd.getRoot()), (Throwable)e);
                if (al == null) {
                    al = new ArrayList<Storage.StorageDirectory>(1);
                }
                al.add(sd);
            }
        }
        if (al != null) {
            this.processIOError(al, true);
        }
        this.ckptState = CheckpointStates.START;
    }

    CheckpointSignature rollEditLog() throws IOException {
        this.getEditLog().rollEditLog();
        this.ckptState = CheckpointStates.ROLLED_EDITS;
        this.incrementCheckpointTime();
        return new CheckpointSignature(this);
    }

    void validateCheckpointUpload(CheckpointSignature sig) throws IOException {
        if (this.ckptState != CheckpointStates.ROLLED_EDITS) {
            throw new IOException("Namenode is not expecting an new image " + (Object)((Object)this.ckptState));
        }
        long modtime = this.getEditLog().getFsEditTime();
        if (sig.editsTime != modtime) {
            throw new IOException("Namenode has an edit log with timestamp of " + DATE_FORM.format(new Date(modtime)) + " but new checkpoint was created using editlog " + " with timestamp " + DATE_FORM.format(new Date(sig.editsTime)) + ". Checkpoint Aborted.");
        }
        sig.validateStorageInfo(this);
        this.ckptState = CheckpointStates.UPLOAD_START;
    }

    NamenodeCommand startCheckpoint(NamenodeRegistration bnReg, NamenodeRegistration nnReg) throws IOException {
        String msg = null;
        if (bnReg.getNamespaceID() != this.getNamespaceID()) {
            msg = "Name node " + bnReg.getAddress() + " has incompatible namespace id: " + bnReg.getNamespaceID() + " expected: " + this.getNamespaceID();
        } else if (bnReg.isRole(HdfsConstants.NamenodeRole.ACTIVE)) {
            msg = "Name node " + bnReg.getAddress() + " role " + (Object)((Object)bnReg.getRole()) + ": checkpoint is not allowed.";
        } else if (bnReg.getLayoutVersion() < this.getLayoutVersion() || bnReg.getLayoutVersion() == this.getLayoutVersion() && bnReg.getCTime() > this.getCTime() || bnReg.getLayoutVersion() == this.getLayoutVersion() && bnReg.getCTime() == this.getCTime() && bnReg.getCheckpointTime() > this.checkpointTime) {
            msg = "Name node " + bnReg.getAddress() + " has newer image layout version: LV = " + bnReg.getLayoutVersion() + " cTime = " + bnReg.getCTime() + " checkpointTime = " + bnReg.getCheckpointTime() + ". Current version: LV = " + this.getLayoutVersion() + " cTime = " + this.getCTime() + " checkpointTime = " + this.checkpointTime;
        }
        if (msg != null) {
            LOG.error((Object)msg);
            return new NamenodeCommand(50);
        }
        boolean isImgObsolete = true;
        if (bnReg.getLayoutVersion() == this.getLayoutVersion() && bnReg.getCTime() == this.getCTime() && bnReg.getCheckpointTime() == this.checkpointTime) {
            isImgObsolete = false;
        }
        boolean needToReturnImg = true;
        if (this.getNumStorageDirs(NameNodeDirType.IMAGE) == 0) {
            needToReturnImg = false;
        }
        CheckpointSignature sig = this.rollEditLog();
        this.getEditLog().logJSpoolStart(bnReg, nnReg);
        return new CheckpointCommand(sig, isImgObsolete, needToReturnImg);
    }

    void endCheckpoint(CheckpointSignature sig, HdfsConstants.NamenodeRole remoteNNRole) throws IOException {
        sig.validateStorageInfo(this);
        boolean renewCheckpointTime = remoteNNRole.equals((Object)HdfsConstants.NamenodeRole.CHECKPOINT);
        this.rollFSImage(renewCheckpointTime);
    }

    CheckpointStates getCheckpointState() {
        return this.ckptState;
    }

    void setCheckpointState(CheckpointStates cs) {
        this.ckptState = cs;
    }

    synchronized void checkpointUploadDone() {
        this.ckptState = CheckpointStates.UPLOAD_DONE;
    }

    synchronized void close() throws IOException {
        this.getEditLog().close();
        this.unlockAll();
    }

    File getFsImageName() {
        Storage.StorageDirectory sd = null;
        Iterator<Storage.StorageDirectory> it = this.dirIterator(NameNodeDirType.IMAGE);
        while (it.hasNext()) {
            sd = it.next();
            if (!sd.getRoot().canRead()) continue;
            return FSImage.getImageFile(sd, NameNodeFile.IMAGE);
        }
        return null;
    }

    synchronized void attemptRestoreRemovedStorage() {
        if (!this.restoreFailedStorage || this.removedStorageDirs.size() == 0) {
            return;
        }
        LOG.info((Object)("FSImage.attemptRestoreRemovedStorage: check removed(failed) storarge. removedStorages size = " + this.removedStorageDirs.size()));
        Iterator<Storage.StorageDirectory> it = this.removedStorageDirs.iterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            File root = sd.getRoot();
            LOG.info((Object)("currently disabled dir " + root.getAbsolutePath() + "; type=" + sd.getStorageDirType() + ";canwrite=" + root.canWrite()));
            try {
                if (!root.exists() || !root.canWrite()) continue;
                this.format(sd);
                LOG.info((Object)("restoring dir " + sd.getRoot().getAbsolutePath()));
                if (sd.getStorageDirType().isOfType(NameNodeDirType.EDITS)) {
                    File eFile = this.getEditFile(sd);
                    this.editLog.addNewEditLogStream(eFile);
                }
                this.addStorageDir(sd);
                it.remove();
            }
            catch (IOException e) {
                LOG.warn((Object)("failed to restore " + sd.getRoot().getAbsolutePath()), (Throwable)e);
            }
        }
    }

    public File getFsEditName() throws IOException {
        return this.getEditLog().getFsEditName();
    }

    File getFsTimeName() {
        Storage.StorageDirectory sd = null;
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            sd = it.next();
        }
        return FSImage.getImageFile(sd, NameNodeFile.TIME);
    }

    File[] getFsImageNameCheckpoint() {
        ArrayList<File> list = new ArrayList<File>();
        Iterator<Storage.StorageDirectory> it = this.dirIterator(NameNodeDirType.IMAGE);
        while (it.hasNext()) {
            list.add(FSImage.getImageFile(it.next(), NameNodeFile.IMAGE_NEW));
        }
        return list.toArray(new File[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void corruptPreUpgradeStorage(File rootDir) throws IOException {
        File oldImageDir = new File(rootDir, "image");
        if (!oldImageDir.exists() && !oldImageDir.mkdir()) {
            throw new IOException("Cannot create directory " + oldImageDir);
        }
        File oldImage = new File(oldImageDir, "fsimage");
        if (!oldImage.exists() && !oldImage.createNewFile()) {
            throw new IOException("Cannot create file " + oldImage);
        }
        RandomAccessFile oldFile = new RandomAccessFile(oldImage, "rws");
        try {
            this.writeCorruptedData(oldFile);
        }
        finally {
            oldFile.close();
        }
    }

    private boolean getDistributedUpgradeState() {
        FSNamesystem ns = this.getFSNamesystem();
        return ns == null ? false : ns.getDistributedUpgradeState();
    }

    private int getDistributedUpgradeVersion() {
        FSNamesystem ns = this.getFSNamesystem();
        return ns == null ? 0 : ns.getDistributedUpgradeVersion();
    }

    private void setDistributedUpgradeState(boolean uState, int uVersion) {
        this.getFSNamesystem().upgradeManager.setUpgradeState(uState, uVersion);
    }

    private void verifyDistributedUpgradeProgress(HdfsConstants.StartupOption startOpt) throws IOException {
        if (startOpt == HdfsConstants.StartupOption.ROLLBACK || startOpt == HdfsConstants.StartupOption.IMPORT) {
            return;
        }
        UpgradeManagerNamenode um = this.getFSNamesystem().upgradeManager;
        assert (um != null) : "FSNameSystem.upgradeManager is null.";
        if (startOpt != HdfsConstants.StartupOption.UPGRADE) {
            if (um.getUpgradeState()) {
                throw new IOException("\n   Previous distributed upgrade was not completed. \n   Please restart NameNode with -upgrade option.");
            }
            if (um.getDistributedUpgrades() != null) {
                throw new IOException("\n   Distributed upgrade for NameNode version " + um.getUpgradeVersion() + " to current LV " + -24 + " is required.\n   Please restart NameNode with -upgrade option.");
            }
        }
    }

    private void initializeDistributedUpgrade() throws IOException {
        UpgradeManagerNamenode um = this.getFSNamesystem().upgradeManager;
        if (!um.initializeUpgrade()) {
            return;
        }
        this.writeAll();
        NameNode.LOG.info((Object)("\n   Distributed upgrade for NameNode version " + um.getUpgradeVersion() + " to current LV " + -24 + " is initialized."));
    }

    static Collection<URI> getCheckpointDirs(Configuration conf, String defaultValue) {
        Collection dirNames = conf.getStringCollection("dfs.namenode.checkpoint.dir");
        if (dirNames.size() == 0 && defaultValue != null) {
            dirNames.add(defaultValue);
        }
        return Util.stringCollectionAsURIs(dirNames);
    }

    static Collection<URI> getCheckpointEditsDirs(Configuration conf, String defaultName) {
        Collection dirNames = conf.getStringCollection("dfs.namenode.checkpoint.edits.dir");
        if (dirNames.size() == 0 && defaultName != null) {
            dirNames.add(defaultName);
        }
        return Util.stringCollectionAsURIs(dirNames);
    }

    public static String readString(DataInputStream in) throws IOException {
        U_STR.readFields(in);
        return U_STR.toString();
    }

    static String readString_EmptyAsNull(DataInputStream in) throws IOException {
        String s = FSImage.readString(in);
        return s.isEmpty() ? null : s;
    }

    public static byte[] readBytes(DataInputStream in) throws IOException {
        U_STR.readFields(in);
        int len = U_STR.getLength();
        byte[] bytes = new byte[len];
        System.arraycopy(U_STR.getBytes(), 0, bytes, 0, len);
        return bytes;
    }

    static void writeString(String str, DataOutputStream out) throws IOException {
        U_STR.set(str);
        U_STR.write(out);
    }

    static class DatanodeImage
    implements Writable {
        DatanodeDescriptor node = new DatanodeDescriptor();

        DatanodeImage() {
        }

        public void write(DataOutput out) throws IOException {
            new DatanodeID(this.node).write(out);
            out.writeLong(this.node.getCapacity());
            out.writeLong(this.node.getRemaining());
            out.writeLong(this.node.getLastUpdate());
            out.writeInt(this.node.getXceiverCount());
        }

        public void readFields(DataInput in) throws IOException {
            DatanodeID id = new DatanodeID();
            id.readFields(in);
            long capacity = in.readLong();
            long remaining = in.readLong();
            long lastUpdate = in.readLong();
            int xceiverCount = in.readInt();
            this.node.updateRegInfo(id);
            this.node.setStorageID(id.getStorageID());
            this.node.setCapacity(capacity);
            this.node.setRemaining(remaining);
            this.node.setLastUpdate(lastUpdate);
            this.node.setXceiverCount(xceiverCount);
        }
    }

    static enum NameNodeDirType implements Storage.StorageDirType
    {
        UNDEFINED,
        IMAGE,
        EDITS,
        IMAGE_AND_EDITS;


        @Override
        public Storage.StorageDirType getStorageDirType() {
            return this;
        }

        @Override
        public boolean isOfType(Storage.StorageDirType type) {
            if (this == IMAGE_AND_EDITS && (type == IMAGE || type == EDITS)) {
                return true;
            }
            return this == type;
        }
    }

    static enum CheckpointStates {
        START,
        ROLLED_EDITS,
        UPLOAD_START,
        UPLOAD_DONE;

    }

    static enum NameNodeFile {
        IMAGE("fsimage"),
        TIME("fstime"),
        EDITS("edits"),
        IMAGE_NEW("fsimage.ckpt"),
        EDITS_NEW("edits.new");

        private String fileName = null;

        private NameNodeFile(String name) {
            this.fileName = name;
        }

        String getName() {
            return this.fileName;
        }
    }
}

