/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
public class BlockAccessToken
implements Writable {
    public static final BlockAccessToken DUMMY_TOKEN = new BlockAccessToken();
    private Text tokenID;
    private Text tokenAuthenticator;

    public BlockAccessToken() {
        this(new Text(), new Text());
    }

    public BlockAccessToken(Text tokenID, Text tokenAuthenticator) {
        this.tokenID = tokenID;
        this.tokenAuthenticator = tokenAuthenticator;
    }

    public Text getTokenID() {
        return this.tokenID;
    }

    public Text getTokenAuthenticator() {
        return this.tokenAuthenticator;
    }

    static boolean isEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlockAccessToken) {
            BlockAccessToken that = (BlockAccessToken)obj;
            return BlockAccessToken.isEqual(this.tokenID, that.tokenID) && BlockAccessToken.isEqual(this.tokenAuthenticator, that.tokenAuthenticator);
        }
        return false;
    }

    public int hashCode() {
        return this.tokenAuthenticator == null ? 0 : this.tokenAuthenticator.hashCode();
    }

    public void write(DataOutput out) throws IOException {
        this.tokenID.write(out);
        this.tokenAuthenticator.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.tokenID.readFields(in);
        this.tokenAuthenticator.readFields(in);
    }
}

