/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.apache.hadoop.ipc.ProtocolSignature;

public class ProtocolProxy<T> {
    private Class<T> protocol;
    private T proxy;
    private HashSet<Integer> serverMethods = null;

    public ProtocolProxy(Class<T> protocol, T proxy, int[] serverMethods) {
        this.protocol = protocol;
        this.proxy = proxy;
        if (serverMethods != null) {
            this.serverMethods = new HashSet(serverMethods.length);
            for (int method : serverMethods) {
                this.serverMethods.add(method);
            }
        }
    }

    public T getProxy() {
        return this.proxy;
    }

    public boolean isMethodSupported(String methodName, Class<?> ... parameterTypes) throws IOException {
        Method method;
        if (this.serverMethods == null) {
            return true;
        }
        try {
            method = this.protocol.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e);
        }
        return this.serverMethods.contains(ProtocolSignature.getFingerprint(method));
    }
}

