/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;

final class FsConfig {
    static final String FS_DEFAULT_NAME_KEY = "fs.default.name";
    static final String FS_HOME_DIR_ROOT_KEY = "fs.homeDir";
    static final String FS_REPLICATION_FACTOR_KEY = "dfs.replication";
    static final String FS_BLOCK_SIZE_KEY = "dfs.block.size";
    static final String IO_BUFFER_SIZE_KEY = "io.file.buffer.size";
    static final String FS_DEFAULT_NAME = "file:///";
    static final String FS_HOME_DIR_ROOT = "/user";
    static final short FS_DEFAULT_REPLICATION_FACTOR = 3;
    static final long FS_DEFAULT_BLOCK_SIZE = 0x2000000L;
    static final int IO_BUFFER_SIZE = 4096;

    private FsConfig() {
    }

    public static String getDefaultFsURI(Configuration conf) {
        return conf.get(FS_DEFAULT_NAME_KEY, FS_DEFAULT_NAME);
    }

    public static String getHomeDir(Configuration conf) {
        return conf.get(FS_HOME_DIR_ROOT_KEY, FS_HOME_DIR_ROOT);
    }

    public static short getDefaultReplicationFactor(Configuration conf) {
        return (short)conf.getInt(FS_REPLICATION_FACTOR_KEY, 3);
    }

    public static long getDefaultBlockSize(Configuration conf) {
        return conf.getLong(FS_BLOCK_SIZE_KEY, 0x2000000L);
    }

    public static int getDefaultIOBuffersize(Configuration conf) {
        return conf.getInt(IO_BUFFER_SIZE_KEY, 4096);
    }

    public static Class<?> getImplClass(URI uri, Configuration conf) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("No scheme");
        }
        return conf.getClass("fs." + uri.getScheme() + ".impl", null);
    }

    public static void setDefaultFS(Configuration conf, String uri) {
        conf.set(FS_DEFAULT_NAME_KEY, uri);
    }

    public static void setHomeDir(Configuration conf, String path) {
        conf.set(FS_HOME_DIR_ROOT_KEY, path);
    }

    public static void setDefaultReplicationFactor(Configuration conf, short rf) {
        conf.setInt(FS_REPLICATION_FACTOR_KEY, rf);
    }

    public static void setDefaultBlockSize(Configuration conf, long bs) {
        conf.setLong(FS_BLOCK_SIZE_KEY, bs);
    }

    public static void setDefaultIOBuffersize(Configuration conf, int bs) {
        conf.setInt(IO_BUFFER_SIZE_KEY, bs);
    }
}

