/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FloatWritable
implements WritableComparable {
    private float value;

    public FloatWritable() {
    }

    public FloatWritable(float value) {
        this.set(value);
    }

    public void set(float value) {
        this.value = value;
    }

    public float get() {
        return this.value;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readFloat();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeFloat(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof FloatWritable)) {
            return false;
        }
        FloatWritable other = (FloatWritable)o;
        return this.value == other.value;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    @Override
    public int compareTo(Object o) {
        float thisValue = this.value;
        float thatValue = ((FloatWritable)o).value;
        return thisValue < thatValue ? -1 : (thisValue == thatValue ? 0 : 1);
    }

    public String toString() {
        return Float.toString(this.value);
    }

    static {
        WritableComparator.define(FloatWritable.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(FloatWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            float thatValue;
            float thisValue = Comparator.readFloat(b1, s1);
            return thisValue < (thatValue = Comparator.readFloat(b2, s2)) ? -1 : (thisValue == thatValue ? 0 : 1);
        }
    }
}

