/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.status.StatusLogger;

public class LogManager {
    public static final String ROOT_LOGGER_NAME = "";
    private static final String LOGGER_RESOURCE = "META-INF/log4j-provider.xml";
    private static final String LOGGER_CONTEXT_FACTORY = "LoggerContextFactory";
    private static final String API_VERSION = "Log4jAPIVersion";
    private static final String[] COMPATIBLE_API_VERSIONS = new String[]{"1.99.0"};
    private static LoggerContextFactory factory;
    private static Logger logger;

    protected LogManager() {
    }

    public static LoggerContextFactory getFactory() {
        return factory;
    }

    public static Logger getLogger(String name) {
        return factory.getContext(LogManager.class.getName(), null, false).getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        return factory.getContext(LogManager.class.getName(), null, false).getLogger(clazz.getName());
    }

    protected static Logger getLogger(String fqcn, String name) {
        return factory.getContext(fqcn, null, false).getLogger(name);
    }

    public static LoggerContext getContext() {
        return factory.getContext(LogManager.class.getName(), null, true);
    }

    public static LoggerContext getContext(boolean currentContext) {
        return factory.getContext(LogManager.class.getName(), null, currentContext);
    }

    public static LoggerContext getContext(ClassLoader loader, boolean currentContext) {
        return factory.getContext(LogManager.class.getName(), loader, currentContext);
    }

    protected static LoggerContext getContext(String fqcn, boolean currentContext) {
        return factory.getContext(fqcn, null, currentContext);
    }

    protected static LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext) {
        return factory.getContext(fqcn, loader, currentContext);
    }

    private static ClassLoader findClassLoader() {
        ClassLoader cl = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        if (cl == null || cl.getParent() != null) {
            // empty if block
        }
        if (cl == null) {
            cl = LogManager.class.getClassLoader();
        }
        return cl;
    }

    private static boolean validVersion(String version) {
        for (String v : COMPATIBLE_API_VERSIONS) {
            if (!version.startsWith(v)) continue;
            return true;
        }
        return false;
    }

    static {
        logger = StatusLogger.getLogger();
        ClassLoader cl = LogManager.findClassLoader();
        ArrayList<LoggerContextFactory> factories = new ArrayList<LoggerContextFactory>();
        Enumeration<URL> enumResources = null;
        try {
            enumResources = cl.getResources(LOGGER_RESOURCE);
        }
        catch (IOException e) {
            logger.fatal("Unable to locate META-INF/log4j-provider.xml", (Throwable)e);
        }
        if (enumResources != null) {
            while (enumResources.hasMoreElements()) {
                String className;
                Properties props = new Properties();
                URL url = enumResources.nextElement();
                try {
                    props.loadFromXML(url.openStream());
                }
                catch (IOException ioe) {
                    logger.error("Unable to read " + url.toString(), (Throwable)ioe);
                }
                if (!LogManager.validVersion(props.getProperty(API_VERSION)) || (className = props.getProperty(LOGGER_CONTEXT_FACTORY)) == null) continue;
                try {
                    Class<?> clazz = cl.loadClass(className);
                    if (LoggerContextFactory.class.isAssignableFrom(clazz)) {
                        factories.add((LoggerContextFactory)clazz.newInstance());
                        continue;
                    }
                    logger.error(className + " does not implement " + LoggerContextFactory.class.getName());
                }
                catch (ClassNotFoundException cnfe) {
                    logger.error("Unable to locate class " + className + " specified in " + url.toString(), (Throwable)cnfe);
                }
                catch (IllegalAccessException iae) {
                    logger.error("Unable to create class " + className + " specified in " + url.toString(), (Throwable)iae);
                }
                catch (Exception e) {
                    logger.error("Unable to create class " + className + " specified in " + url.toString(), (Throwable)e);
                    e.printStackTrace();
                }
            }
            if (factories.size() != 1) {
                logger.fatal("Unable to locate a logging implementation");
            } else {
                factory = (LoggerContextFactory)factories.get(0);
            }
        } else {
            logger.fatal("Unable to locate a logging implementation");
        }
    }
}

