/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;
import org.apache.karaf.jaas.modules.RolePrincipal;
import org.apache.karaf.jaas.modules.UserPrincipal;
import org.apache.karaf.jaas.modules.jdbc.JDBCUtils;
import org.apache.karaf.jaas.modules.properties.PropertiesLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCLoginModule
extends AbstractKarafLoginModule {
    private final Logger logger = LoggerFactory.getLogger(PropertiesLoginModule.class);
    public static final String PASSWORD_QUERY = "query.password";
    public static final String ROLE_QUERY = "query.role";
    public static final String INSERT_USER_STATEMENT = "insert.user";
    public static final String INSERT_ROLE_STATEMENT = "insert.role";
    public static final String DELETE_ROLE_STATEMENT = "delete.role";
    public static final String DELETE_ROLES_STATEMENT = "delete.roles";
    public static final String DELETE_USER_STATEMENT = "delete.user";
    private String datasourceURL;
    protected String passwordQuery = "SELECT PASSWORD FROM USERS WHERE USERNAME=?";
    protected String roleQuery = "SELECT ROLE FROM ROLES WHERE USERNAME=?";

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, options);
        this.datasourceURL = (String)options.get("datasource");
        this.passwordQuery = (String)options.get(PASSWORD_QUERY);
        this.roleQuery = (String)options.get(ROLE_QUERY);
        if (this.datasourceURL == null || this.datasourceURL.trim().length() == 0) {
            this.logger.error("No datasource was specified ");
        } else if (!this.datasourceURL.startsWith("jndi:") && !this.datasourceURL.startsWith("osgi:")) {
            this.logger.error("Invalid datasource lookup protocol");
        }
    }

    @Override
    public boolean login() throws LoginException {
        Connection connection = null;
        Statement passwordStatement = null;
        Statement roleStatement = null;
        ResultSet passwordResultSet = null;
        ResultSet roleResultSet = null;
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        String password = new String(tmpPassword);
        this.principals = new HashSet();
        try {
            Object credentialsDatasource = JDBCUtils.createDatasource(this.bundleContext, this.datasourceURL);
            if (credentialsDatasource == null) {
                throw new LoginException("Cannot obtain data source:" + this.datasourceURL);
            }
            if (credentialsDatasource instanceof DataSource) {
                connection = ((DataSource)credentialsDatasource).getConnection();
            } else if (credentialsDatasource instanceof XADataSource) {
                connection = ((XADataSource)credentialsDatasource).getXAConnection().getConnection();
            } else {
                throw new LoginException("Unknow dataSource type " + credentialsDatasource.getClass());
            }
            passwordStatement = connection.prepareStatement(this.passwordQuery);
            passwordStatement.setString(1, this.user);
            passwordResultSet = passwordStatement.executeQuery();
            if (!passwordResultSet.next()) {
                if (!this.detailedLoginExcepion) {
                    throw new LoginException("login failed");
                }
                throw new LoginException("User " + this.user + " does not exist");
            }
            String storedPassword = passwordResultSet.getString(1);
            if (!this.checkPassword(password, storedPassword)) {
                if (!this.detailedLoginExcepion) {
                    throw new LoginException("login failed");
                }
                throw new LoginException("Password for " + this.user + " does not match");
            }
            this.principals.add(new UserPrincipal(this.user));
            roleStatement = connection.prepareStatement(this.roleQuery);
            roleStatement.setString(1, this.user);
            roleResultSet = roleStatement.executeQuery();
            while (roleResultSet.next()) {
                String role = roleResultSet.getString(1);
                this.principals.add(new RolePrincipal(role));
            }
        }
        catch (Exception ex) {
            throw new LoginException("Error has occured while retrieving credentials from database:" + ex.getMessage());
        }
        finally {
            try {
                if (passwordResultSet != null) {
                    passwordResultSet.close();
                }
                if (passwordStatement != null) {
                    passwordStatement.close();
                }
                if (roleResultSet != null) {
                    roleResultSet.close();
                }
                if (roleStatement != null) {
                    roleStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException ex) {
                this.logger.warn("Failed to clearly close connection to the database:", (Throwable)ex);
            }
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        if (this.debug) {
            this.logger.debug("logout");
        }
        return true;
    }
}

