/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;

@NotThreadSafe
public class StringEntity
extends AbstractHttpEntity
implements Cloneable {
    protected final byte[] content;

    public static StringEntity create(String string, ContentType contentType) {
        try {
            return new StringEntity(string, contentType);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    public static StringEntity create(String string, String charset) {
        return StringEntity.create(string, ContentType.create("text/plain", charset));
    }

    public static StringEntity create(String string) {
        return StringEntity.create(string, ContentType.DEFAULT_TEXT);
    }

    public StringEntity(String string, ContentType contentType) throws UnsupportedEncodingException {
        String charset;
        if (string == null) {
            throw new IllegalArgumentException("Source string may not be null");
        }
        String string2 = charset = contentType != null ? contentType.getCharset() : null;
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        this.content = string.getBytes(charset);
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    @Deprecated
    public StringEntity(String string, String mimeType, String charset) throws UnsupportedEncodingException {
        if (string == null) {
            throw new IllegalArgumentException("Source string may not be null");
        }
        if (mimeType == null) {
            mimeType = "text/plain";
        }
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        this.content = string.getBytes(charset);
        this.setContentType(mimeType + "; charset=" + charset);
    }

    public StringEntity(String string, String charset) throws UnsupportedEncodingException {
        this(string, ContentType.create("text/plain", charset));
    }

    public StringEntity(String string) throws UnsupportedEncodingException {
        this(string, ContentType.DEFAULT_TEXT);
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.content.length;
    }

    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public void writeTo(OutputStream outstream) throws IOException {
        if (outstream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        outstream.write(this.content);
        outstream.flush();
    }

    public boolean isStreaming() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

