/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.ProducingNHttpEntity;

class NHttpEntityWrapper
extends HttpEntityWrapper
implements ProducingNHttpEntity {
    private final ByteBuffer buffer = ByteBuffer.allocate(4096);
    private ReadableByteChannel channel;

    public NHttpEntityWrapper(HttpEntity httpEntity) {
        super(httpEntity);
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Does not support blocking methods");
    }

    public boolean isStreaming() {
        return true;
    }

    public void writeTo(OutputStream out) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Does not support blocking methods");
    }

    @Deprecated
    public void consumeContent() throws IOException {
        this.finish();
    }

    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        if (this.channel == null) {
            this.channel = Channels.newChannel(this.wrappedEntity.getContent());
        }
        int i = this.channel.read(this.buffer);
        this.buffer.flip();
        encoder.write(this.buffer);
        boolean buffering = this.buffer.hasRemaining();
        this.buffer.compact();
        if (i == -1 && !buffering) {
            encoder.complete();
            this.channel.close();
        }
    }

    public void finish() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }
}

