/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.BufferingNHttpEntity;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class BasicAsyncResponseConsumer
extends AbstractAsyncResponseConsumer<HttpResponse> {
    private final ByteBufferAllocator allocator;
    private volatile HttpResponse response;
    private volatile ConsumingNHttpEntity consumer;

    public BasicAsyncResponseConsumer(ByteBufferAllocator allocator) {
        if (allocator == null) {
            throw new IllegalArgumentException("Byte buffer allocator is null");
        }
        this.allocator = allocator;
    }

    public BasicAsyncResponseConsumer() {
        this(new HeapByteBufferAllocator());
    }

    @Override
    protected void onResponseReceived(HttpResponse response) {
        this.response = response;
        HttpEntity entity = this.response.getEntity();
        if (entity != null) {
            this.consumer = new BufferingNHttpEntity(entity, this.allocator);
            this.response.setEntity((HttpEntity)this.consumer);
        }
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        if (this.consumer == null) {
            throw new IllegalArgumentException("Content consumer is null");
        }
        this.consumer.consumeContent(decoder, ioctrl);
    }

    @Override
    protected void releaseResources() {
        this.response = null;
        this.consumer = null;
    }

    @Override
    protected HttpResponse buildResult(HttpContext context) {
        return this.response;
    }
}

