/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.BufferingNHttpEntity;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.protocol.AbstractAsyncRequestConsumer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class BasicAsyncRequestConsumer
extends AbstractAsyncRequestConsumer<HttpRequest> {
    private final ByteBufferAllocator allocator;
    private volatile HttpRequest request;
    private volatile ConsumingNHttpEntity consumer;

    public BasicAsyncRequestConsumer(ByteBufferAllocator allocator) {
        if (allocator == null) {
            throw new IllegalArgumentException("Byte buffer allocator is null");
        }
        this.allocator = allocator;
    }

    public BasicAsyncRequestConsumer() {
        this(new HeapByteBufferAllocator());
    }

    @Override
    protected void onRequestReceived(HttpRequest request) {
        HttpEntity entity;
        this.request = request;
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)this.request).getEntity()) != null) {
            this.consumer = new BufferingNHttpEntity(entity, this.allocator);
            ((HttpEntityEnclosingRequest)this.request).setEntity((HttpEntity)this.consumer);
        }
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        if (this.consumer == null) {
            throw new IllegalArgumentException("Content consumer is null");
        }
        this.consumer.consumeContent(decoder, ioctrl);
    }

    @Override
    protected void releaseResources() {
        this.request = null;
        this.consumer = null;
    }

    @Override
    protected HttpRequest buildResult(HttpContext context) {
        return this.request;
    }
}

