/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.ssl;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.apache.http.annotation.Immutable;
import org.apache.http.impl.nio.DefaultClientIOEventDispatch;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpClientIOTarget;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLIOSession;
import org.apache.http.nio.reactor.ssl.SSLMode;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

@Deprecated
@Immutable
public class SSLClientIOEventDispatch
extends DefaultClientIOEventDispatch {
    private final SSLContext sslcontext;
    private final SSLSetupHandler sslHandler;

    public SSLClientIOEventDispatch(NHttpClientHandler handler, SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        super(handler, params);
        if (sslcontext == null) {
            throw new IllegalArgumentException("SSL context may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.sslcontext = sslcontext;
        this.sslHandler = sslHandler;
    }

    public SSLClientIOEventDispatch(NHttpClientHandler handler, SSLContext sslcontext, HttpParams params) {
        this(handler, sslcontext, null, params);
    }

    protected SSLIOSession createSSLIOSession(IOSession session, SSLContext sslcontext, SSLSetupHandler sslHandler) {
        return new SSLIOSession(session, SSLMode.CLIENT, sslcontext, sslHandler);
    }

    protected NHttpClientIOTarget createSSLConnection(SSLIOSession ssliosession) {
        return super.createConnection(ssliosession);
    }

    protected NHttpClientIOTarget createConnection(IOSession session) {
        SSLIOSession ssliosession = this.createSSLIOSession(session, this.sslcontext, this.sslHandler);
        session.setAttribute("http.session.ssl", ssliosession);
        NHttpClientIOTarget conn = this.createSSLConnection(ssliosession);
        try {
            ssliosession.initialize();
        }
        catch (SSLException ex) {
            this.handler.exception((NHttpClientConnection)conn, ex);
            ssliosession.shutdown();
        }
        return conn;
    }

    public void onConnected(NHttpClientIOTarget conn) {
        int timeout = HttpConnectionParams.getSoTimeout((HttpParams)this.params);
        conn.setSocketTimeout(timeout);
        Object attachment = conn.getContext().getAttribute("http.session.attachment");
        this.handler.connected(conn, attachment);
    }
}

