/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio;

import javax.net.ssl.SSLContext;
import org.apache.http.HttpResponseFactory;
import org.apache.http.annotation.Immutable;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.nio.NHttpClientIOTarget;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLIOSession;
import org.apache.http.nio.reactor.ssl.SSLMode;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class SSLNHttpClientConnectionFactory
implements NHttpConnectionFactory<NHttpClientIOTarget> {
    private final HttpResponseFactory responseFactory;
    private final ByteBufferAllocator allocator;
    private final SSLContext sslcontext;
    private final SSLSetupHandler sslHandler;
    private final HttpParams params;

    public SSLNHttpClientConnectionFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        if (responseFactory == null) {
            throw new IllegalArgumentException("HTTP response factory may not be null");
        }
        if (allocator == null) {
            throw new IllegalArgumentException("Byte buffer allocator may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.sslcontext = sslcontext;
        this.sslHandler = sslHandler;
        this.responseFactory = responseFactory;
        this.allocator = allocator;
        this.params = params;
    }

    public SSLNHttpClientConnectionFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        this(sslcontext, sslHandler, (HttpResponseFactory)new DefaultHttpResponseFactory(), new HeapByteBufferAllocator(), params);
    }

    public SSLNHttpClientConnectionFactory(HttpParams params) {
        this(null, null, params);
    }

    private SSLContext getDefaultSSLContext() {
        SSLContext sslcontext;
        try {
            sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, null, null);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failure initializing default SSL context", ex);
        }
        return sslcontext;
    }

    protected NHttpClientIOTarget createConnection(IOSession session, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        return new DefaultNHttpClientConnection(session, responseFactory, allocator, params);
    }

    @Override
    public NHttpClientIOTarget createConnection(IOSession session) {
        SSLContext sslcontext = this.sslcontext != null ? this.sslcontext : this.getDefaultSSLContext();
        SSLIOSession ssliosession = new SSLIOSession(session, SSLMode.CLIENT, sslcontext, this.sslHandler);
        session.setAttribute("http.session.ssl", ssliosession);
        NHttpClientIOTarget conn = this.createConnection(ssliosession, this.responseFactory, this.allocator, this.params);
        int timeout = HttpConnectionParams.getSoTimeout((HttpParams)this.params);
        conn.setSocketTimeout(timeout);
        return conn;
    }
}

