/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.apache.http.annotation.Immutable;
import org.apache.http.impl.nio.AbstractIODispatch;
import org.apache.http.impl.nio.DefaultNHttpClientConnectionFactory;
import org.apache.http.impl.nio.SSLNHttpClientConnectionFactory;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpClientIOTarget;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class DefaultClientIODispatch
extends AbstractIODispatch<NHttpClientIOTarget> {
    private final NHttpClientHandler handler;
    private final NHttpConnectionFactory<NHttpClientIOTarget> connFactory;

    public DefaultClientIODispatch(NHttpClientHandler handler, NHttpConnectionFactory<NHttpClientIOTarget> connFactory) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP client handler may not be null");
        }
        if (connFactory == null) {
            throw new IllegalArgumentException("HTTP client connection factory may not null");
        }
        this.handler = handler;
        this.connFactory = connFactory;
    }

    public DefaultClientIODispatch(NHttpClientHandler handler, HttpParams params) {
        this(handler, new DefaultNHttpClientConnectionFactory(params));
    }

    public DefaultClientIODispatch(NHttpClientHandler handler, SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        this(handler, new SSLNHttpClientConnectionFactory(sslcontext, sslHandler, params));
    }

    public DefaultClientIODispatch(NHttpClientHandler handler, SSLContext sslcontext, HttpParams params) {
        this(handler, sslcontext, null, params);
    }

    @Override
    protected NHttpClientIOTarget createConnection(IOSession session) {
        return this.connFactory.createConnection(session);
    }

    @Override
    protected void onConnected(NHttpClientIOTarget conn) {
        Object attachment = conn.getContext().getAttribute("http.session.attachment");
        this.handler.connected(conn, attachment);
    }

    @Override
    protected void onClosed(NHttpClientIOTarget conn) {
        this.handler.closed(conn);
    }

    @Override
    protected void onException(NHttpClientIOTarget conn, IOException ex) {
        this.handler.exception((NHttpClientConnection)conn, ex);
    }

    @Override
    protected void onInputReady(NHttpClientIOTarget conn) {
        conn.consumeInput(this.handler);
    }

    @Override
    protected void onOutputReady(NHttpClientIOTarget conn) {
        conn.produceOutput(this.handler);
    }

    @Override
    protected void onTimeout(NHttpClientIOTarget conn) {
        this.handler.timeout(conn);
    }
}

