/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.entity.DeflateDecompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.protocol.HttpContext;

@Immutable
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HeaderElement[] codecs;
        HeaderElement[] arr$;
        int len$;
        int i$;
        Header ceheader;
        HttpEntity entity = response.getEntity();
        if (entity != null && (ceheader = entity.getContentEncoding()) != null && (i$ = 0) < (len$ = (arr$ = (codecs = ceheader.getElements())).length)) {
            HeaderElement codec = arr$[i$];
            if ("gzip".equalsIgnoreCase(codec.getName())) {
                response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                return;
            }
            if ("deflate".equalsIgnoreCase(codec.getName())) {
                response.setEntity((HttpEntity)new DeflateDecompressingEntity(response.getEntity()));
                return;
            }
            if ("identity".equalsIgnoreCase(codec.getName())) {
                return;
            }
            throw new HttpException("Unsupported Content-Coding: " + codec.getName());
        }
    }
}

