/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class ClientNamenodeProtocolServerSideTranslatorPB
implements ClientNamenodeProtocolPB {
    private final ClientProtocol server;
    private static final ClientNamenodeProtocolProtos.CreateResponseProto VOID_CREATE_RESPONSE = ClientNamenodeProtocolProtos.CreateResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.AppendResponseProto VOID_APPEND_RESPONSE = ClientNamenodeProtocolProtos.AppendResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.SetPermissionResponseProto VOID_SET_PERM_RESPONSE = ClientNamenodeProtocolProtos.SetPermissionResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.SetOwnerResponseProto VOID_SET_OWNER_RESPONSE = ClientNamenodeProtocolProtos.SetOwnerResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.AbandonBlockResponseProto VOID_ADD_BLOCK_RESPONSE = ClientNamenodeProtocolProtos.AbandonBlockResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.ReportBadBlocksResponseProto VOID_REP_BAD_BLOCK_RESPONSE = ClientNamenodeProtocolProtos.ReportBadBlocksResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.ConcatResponseProto VOID_CONCAT_RESPONSE = ClientNamenodeProtocolProtos.ConcatResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.Rename2ResponseProto VOID_RENAME2_RESPONSE = ClientNamenodeProtocolProtos.Rename2ResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.GetListingResponseProto VOID_GETLISTING_RESPONSE = ClientNamenodeProtocolProtos.GetListingResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.RenewLeaseResponseProto VOID_RENEWLEASE_RESPONSE = ClientNamenodeProtocolProtos.RenewLeaseResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.SaveNamespaceResponseProto VOID_SAVENAMESPACE_RESPONSE = ClientNamenodeProtocolProtos.SaveNamespaceResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.RefreshNodesResponseProto VOID_REFRESHNODES_RESPONSE = ClientNamenodeProtocolProtos.RefreshNodesResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.FinalizeUpgradeResponseProto VOID_FINALIZEUPGRADE_RESPONSE = ClientNamenodeProtocolProtos.FinalizeUpgradeResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.MetaSaveResponseProto VOID_METASAVE_RESPONSE = ClientNamenodeProtocolProtos.MetaSaveResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.GetFileInfoResponseProto VOID_GETFILEINFO_RESPONSE = ClientNamenodeProtocolProtos.GetFileInfoResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.GetFileLinkInfoResponseProto VOID_GETFILELINKINFO_RESPONSE = ClientNamenodeProtocolProtos.GetFileLinkInfoResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.SetQuotaResponseProto VOID_SETQUOTA_RESPONSE = ClientNamenodeProtocolProtos.SetQuotaResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.FsyncResponseProto VOID_FSYNC_RESPONSE = ClientNamenodeProtocolProtos.FsyncResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.SetTimesResponseProto VOID_SETTIMES_RESPONSE = ClientNamenodeProtocolProtos.SetTimesResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.CreateSymlinkResponseProto VOID_CREATESYMLINK_RESPONSE = ClientNamenodeProtocolProtos.CreateSymlinkResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.UpdatePipelineResponseProto VOID_UPDATEPIPELINE_RESPONSE = ClientNamenodeProtocolProtos.UpdatePipelineResponseProto.newBuilder().build();
    private static final SecurityProtos.CancelDelegationTokenResponseProto VOID_CANCELDELEGATIONTOKEN_RESPONSE = SecurityProtos.CancelDelegationTokenResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.SetBalancerBandwidthResponseProto VOID_SETBALANCERBANDWIDTH_RESPONSE = ClientNamenodeProtocolProtos.SetBalancerBandwidthResponseProto.newBuilder().build();

    public ClientNamenodeProtocolServerSideTranslatorPB(ClientProtocol server) throws IOException {
        this.server = server;
    }

    @Override
    public ClientNamenodeProtocolProtos.GetBlockLocationsResponseProto getBlockLocations(RpcController controller, ClientNamenodeProtocolProtos.GetBlockLocationsRequestProto req) throws ServiceException {
        try {
            LocatedBlocks b = this.server.getBlockLocations(req.getSrc(), req.getOffset(), req.getLength());
            ClientNamenodeProtocolProtos.GetBlockLocationsResponseProto.Builder builder = ClientNamenodeProtocolProtos.GetBlockLocationsResponseProto.newBuilder();
            if (b != null) {
                builder.setLocations(PBHelper.convert(b)).build();
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.GetServerDefaultsResponseProto getServerDefaults(RpcController controller, ClientNamenodeProtocolProtos.GetServerDefaultsRequestProto req) throws ServiceException {
        try {
            FsServerDefaults result = this.server.getServerDefaults();
            return ClientNamenodeProtocolProtos.GetServerDefaultsResponseProto.newBuilder().setServerDefaults(PBHelper.convert(result)).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.CreateResponseProto create(RpcController controller, ClientNamenodeProtocolProtos.CreateRequestProto req) throws ServiceException {
        try {
            this.server.create(req.getSrc(), PBHelper.convert(req.getMasked()), req.getClientName(), PBHelper.convert(req.getCreateFlag()), req.getCreateParent(), (short)req.getReplication(), req.getBlockSize());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_CREATE_RESPONSE;
    }

    @Override
    public ClientNamenodeProtocolProtos.AppendResponseProto append(RpcController controller, ClientNamenodeProtocolProtos.AppendRequestProto req) throws ServiceException {
        try {
            LocatedBlock result = this.server.append(req.getSrc(), req.getClientName());
            if (result != null) {
                return ClientNamenodeProtocolProtos.AppendResponseProto.newBuilder().setBlock(PBHelper.convert(result)).build();
            }
            return VOID_APPEND_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.SetReplicationResponseProto setReplication(RpcController controller, ClientNamenodeProtocolProtos.SetReplicationRequestProto req) throws ServiceException {
        try {
            boolean result = this.server.setReplication(req.getSrc(), (short)req.getReplication());
            return ClientNamenodeProtocolProtos.SetReplicationResponseProto.newBuilder().setResult(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.SetPermissionResponseProto setPermission(RpcController controller, ClientNamenodeProtocolProtos.SetPermissionRequestProto req) throws ServiceException {
        try {
            this.server.setPermission(req.getSrc(), PBHelper.convert(req.getPermission()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_SET_PERM_RESPONSE;
    }

    @Override
    public ClientNamenodeProtocolProtos.SetOwnerResponseProto setOwner(RpcController controller, ClientNamenodeProtocolProtos.SetOwnerRequestProto req) throws ServiceException {
        try {
            this.server.setOwner(req.getSrc(), req.hasUsername() ? req.getUsername() : null, req.hasGroupname() ? req.getGroupname() : null);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_SET_OWNER_RESPONSE;
    }

    @Override
    public ClientNamenodeProtocolProtos.AbandonBlockResponseProto abandonBlock(RpcController controller, ClientNamenodeProtocolProtos.AbandonBlockRequestProto req) throws ServiceException {
        try {
            this.server.abandonBlock(PBHelper.convert(req.getB()), req.getSrc(), req.getHolder());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_ADD_BLOCK_RESPONSE;
    }

    @Override
    public ClientNamenodeProtocolProtos.AddBlockResponseProto addBlock(RpcController controller, ClientNamenodeProtocolProtos.AddBlockRequestProto req) throws ServiceException {
        try {
            List<HdfsProtos.DatanodeInfoProto> excl = req.getExcludeNodesList();
            LocatedBlock result = this.server.addBlock(req.getSrc(), req.getClientName(), req.hasPrevious() ? PBHelper.convert(req.getPrevious()) : null, excl == null || excl.size() == 0 ? null : PBHelper.convert(excl.toArray(new HdfsProtos.DatanodeInfoProto[excl.size()])));
            return ClientNamenodeProtocolProtos.AddBlockResponseProto.newBuilder().setBlock(PBHelper.convert(result)).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.GetAdditionalDatanodeResponseProto getAdditionalDatanode(RpcController controller, ClientNamenodeProtocolProtos.GetAdditionalDatanodeRequestProto req) throws ServiceException {
        try {
            List<HdfsProtos.DatanodeInfoProto> existingList = req.getExistingsList();
            List<HdfsProtos.DatanodeInfoProto> excludesList = req.getExcludesList();
            LocatedBlock result = this.server.getAdditionalDatanode(req.getSrc(), PBHelper.convert(req.getBlk()), PBHelper.convert(existingList.toArray(new HdfsProtos.DatanodeInfoProto[existingList.size()])), PBHelper.convert(excludesList.toArray(new HdfsProtos.DatanodeInfoProto[excludesList.size()])), req.getNumAdditionalNodes(), req.getClientName());
            return ClientNamenodeProtocolProtos.GetAdditionalDatanodeResponseProto.newBuilder().setBlock(PBHelper.convert(result)).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.CompleteResponseProto complete(RpcController controller, ClientNamenodeProtocolProtos.CompleteRequestProto req) throws ServiceException {
        try {
            boolean result = this.server.complete(req.getSrc(), req.getClientName(), req.hasLast() ? PBHelper.convert(req.getLast()) : null);
            return ClientNamenodeProtocolProtos.CompleteResponseProto.newBuilder().setResult(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.ReportBadBlocksResponseProto reportBadBlocks(RpcController controller, ClientNamenodeProtocolProtos.ReportBadBlocksRequestProto req) throws ServiceException {
        try {
            List<HdfsProtos.LocatedBlockProto> bl = req.getBlocksList();
            this.server.reportBadBlocks(PBHelper.convertLocatedBlock(bl.toArray(new HdfsProtos.LocatedBlockProto[bl.size()])));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_REP_BAD_BLOCK_RESPONSE;
    }

    @Override
    public ClientNamenodeProtocolProtos.ConcatResponseProto concat(RpcController controller, ClientNamenodeProtocolProtos.ConcatRequestProto req) throws ServiceException {
        try {
            List<String> srcs = req.getSrcsList();
            this.server.concat(req.getTrg(), srcs.toArray(new String[srcs.size()]));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_CONCAT_RESPONSE;
    }

    @Override
    public ClientNamenodeProtocolProtos.RenameResponseProto rename(RpcController controller, ClientNamenodeProtocolProtos.RenameRequestProto req) throws ServiceException {
        try {
            boolean result = this.server.rename(req.getSrc(), req.getDst());
            return ClientNamenodeProtocolProtos.RenameResponseProto.newBuilder().setResult(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.Rename2ResponseProto rename2(RpcController controller, ClientNamenodeProtocolProtos.Rename2RequestProto req) throws ServiceException {
        try {
            this.server.rename2(req.getSrc(), req.getDst(), req.getOverwriteDest() ? Options.Rename.OVERWRITE : Options.Rename.NONE);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_RENAME2_RESPONSE;
    }

    @Override
    public ClientNamenodeProtocolProtos.DeleteResponseProto delete(RpcController controller, ClientNamenodeProtocolProtos.DeleteRequestProto req) throws ServiceException {
        try {
            boolean result = this.server.delete(req.getSrc(), req.getRecursive());
            return ClientNamenodeProtocolProtos.DeleteResponseProto.newBuilder().setResult(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.MkdirsResponseProto mkdirs(RpcController controller, ClientNamenodeProtocolProtos.MkdirsRequestProto req) throws ServiceException {
        try {
            boolean result = this.server.mkdirs(req.getSrc(), PBHelper.convert(req.getMasked()), req.getCreateParent());
            return ClientNamenodeProtocolProtos.MkdirsResponseProto.newBuilder().setResult(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.GetListingResponseProto getListing(RpcController controller, ClientNamenodeProtocolProtos.GetListingRequestProto req) throws ServiceException {
        try {
            DirectoryListing result = this.server.getListing(req.getSrc(), req.getStartAfter().toByteArray(), req.getNeedLocation());
            if (result != null) {
                return ClientNamenodeProtocolProtos.GetListingResponseProto.newBuilder().setDirList(PBHelper.convert(result)).build();
            }
            return VOID_GETLISTING_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.RenewLeaseResponseProto renewLease(RpcController controller, ClientNamenodeProtocolProtos.RenewLeaseRequestProto req) throws ServiceException {
        try {
            this.server.renewLease(req.getClientName());
            return VOID_RENEWLEASE_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.RecoverLeaseResponseProto recoverLease(RpcController controller, ClientNamenodeProtocolProtos.RecoverLeaseRequestProto req) throws ServiceException {
        try {
            boolean result = this.server.recoverLease(req.getSrc(), req.getClientName());
            return ClientNamenodeProtocolProtos.RecoverLeaseResponseProto.newBuilder().setResult(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.RestoreFailedStorageResponseProto restoreFailedStorage(RpcController controller, ClientNamenodeProtocolProtos.RestoreFailedStorageRequestProto req) throws ServiceException {
        try {
            boolean result = this.server.restoreFailedStorage(req.getArg());
            return ClientNamenodeProtocolProtos.RestoreFailedStorageResponseProto.newBuilder().setResult(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.GetFsStatsResponseProto getFsStats(RpcController controller, ClientNamenodeProtocolProtos.GetFsStatusRequestProto req) throws ServiceException {
        try {
            return PBHelper.convert(this.server.getStats());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.GetDatanodeReportResponseProto getDatanodeReport(RpcController controller, ClientNamenodeProtocolProtos.GetDatanodeReportRequestProto req) throws ServiceException {
        try {
            List<? extends HdfsProtos.DatanodeInfoProto> result = PBHelper.convert(this.server.getDatanodeReport(PBHelper.convert(req.getType())));
            return ClientNamenodeProtocolProtos.GetDatanodeReportResponseProto.newBuilder().addAllDi(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.GetPreferredBlockSizeResponseProto getPreferredBlockSize(RpcController controller, ClientNamenodeProtocolProtos.GetPreferredBlockSizeRequestProto req) throws ServiceException {
        try {
            long result = this.server.getPreferredBlockSize(req.getFilename());
            return ClientNamenodeProtocolProtos.GetPreferredBlockSizeResponseProto.newBuilder().setBsize(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.SetSafeModeResponseProto setSafeMode(RpcController controller, ClientNamenodeProtocolProtos.SetSafeModeRequestProto req) throws ServiceException {
        try {
            boolean result = this.server.setSafeMode(PBHelper.convert(req.getAction()), req.getChecked());
            return ClientNamenodeProtocolProtos.SetSafeModeResponseProto.newBuilder().setResult(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.SaveNamespaceResponseProto saveNamespace(RpcController controller, ClientNamenodeProtocolProtos.SaveNamespaceRequestProto req) throws ServiceException {
        try {
            this.server.saveNamespace();
            return VOID_SAVENAMESPACE_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.RollEditsResponseProto rollEdits(RpcController controller, ClientNamenodeProtocolProtos.RollEditsRequestProto request) throws ServiceException {
        try {
            long txid = this.server.rollEdits();
            return ClientNamenodeProtocolProtos.RollEditsResponseProto.newBuilder().setNewSegmentTxId(txid).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.RefreshNodesResponseProto refreshNodes(RpcController controller, ClientNamenodeProtocolProtos.RefreshNodesRequestProto req) throws ServiceException {
        try {
            this.server.refreshNodes();
            return VOID_REFRESHNODES_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.FinalizeUpgradeResponseProto finalizeUpgrade(RpcController controller, ClientNamenodeProtocolProtos.FinalizeUpgradeRequestProto req) throws ServiceException {
        try {
            this.server.finalizeUpgrade();
            return VOID_FINALIZEUPGRADE_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.ListCorruptFileBlocksResponseProto listCorruptFileBlocks(RpcController controller, ClientNamenodeProtocolProtos.ListCorruptFileBlocksRequestProto req) throws ServiceException {
        try {
            CorruptFileBlocks result = this.server.listCorruptFileBlocks(req.getPath(), req.hasCookie() ? req.getCookie() : null);
            return ClientNamenodeProtocolProtos.ListCorruptFileBlocksResponseProto.newBuilder().setCorrupt(PBHelper.convert(result)).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.MetaSaveResponseProto metaSave(RpcController controller, ClientNamenodeProtocolProtos.MetaSaveRequestProto req) throws ServiceException {
        try {
            this.server.metaSave(req.getFilename());
            return VOID_METASAVE_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.GetFileInfoResponseProto getFileInfo(RpcController controller, ClientNamenodeProtocolProtos.GetFileInfoRequestProto req) throws ServiceException {
        try {
            HdfsFileStatus result = this.server.getFileInfo(req.getSrc());
            if (result != null) {
                return ClientNamenodeProtocolProtos.GetFileInfoResponseProto.newBuilder().setFs(PBHelper.convert(result)).build();
            }
            return VOID_GETFILEINFO_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.GetFileLinkInfoResponseProto getFileLinkInfo(RpcController controller, ClientNamenodeProtocolProtos.GetFileLinkInfoRequestProto req) throws ServiceException {
        try {
            HdfsFileStatus result = this.server.getFileLinkInfo(req.getSrc());
            if (result != null) {
                System.out.println("got non null result for getFileLinkInfo for " + req.getSrc());
                return ClientNamenodeProtocolProtos.GetFileLinkInfoResponseProto.newBuilder().setFs(PBHelper.convert(result)).build();
            }
            System.out.println("got  null result for getFileLinkInfo for " + req.getSrc());
            return VOID_GETFILELINKINFO_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.GetContentSummaryResponseProto getContentSummary(RpcController controller, ClientNamenodeProtocolProtos.GetContentSummaryRequestProto req) throws ServiceException {
        try {
            ContentSummary result = this.server.getContentSummary(req.getPath());
            return ClientNamenodeProtocolProtos.GetContentSummaryResponseProto.newBuilder().setSummary(PBHelper.convert(result)).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.SetQuotaResponseProto setQuota(RpcController controller, ClientNamenodeProtocolProtos.SetQuotaRequestProto req) throws ServiceException {
        try {
            this.server.setQuota(req.getPath(), req.getNamespaceQuota(), req.getDiskspaceQuota());
            return VOID_SETQUOTA_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.FsyncResponseProto fsync(RpcController controller, ClientNamenodeProtocolProtos.FsyncRequestProto req) throws ServiceException {
        try {
            this.server.fsync(req.getSrc(), req.getClient(), req.getLastBlockLength());
            return VOID_FSYNC_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.SetTimesResponseProto setTimes(RpcController controller, ClientNamenodeProtocolProtos.SetTimesRequestProto req) throws ServiceException {
        try {
            this.server.setTimes(req.getSrc(), req.getMtime(), req.getAtime());
            return VOID_SETTIMES_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.CreateSymlinkResponseProto createSymlink(RpcController controller, ClientNamenodeProtocolProtos.CreateSymlinkRequestProto req) throws ServiceException {
        try {
            this.server.createSymlink(req.getTarget(), req.getLink(), PBHelper.convert(req.getDirPerm()), req.getCreateParent());
            return VOID_CREATESYMLINK_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.GetLinkTargetResponseProto getLinkTarget(RpcController controller, ClientNamenodeProtocolProtos.GetLinkTargetRequestProto req) throws ServiceException {
        try {
            String result = this.server.getLinkTarget(req.getPath());
            ClientNamenodeProtocolProtos.GetLinkTargetResponseProto.Builder builder = ClientNamenodeProtocolProtos.GetLinkTargetResponseProto.newBuilder();
            if (result != null) {
                builder.setTargetPath(result);
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.UpdateBlockForPipelineResponseProto updateBlockForPipeline(RpcController controller, ClientNamenodeProtocolProtos.UpdateBlockForPipelineRequestProto req) throws ServiceException {
        try {
            HdfsProtos.LocatedBlockProto result = PBHelper.convert(this.server.updateBlockForPipeline(PBHelper.convert(req.getBlock()), req.getClientName()));
            return ClientNamenodeProtocolProtos.UpdateBlockForPipelineResponseProto.newBuilder().setBlock(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.UpdatePipelineResponseProto updatePipeline(RpcController controller, ClientNamenodeProtocolProtos.UpdatePipelineRequestProto req) throws ServiceException {
        try {
            List<HdfsProtos.DatanodeIDProto> newNodes = req.getNewNodesList();
            this.server.updatePipeline(req.getClientName(), PBHelper.convert(req.getOldBlock()), PBHelper.convert(req.getNewBlock()), PBHelper.convert(newNodes.toArray(new HdfsProtos.DatanodeIDProto[newNodes.size()])));
            return VOID_UPDATEPIPELINE_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public SecurityProtos.GetDelegationTokenResponseProto getDelegationToken(RpcController controller, SecurityProtos.GetDelegationTokenRequestProto req) throws ServiceException {
        try {
            Token<DelegationTokenIdentifier> token = this.server.getDelegationToken(new Text(req.getRenewer()));
            SecurityProtos.GetDelegationTokenResponseProto.Builder rspBuilder = SecurityProtos.GetDelegationTokenResponseProto.newBuilder();
            if (token != null) {
                rspBuilder.setToken(PBHelper.convert(token));
            }
            return rspBuilder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public SecurityProtos.RenewDelegationTokenResponseProto renewDelegationToken(RpcController controller, SecurityProtos.RenewDelegationTokenRequestProto req) throws ServiceException {
        try {
            long result = this.server.renewDelegationToken(PBHelper.convertDelegationToken(req.getToken()));
            return SecurityProtos.RenewDelegationTokenResponseProto.newBuilder().setNewExpiryTime(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public SecurityProtos.CancelDelegationTokenResponseProto cancelDelegationToken(RpcController controller, SecurityProtos.CancelDelegationTokenRequestProto req) throws ServiceException {
        try {
            this.server.cancelDelegationToken(PBHelper.convertDelegationToken(req.getToken()));
            return VOID_CANCELDELEGATIONTOKEN_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.SetBalancerBandwidthResponseProto setBalancerBandwidth(RpcController controller, ClientNamenodeProtocolProtos.SetBalancerBandwidthRequestProto req) throws ServiceException {
        try {
            this.server.setBalancerBandwidth(req.getBandwidth());
            return VOID_SETBALANCERBANDWIDTH_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ClientNamenodeProtocolProtos.GetDataEncryptionKeyResponseProto getDataEncryptionKey(RpcController controller, ClientNamenodeProtocolProtos.GetDataEncryptionKeyRequestProto request) throws ServiceException {
        try {
            ClientNamenodeProtocolProtos.GetDataEncryptionKeyResponseProto.Builder builder = ClientNamenodeProtocolProtos.GetDataEncryptionKeyResponseProto.newBuilder();
            DataEncryptionKey encryptionKey = this.server.getDataEncryptionKey();
            if (encryptionKey != null) {
                builder.setDataEncryptionKey(PBHelper.convert(encryptionKey));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

