/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.server.tasktracker;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.TaskTracker;

public class Localizer {
    static final Log LOG = LogFactory.getLog(Localizer.class);
    private FileSystem fs;
    private String[] localDirs;
    private Map<String, AtomicBoolean> localizedUsers = new HashMap<String, AtomicBoolean>();

    public Localizer(FileSystem fileSys, String[] lDirs) {
        this.fs = fileSys;
        this.localDirs = lDirs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeUserDirs(String user) throws IOException {
        AtomicBoolean localizedUser;
        if (user == null) {
            throw new IOException("User is null. Cannot initialized user-directories.");
        }
        Object object = this.localizedUsers;
        synchronized (object) {
            if (!this.localizedUsers.containsKey(user)) {
                this.localizedUsers.put(user, new AtomicBoolean(false));
            }
            localizedUser = this.localizedUsers.get(user);
        }
        object = localizedUser;
        synchronized (object) {
            if (localizedUser.get()) {
                LOG.info((Object)("User-directories for the user " + user + " are already initialized on this TT. Not doing anything."));
                return;
            }
            LOG.info((Object)("Initializing user " + user + " on this TT."));
            boolean userDirStatus = false;
            boolean jobCacheDirStatus = false;
            boolean distributedCacheDirStatus = false;
            for (String localDir : this.localDirs) {
                Path userDir = new Path(localDir, TaskTracker.getUserDir(user));
                if (this.fs.exists(userDir) || this.fs.mkdirs(userDir)) {
                    FsPermission userOnly = new FsPermission(448);
                    FileUtil.setPermission(new File(userDir.toUri().getPath()), userOnly);
                    userDirStatus = true;
                    File jobCacheDir = new File(localDir, TaskTracker.getJobCacheSubdir(user));
                    if (jobCacheDir.exists() || jobCacheDir.mkdirs()) {
                        FileUtil.setPermission(jobCacheDir, userOnly);
                        jobCacheDirStatus = true;
                    } else {
                        LOG.warn((Object)("Unable to create job cache directory : " + jobCacheDir.getPath()));
                    }
                    File distributedCacheDir = new File(localDir, TaskTracker.getPrivateDistributedCacheDir(user));
                    if (distributedCacheDir.exists() || distributedCacheDir.mkdirs()) {
                        FileUtil.setPermission(distributedCacheDir, userOnly);
                        distributedCacheDirStatus = true;
                        continue;
                    }
                    LOG.warn((Object)("Unable to create distributed-cache directory : " + distributedCacheDir.getPath()));
                    continue;
                }
                LOG.warn((Object)("Unable to create the user directory : " + userDir));
            }
            if (!userDirStatus) {
                throw new IOException("Not able to initialize user directories in any of the configured local directories for user " + user);
            }
            if (!jobCacheDirStatus) {
                throw new IOException("Not able to initialize job-cache directories in any of the configured local directories for user " + user);
            }
            if (!distributedCacheDirStatus) {
                throw new IOException("Not able to initialize distributed-cache directories in any of the configured local directories for user " + user);
            }
            localizedUser.set(true);
        }
    }

    public void initializeAttemptDirs(String user, String jobId, String attemptId) throws IOException {
        boolean initStatus = false;
        String attemptDirPath = TaskTracker.getLocalTaskDir(user, jobId, attemptId);
        for (String localDir : this.localDirs) {
            Path localAttemptDir = new Path(localDir, attemptDirPath);
            boolean attemptDirStatus = this.fs.mkdirs(localAttemptDir);
            if (!attemptDirStatus) {
                LOG.warn((Object)("localAttemptDir " + localAttemptDir.toString() + " couldn't be created."));
            }
            initStatus = initStatus || attemptDirStatus;
        }
        if (!initStatus) {
            throw new IOException("Not able to initialize attempt directories in any of the configured local directories for the attempt " + attemptId);
        }
    }

    public static class PermissionsHandler {
        public static final PermissionsInfo sevenFiveFive = new PermissionsInfo(true, true, true, false, true, false);
        public static final PermissionsInfo sevenZeroZero = new PermissionsInfo(true, true, true, true, true, true);

        public static class PermissionsInfo {
            public boolean readPermissions;
            public boolean writePermissions;
            public boolean executablePermissions;
            public boolean readPermsOwnerOnly;
            public boolean writePermsOwnerOnly;
            public boolean executePermsOwnerOnly;

            public PermissionsInfo(boolean readPerms, boolean writePerms, boolean executePerms, boolean readOwnerOnly, boolean writeOwnerOnly, boolean executeOwnerOnly) {
                this.readPermissions = readPerms;
                this.writePermissions = writePerms;
                this.executablePermissions = executePerms;
                this.readPermsOwnerOnly = readOwnerOnly;
                this.writePermsOwnerOnly = writeOwnerOnly;
                this.executePermsOwnerOnly = executeOwnerOnly;
            }
        }
    }
}

