/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.util.ReflectionUtils;

public class TotalOrderPartitioner<K extends WritableComparable, V>
implements Partitioner<K, V> {
    private Node partitions;
    public static final String DEFAULT_PATH = "_partition.lst";

    @Override
    public void configure(JobConf job) {
        try {
            String parts = TotalOrderPartitioner.getPartitionFile(job);
            Path partFile = new Path(parts);
            FileSystem fs = DEFAULT_PATH.equals(parts) ? FileSystem.getLocal(job) : partFile.getFileSystem(job);
            Class<?> keyClass = job.getMapOutputKeyClass();
            WritableComparable[] splitPoints = this.readPartitions(fs, partFile, keyClass, job);
            if (splitPoints.length != job.getNumReduceTasks() - 1) {
                throw new IOException("Wrong number of partitions in keyset");
            }
            RawComparator comparator = job.getOutputKeyComparator();
            for (int i = 0; i < splitPoints.length - 1; ++i) {
                if (comparator.compare(splitPoints[i], splitPoints[i + 1]) < 0) continue;
                throw new IOException("Split points are out of order");
            }
            boolean natOrder = job.getBoolean("total.order.partitioner.natural.order", true);
            this.partitions = natOrder && BinaryComparable.class.isAssignableFrom(keyClass) ? this.buildTrie((BinaryComparable[])splitPoints, 0, splitPoints.length, new byte[0], job.getInt("total.order.partitioner.max.trie.depth", 2)) : new BinarySearchNode(this, splitPoints, comparator);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't read partitions file", e);
        }
    }

    @Override
    public int getPartition(K key, V value, int numPartitions) {
        return this.partitions.findPartition(key);
    }

    public static void setPartitionFile(JobConf job, Path p) {
        job.set("total.order.partitioner.path", p.toString());
    }

    public static String getPartitionFile(JobConf job) {
        return job.get("total.order.partitioner.path", DEFAULT_PATH);
    }

    private K[] readPartitions(FileSystem fs, Path p, Class<K> keyClass, JobConf job) throws IOException {
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, p, job);
        ArrayList<WritableComparable> parts = new ArrayList<WritableComparable>();
        WritableComparable key = (WritableComparable)ReflectionUtils.newInstance(keyClass, job);
        NullWritable value = NullWritable.get();
        while (reader.next(key, value)) {
            parts.add(key);
            key = (WritableComparable)ReflectionUtils.newInstance(keyClass, job);
        }
        reader.close();
        return parts.toArray((WritableComparable[])Array.newInstance(keyClass, parts.size()));
    }

    private TrieNode buildTrie(BinaryComparable[] splits, int lower, int upper, byte[] prefix, int maxDepth) {
        int depth = prefix.length;
        if (depth >= maxDepth || lower == upper) {
            return new LeafTrieNode(depth, splits, lower, upper);
        }
        InnerTrieNode result = new InnerTrieNode(depth);
        byte[] trial = Arrays.copyOf(prefix, prefix.length + 1);
        int currentBound = lower;
        for (int ch = 0; ch < 255; ++ch) {
            trial[depth] = (byte)(ch + 1);
            lower = currentBound;
            while (currentBound < upper && splits[currentBound].compareTo(trial, 0, trial.length) < 0) {
                ++currentBound;
            }
            trial[depth] = (byte)ch;
            ((InnerTrieNode)result).child[0xFF & ch] = this.buildTrie(splits, lower, currentBound, trial, maxDepth);
        }
        trial[depth] = 127;
        ((InnerTrieNode)result).child[255] = this.buildTrie(splits, currentBound, upper, trial, maxDepth);
        return result;
    }

    class LeafTrieNode
    extends TrieNode {
        final int lower;
        final int upper;
        final BinaryComparable[] splitPoints;

        LeafTrieNode(int level, BinaryComparable[] splitPoints, int lower, int upper) {
            super(level);
            this.lower = lower;
            this.upper = upper;
            this.splitPoints = splitPoints;
        }

        @Override
        public int findPartition(BinaryComparable key) {
            int pos = Arrays.binarySearch(this.splitPoints, this.lower, this.upper, key) + 1;
            return pos < 0 ? -pos : pos;
        }
    }

    class InnerTrieNode
    extends TrieNode {
        private TrieNode[] child;

        InnerTrieNode(int level) {
            super(level);
            this.child = new TrieNode[256];
        }

        @Override
        public int findPartition(BinaryComparable key) {
            int level = this.getLevel();
            if (key.getLength() <= level) {
                return this.child[0].findPartition(key);
            }
            return this.child[0xFF & key.getBytes()[level]].findPartition(key);
        }
    }

    static class BinarySearchNode
    implements Node<K> {
        private final K[] splitPoints;
        private final RawComparator<K> comparator;
        final /* synthetic */ TotalOrderPartitioner this$0;

        BinarySearchNode(K[] splitPoints, RawComparator<K> comparator) {
            this.this$0 = var1_1;
            this.splitPoints = splitPoints;
            this.comparator = comparator;
        }

        @Override
        public int findPartition(K key) {
            int pos = Arrays.binarySearch(this.splitPoints, key, this.comparator) + 1;
            return pos < 0 ? -pos : pos;
        }
    }

    static abstract class TrieNode
    implements Node<BinaryComparable> {
        private final int level;

        TrieNode(int level) {
            this.level = level;
        }

        int getLevel() {
            return this.level;
        }
    }

    static interface Node<T> {
        public int findPartition(T var1);
    }
}

