/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.mapred.Clock;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.DeleteJobEvent;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.JobCompletedEvent;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.UserLogManager;

public class UserLogCleaner
extends Thread {
    private static final Log LOG = LogFactory.getLog(UserLogCleaner.class);
    static final String USERLOGCLEANUP_SLEEPTIME = "mapreduce.tasktracker.userlogcleanup.sleeptime";
    static final int DEFAULT_USER_LOG_RETAIN_HOURS = 24;
    static final long DEFAULT_THREAD_SLEEP_TIME = 3600000L;
    private UserLogManager userLogManager;
    private Map<JobID, Long> completedJobs = Collections.synchronizedMap(new HashMap());
    private final long threadSleepTime;
    private CleanupQueue cleanupQueue;
    private Clock clock;
    private FileSystem localFs;

    public UserLogCleaner(UserLogManager userLogManager, Configuration conf) throws IOException {
        this.userLogManager = userLogManager;
        this.threadSleepTime = conf.getLong(USERLOGCLEANUP_SLEEPTIME, 3600000L);
        this.cleanupQueue = CleanupQueue.getInstance();
        this.localFs = FileSystem.getLocal(conf);
        this.setClock(new Clock());
        this.setDaemon(true);
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    Clock getClock() {
        return this.clock;
    }

    CleanupQueue getCleanupQueue() {
        return this.cleanupQueue;
    }

    void setCleanupQueue(CleanupQueue cleanupQueue) {
        this.cleanupQueue = cleanupQueue;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(this.threadSleepTime);
                    this.processCompletedJobs();
                }
            }
            catch (Throwable e) {
                LOG.warn((Object)(this.getClass().getSimpleName() + " encountered an exception while monitoring :"), e);
                LOG.info((Object)"Ingoring the exception and continuing monitoring.");
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCompletedJobs() throws IOException {
        long now = this.clock.getTime();
        Map<JobID, Long> map = this.completedJobs;
        synchronized (map) {
            Iterator<Map.Entry<JobID, Long>> completedJobIter = this.completedJobs.entrySet().iterator();
            while (completedJobIter.hasNext()) {
                Map.Entry<JobID, Long> entry = completedJobIter.next();
                if (entry.getValue() > now) continue;
                this.userLogManager.addLogEvent(new DeleteJobEvent(entry.getKey()));
                completedJobIter.remove();
            }
        }
    }

    public void deleteJobLogs(JobID jobid) throws IOException {
        this.deleteLogPath(jobid.toString());
    }

    public void addOldUserLogsForDeletion(File loc, Configuration conf) throws IOException {
        if (loc.exists()) {
            long now = this.clock.getTime();
            for (String logDir : loc.list()) {
                JobID jobid = null;
                try {
                    jobid = JobID.forName(logDir);
                }
                catch (IllegalArgumentException ie) {
                    this.deleteLogPath(logDir);
                    continue;
                }
                if (this.completedJobs.containsKey(jobid)) continue;
                JobCompletedEvent jce = new JobCompletedEvent(jobid, now, UserLogCleaner.getUserlogRetainHours(conf));
                this.userLogManager.addLogEvent(jce);
            }
        }
    }

    public void clearOldUserLogs(Configuration conf) throws IOException {
        String[] localDirs;
        File userLogDir = TaskLog.getUserLogDir();
        this.addOldUserLogsForDeletion(userLogDir, conf);
        for (String localDir : localDirs = conf.getStrings("mapred.local.dir")) {
            File mapredLocalUserLogDir = new File(localDir + File.separatorChar + "userlogs");
            this.addOldUserLogsForDeletion(mapredLocalUserLogDir, conf);
        }
    }

    static int getUserlogRetainHours(Configuration conf) {
        return conf == null ? 24 : conf.getInt("mapred.userlog.retain.hours", 24);
    }

    public void markJobLogsForDeletion(long jobCompletionTime, int retainHours, JobID jobid) {
        long retainTimeStamp = jobCompletionTime + (long)retainHours * 1000L * 60L * 60L;
        LOG.info((Object)("Adding " + jobid + " for user-log deletion with retainTimeStamp:" + retainTimeStamp));
        this.completedJobs.put(jobid, retainTimeStamp);
    }

    public void unmarkJobFromLogDeletion(JobID jobid) {
        if (this.completedJobs.remove(jobid) != null) {
            LOG.info((Object)("Removing " + jobid + " from user-log deletion"));
        }
    }

    private String getLogUser(String logPath) throws IOException {
        String[] localDirs;
        String logRoot = TaskLog.getUserLogDir().toString();
        String user = null;
        try {
            user = this.localFs.getFileStatus(new Path(logRoot, logPath)).getOwner();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (user != null) {
            return user;
        }
        for (String localDir : localDirs = this.userLogManager.getTaskController().getLocalStorage().getGoodLocalDirs()) {
            try {
                logRoot = localDir + File.separator + "userlogs";
                user = this.localFs.getFileStatus(new Path(logRoot, logPath)).getOwner();
                if (user == null) continue;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (user == null) {
            throw new IOException("Userlog path not found for " + logPath);
        }
        return user;
    }

    private void deleteLogPath(String logPath) throws IOException {
        LOG.info((Object)("Deleting user log path " + logPath));
        String user = this.getLogUser(logPath);
        TaskController controller = this.userLogManager.getTaskController();
        TaskController.DeletionContext item = new TaskController.DeletionContext(controller, true, user, logPath);
        this.cleanupQueue.addToQueue(item);
    }
}

