/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.AdminAuthorizedServlet;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.jmx.JMXJsonServlet;
import org.apache.hadoop.log.LogLevel;
import org.apache.hadoop.security.Krb5AndCertsSslSocketConnector;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.ReflectionUtils;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.mortbay.util.MultiException;

public class HttpServer
implements FilterContainer {
    public static final Log LOG = LogFactory.getLog(HttpServer.class);
    static final String FILTER_INITIALIZER_PROPERTY = "hadoop.http.filter.initializers";
    static final String CONF_CONTEXT_ATTRIBUTE = "hadoop.conf";
    static final String ADMINS_ACL = "admins.acl";
    private AccessControlList adminsAcl;
    protected final Server webServer;
    protected final Connector listener;
    protected final WebAppContext webAppContext;
    protected final boolean findPort;
    protected final Map<Context, Boolean> defaultContexts = new HashMap<Context, Boolean>();
    protected final List<String> filterNames = new ArrayList<String>();
    private static final int MAX_RETRIES = 10;
    private final Configuration conf;
    private boolean listenerStartedExternally = false;

    public HttpServer(String name, String bindAddress, int port, boolean findPort) throws IOException {
        this(name, bindAddress, port, findPort, new Configuration());
    }

    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf) throws IOException {
        this(name, bindAddress, port, findPort, conf, null, null);
    }

    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf, Connector connector) throws IOException {
        this(name, bindAddress, port, findPort, conf, null, connector);
    }

    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf, AccessControlList adminsAcl) throws IOException {
        this(name, bindAddress, port, findPort, conf, adminsAcl, null);
    }

    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf, AccessControlList adminsAcl, Connector connector) throws IOException {
        this.webServer = new Server();
        this.findPort = findPort;
        this.conf = conf;
        this.adminsAcl = adminsAcl;
        if (connector == null) {
            this.listenerStartedExternally = false;
            this.listener = this.createBaseListener(conf);
            this.listener.setHost(bindAddress);
            this.listener.setPort(port);
        } else {
            this.listenerStartedExternally = true;
            this.listener = connector;
        }
        this.webServer.addConnector(this.listener);
        this.webServer.setThreadPool((ThreadPool)new QueuedThreadPool());
        String appDir = this.getWebAppsPath();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this.webServer.setHandler((Handler)contexts);
        this.webAppContext = new WebAppContext();
        this.webAppContext.setDisplayName("WepAppsContext");
        this.webAppContext.setContextPath("/");
        this.webAppContext.setWar(appDir + "/" + name);
        this.webAppContext.getServletContext().setAttribute(CONF_CONTEXT_ATTRIBUTE, (Object)conf);
        this.webAppContext.getServletContext().setAttribute(ADMINS_ACL, (Object)adminsAcl);
        this.webServer.addHandler((Handler)this.webAppContext);
        this.addDefaultApps(contexts, appDir);
        this.defineFilter((Context)this.webAppContext, "krb5Filter", Krb5AndCertsSslSocketConnector.Krb5SslFilter.class.getName(), null, null);
        this.addGlobalFilter("safety", QuotingInputFilter.class.getName(), null);
        FilterInitializer[] initializers = HttpServer.getFilterInitializers(conf);
        if (initializers != null) {
            for (FilterInitializer c : initializers) {
                c.initFilter(this, conf);
            }
        }
        this.addDefaultServlets();
    }

    public Connector createBaseListener(Configuration conf) throws IOException {
        return HttpServer.createDefaultChannelConnector();
    }

    public static Connector createDefaultChannelConnector() {
        SelectChannelConnector ret = new SelectChannelConnector();
        ret.setLowResourceMaxIdleTime(10000);
        ret.setAcceptQueueSize(128);
        ret.setResolveNames(false);
        ret.setUseDirectBuffers(false);
        return ret;
    }

    private static FilterInitializer[] getFilterInitializers(Configuration conf) {
        if (conf == null) {
            return null;
        }
        Class<?>[] classes = conf.getClasses(FILTER_INITIALIZER_PROPERTY, new Class[0]);
        if (classes == null) {
            return null;
        }
        FilterInitializer[] initializers = new FilterInitializer[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            initializers[i] = (FilterInitializer)ReflectionUtils.newInstance(classes[i], conf);
        }
        return initializers;
    }

    protected void addDefaultApps(ContextHandlerCollection parent, String appDir) throws IOException {
        String logDir = System.getProperty("hadoop.log.dir");
        if (logDir != null) {
            Context logContext = new Context((HandlerContainer)parent, "/logs");
            logContext.setResourceBase(logDir);
            logContext.addServlet(AdminAuthorizedServlet.class, "/");
            logContext.setDisplayName("logs");
            this.setContextAttributes(logContext);
            this.defaultContexts.put(logContext, true);
        }
        Context staticContext = new Context((HandlerContainer)parent, "/static");
        staticContext.setResourceBase(appDir + "/static");
        staticContext.addServlet(DefaultServlet.class, "/*");
        staticContext.setDisplayName("static");
        this.setContextAttributes(staticContext);
        this.defaultContexts.put(staticContext, true);
    }

    private void setContextAttributes(Context context) {
        context.getServletContext().setAttribute(CONF_CONTEXT_ATTRIBUTE, (Object)this.conf);
        context.getServletContext().setAttribute(ADMINS_ACL, (Object)this.adminsAcl);
    }

    protected void addDefaultServlets() {
        this.addServlet("stacks", "/stacks", StackServlet.class);
        this.addServlet("logLevel", "/logLevel", LogLevel.Servlet.class);
        this.addServlet("jmx", "/jmx", JMXJsonServlet.class);
    }

    public void addContext(Context ctxt, boolean isFiltered) throws IOException {
        this.webServer.addHandler((Handler)ctxt);
        this.defaultContexts.put(ctxt, isFiltered);
    }

    protected void addContext(String pathSpec, String dir, boolean isFiltered) throws IOException {
        if (0 == this.webServer.getHandlers().length) {
            throw new RuntimeException("Couldn't find handler");
        }
        WebAppContext webAppCtx = new WebAppContext();
        webAppCtx.setContextPath(pathSpec);
        webAppCtx.setWar(dir);
        this.addContext((Context)webAppCtx, true);
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute((Context)this.webAppContext, name, value);
    }

    public void setAttribute(Context context, String name, Object value) {
        context.setAttribute(name, value);
    }

    public void addServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.addInternalServlet(name, pathSpec, clazz, false);
        this.addFilterPathMapping(pathSpec, (Context)this.webAppContext);
    }

    @Deprecated
    public void addInternalServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.addInternalServlet(name, pathSpec, clazz, false);
    }

    public void addInternalServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz, boolean requireAuth) {
        ServletHolder holder = new ServletHolder(clazz);
        if (name != null) {
            holder.setName(name);
        }
        this.webAppContext.addServlet(holder, pathSpec);
        if (requireAuth && UserGroupInformation.isSecurityEnabled()) {
            LOG.info((Object)("Adding Kerberos filter to " + name));
            ServletHandler handler = this.webAppContext.getServletHandler();
            FilterMapping fmap = new FilterMapping();
            fmap.setPathSpec(pathSpec);
            fmap.setFilterName("krb5Filter");
            fmap.setDispatches(15);
            handler.addFilterMapping(fmap);
        }
    }

    @Override
    public void addFilter(String name, String classname, Map<String, String> parameters) {
        String[] USER_FACING_URLS = new String[]{"*.html", "*.jsp"};
        this.defineFilter((Context)this.webAppContext, name, classname, parameters, USER_FACING_URLS);
        LOG.info((Object)("Added filter " + name + " (class=" + classname + ") to context " + this.webAppContext.getDisplayName()));
        String[] ALL_URLS = new String[]{"/*"};
        for (Map.Entry<Context, Boolean> e : this.defaultContexts.entrySet()) {
            if (!e.getValue().booleanValue()) continue;
            Context ctx = e.getKey();
            this.defineFilter(ctx, name, classname, parameters, ALL_URLS);
            LOG.info((Object)("Added filter " + name + " (class=" + classname + ") to context " + ctx.getDisplayName()));
        }
        this.filterNames.add(name);
    }

    @Override
    public void addGlobalFilter(String name, String classname, Map<String, String> parameters) {
        String[] ALL_URLS = new String[]{"/*"};
        this.defineFilter((Context)this.webAppContext, name, classname, parameters, ALL_URLS);
        for (Context ctx : this.defaultContexts.keySet()) {
            this.defineFilter(ctx, name, classname, parameters, ALL_URLS);
        }
        LOG.info((Object)("Added global filter" + name + " (class=" + classname + ")"));
    }

    protected void defineFilter(Context ctx, String name, String classname, Map<String, String> parameters, String[] urls) {
        FilterHolder holder = new FilterHolder();
        holder.setName(name);
        holder.setClassName(classname);
        holder.setInitParameters(parameters);
        FilterMapping fmap = new FilterMapping();
        fmap.setPathSpecs(urls);
        fmap.setDispatches(15);
        fmap.setFilterName(name);
        ServletHandler handler = ctx.getServletHandler();
        handler.addFilter(holder, fmap);
    }

    protected void addFilterPathMapping(String pathSpec, Context webAppCtx) {
        ServletHandler handler = webAppCtx.getServletHandler();
        for (String name : this.filterNames) {
            FilterMapping fmap = new FilterMapping();
            fmap.setPathSpec(pathSpec);
            fmap.setFilterName(name);
            fmap.setDispatches(15);
            handler.addFilterMapping(fmap);
        }
    }

    public Object getAttribute(String name) {
        return this.webAppContext.getAttribute(name);
    }

    protected String getWebAppsPath() throws IOException {
        URL url = this.getClass().getClassLoader().getResource("webapps");
        if (url == null) {
            throw new IOException("webapps not found in CLASSPATH");
        }
        return url.toString();
    }

    public int getPort() {
        return this.webServer.getConnectors()[0].getLocalPort();
    }

    public void setThreads(int min, int max) {
        QueuedThreadPool pool = (QueuedThreadPool)this.webServer.getThreadPool();
        pool.setMinThreads(min);
        pool.setMaxThreads(max);
    }

    @Deprecated
    public void addSslListener(InetSocketAddress addr, String keystore, String storPass, String keyPass) throws IOException {
        if (this.webServer.isStarted()) {
            throw new IOException("Failed to add ssl listener");
        }
        SslSocketConnector sslListener = new SslSocketConnector();
        sslListener.setHost(addr.getHostName());
        sslListener.setPort(addr.getPort());
        sslListener.setKeystore(keystore);
        sslListener.setPassword(storPass);
        sslListener.setKeyPassword(keyPass);
        this.webServer.addConnector((Connector)sslListener);
    }

    public void addSslListener(InetSocketAddress addr, Configuration sslConf, boolean needClientAuth) throws IOException {
        this.addSslListener(addr, sslConf, needClientAuth, false);
    }

    public void addSslListener(InetSocketAddress addr, Configuration sslConf, boolean needCertsAuth, boolean needKrbAuth) throws IOException {
        if (this.webServer.isStarted()) {
            throw new IOException("Failed to add ssl listener");
        }
        if (needCertsAuth) {
            System.setProperty("javax.net.ssl.trustStore", sslConf.get("ssl.server.truststore.location", ""));
            System.setProperty("javax.net.ssl.trustStorePassword", sslConf.get("ssl.server.truststore.password", ""));
            System.setProperty("javax.net.ssl.trustStoreType", sslConf.get("ssl.server.truststore.type", "jks"));
        }
        Krb5AndCertsSslSocketConnector.MODE mode = needCertsAuth && needKrbAuth ? Krb5AndCertsSslSocketConnector.MODE.BOTH : (!needCertsAuth && needKrbAuth ? Krb5AndCertsSslSocketConnector.MODE.KRB : Krb5AndCertsSslSocketConnector.MODE.CERTS);
        Krb5AndCertsSslSocketConnector sslListener = new Krb5AndCertsSslSocketConnector(mode);
        sslListener.setHost(addr.getHostName());
        sslListener.setPort(addr.getPort());
        sslListener.setKeystore(sslConf.get("ssl.server.keystore.location"));
        sslListener.setPassword(sslConf.get("ssl.server.keystore.password", ""));
        sslListener.setKeyPassword(sslConf.get("ssl.server.keystore.keypassword", ""));
        sslListener.setKeystoreType(sslConf.get("ssl.server.keystore.type", "jks"));
        sslListener.setNeedClientAuth(needCertsAuth);
        this.webServer.addConnector((Connector)sslListener);
    }

    public void start() throws IOException {
        block15: {
            try {
                if (this.listenerStartedExternally) {
                    if (this.listener.getLocalPort() == -1) {
                        throw new Exception("Exepected webserver's listener to be startedpreviously but wasn't");
                    }
                    this.webServer.start();
                    break block15;
                }
                int port = 0;
                int oriPort = this.listener.getPort();
                while (true) {
                    try {
                        port = this.webServer.getConnectors()[0].getLocalPort();
                        LOG.info((Object)("Port returned by webServer.getConnectors()[0].getLocalPort() before open() is " + port + ". Opening the listener on " + oriPort));
                        this.listener.open();
                        port = this.listener.getLocalPort();
                        LOG.info((Object)("listener.getLocalPort() returned " + this.listener.getLocalPort() + " webServer.getConnectors()[0].getLocalPort() returned " + this.webServer.getConnectors()[0].getLocalPort()));
                        if (port < 0) {
                            Thread.sleep(100L);
                            int numRetries = 1;
                            while (port < 0) {
                                LOG.warn((Object)("listener.getLocalPort returned " + port));
                                if (numRetries++ > 10) {
                                    throw new Exception(" listener.getLocalPort is returning less than 0 even after " + numRetries + " resets");
                                }
                                for (int i = 0; i < 2; ++i) {
                                    LOG.info((Object)"Retrying listener.getLocalPort()");
                                    port = this.listener.getLocalPort();
                                    if (port > 0) break;
                                    Thread.sleep(200L);
                                }
                                if (port > 0) break;
                                LOG.info((Object)"Bouncing the listener");
                                this.listener.close();
                                Thread.sleep(1000L);
                                this.listener.setPort(oriPort == 0 ? 0 : ++oriPort);
                                this.listener.open();
                                Thread.sleep(100L);
                                port = this.listener.getLocalPort();
                            }
                        }
                        LOG.info((Object)("Jetty bound to port " + port));
                        this.webServer.start();
                        break;
                    }
                    catch (IOException ex) {
                        if (ex instanceof BindException) {
                            if (!this.findPort) {
                                throw (BindException)ex;
                            }
                        }
                        LOG.info((Object)"HttpServer.start() threw a non Bind IOException");
                        throw ex;
                    }
                    catch (MultiException ex) {
                        LOG.info((Object)"HttpServer.start() threw a MultiException");
                        throw ex;
                    }
                    this.listener.setPort(++oriPort);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Problem starting http server", e);
            }
        }
    }

    public void stop() throws Exception {
        this.listener.close();
        this.webServer.stop();
    }

    public void join() throws InterruptedException {
        this.webServer.join();
    }

    public static boolean hasAdministratorAccess(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        if (!conf.getBoolean("hadoop.security.authorization", false)) {
            return true;
        }
        String remoteUser = request.getRemoteUser();
        if (remoteUser == null) {
            return true;
        }
        AccessControlList adminsAcl = (AccessControlList)servletContext.getAttribute(ADMINS_ACL);
        UserGroupInformation remoteUserUGI = UserGroupInformation.createRemoteUser(remoteUser);
        if (adminsAcl != null && !adminsAcl.isUserAllowed(remoteUserUGI)) {
            response.sendError(401, "User " + remoteUser + " is unauthorized to access this page. " + "AccessControlList for accessing this page : " + adminsAcl.toString());
            return false;
        }
        return true;
    }

    public static class QuotingInputFilter
    implements Filter {
        public void init(FilterConfig config) throws ServletException {
        }

        public void destroy() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            RequestQuoter quoted = new RequestQuoter((HttpServletRequest)request);
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setContentType("text/html;charset=utf-8");
            chain.doFilter((ServletRequest)quoted, response);
        }

        public static class RequestQuoter
        extends HttpServletRequestWrapper {
            private final HttpServletRequest rawRequest;

            public RequestQuoter(HttpServletRequest rawRequest) {
                super(rawRequest);
                this.rawRequest = rawRequest;
            }

            public Enumeration<String> getParameterNames() {
                return new Enumeration<String>(){
                    private Enumeration<String> rawIterator;
                    {
                        this.rawIterator = RequestQuoter.this.rawRequest.getParameterNames();
                    }

                    @Override
                    public boolean hasMoreElements() {
                        return this.rawIterator.hasMoreElements();
                    }

                    @Override
                    public String nextElement() {
                        return HtmlQuoting.quoteHtmlChars(this.rawIterator.nextElement());
                    }
                };
            }

            public String getParameter(String name) {
                return HtmlQuoting.quoteHtmlChars(this.rawRequest.getParameter(HtmlQuoting.unquoteHtmlChars(name)));
            }

            public String[] getParameterValues(String name) {
                String unquoteName = HtmlQuoting.unquoteHtmlChars(name);
                String[] unquoteValue = this.rawRequest.getParameterValues(unquoteName);
                String[] result = new String[unquoteValue.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = HtmlQuoting.quoteHtmlChars(unquoteValue[i]);
                }
                return result;
            }

            public Map<String, String[]> getParameterMap() {
                HashMap<String, String[]> result = new HashMap<String, String[]>();
                Map raw = this.rawRequest.getParameterMap();
                for (Map.Entry item : raw.entrySet()) {
                    String[] rawValue = (String[])item.getValue();
                    String[] cookedValue = new String[rawValue.length];
                    for (int i = 0; i < rawValue.length; ++i) {
                        cookedValue[i] = HtmlQuoting.quoteHtmlChars(rawValue[i]);
                    }
                    result.put(HtmlQuoting.quoteHtmlChars((String)item.getKey()), cookedValue);
                }
                return result;
            }

            public StringBuffer getRequestURL() {
                String url = this.rawRequest.getRequestURL().toString();
                return new StringBuffer(HtmlQuoting.quoteHtmlChars(url));
            }

            public String getServerName() {
                return HtmlQuoting.quoteHtmlChars(this.rawRequest.getServerName());
            }
        }
    }

    public static class StackServlet
    extends HttpServlet {
        private static final long serialVersionUID = -6284183679759467039L;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (!HttpServer.hasAdministratorAccess(this.getServletContext(), request, response)) {
                return;
            }
            PrintWriter out = new PrintWriter(HtmlQuoting.quoteOutputStream((OutputStream)response.getOutputStream()));
            ReflectionUtils.printThreadInfo(out, "");
            out.close();
            ReflectionUtils.logThreadInfo(LOG, "jsp requested", 1L);
        }
    }
}

