/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.util.List;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.server.namenode.JspHelper;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ServletUtil;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.ResourceInjector;

public final class browseBlock_jsp
extends HttpJspBase
implements JspSourceDependent {
    static JspHelper jspHelper = new JspHelper();
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static Vector _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    public void generateFileDetails(JspWriter out, HttpServletRequest req, Configuration conf) throws IOException, InterruptedException {
        DatanodeInfo chosenNode;
        String chunkSizeToViewStr;
        int chunkSizeToView = 0;
        long startOffset = 0L;
        String blockIdStr = null;
        long currBlockId = 0L;
        blockIdStr = req.getParameter("blockId");
        if (blockIdStr == null) {
            out.print("Invalid input (blockId absent)");
            return;
        }
        currBlockId = Long.parseLong(blockIdStr);
        String datanodePortStr = req.getParameter("datanodePort");
        if (datanodePortStr == null) {
            out.print("Invalid input (datanodePort absent)");
            return;
        }
        int datanodePort = Integer.parseInt(datanodePortStr);
        String namenodeInfoPortStr = req.getParameter("namenodeInfoPort");
        int namenodeInfoPort = -1;
        if (namenodeInfoPortStr != null) {
            namenodeInfoPort = Integer.parseInt(namenodeInfoPortStr);
        }
        chunkSizeToView = (chunkSizeToViewStr = req.getParameter("chunkSizeToView")) != null && Integer.parseInt(chunkSizeToViewStr) > 0 ? Integer.parseInt(chunkSizeToViewStr) : JspHelper.getDefaultChunkSize(conf);
        String startOffsetStr = req.getParameter("startOffset");
        startOffset = startOffsetStr == null || Long.parseLong(startOffsetStr) < 0L ? 0L : Long.parseLong(startOffsetStr);
        String filename = req.getParameter("filename");
        if (filename == null || filename.length() == 0) {
            out.print("Invalid input");
            return;
        }
        String blockSizeStr = req.getParameter("blockSize");
        long blockSize = 0L;
        if (blockSizeStr == null || blockSizeStr.length() == 0) {
            out.print("Invalid input");
            return;
        }
        blockSize = Long.parseLong(blockSizeStr);
        String tokenString = req.getParameter("delegation");
        UserGroupInformation ugi = JspHelper.getUGI(req, conf);
        DFSClient dfs = JspHelper.getDFSClient(ugi, JspHelper.nameNodeAddr, conf);
        List<LocatedBlock> blocks = dfs.namenode.getBlockLocations(filename, 0L, Long.MAX_VALUE).getLocatedBlocks();
        String downloadUrl = "http://" + req.getServerName() + ":" + req.getServerPort() + "/streamFile" + URLEncoder.encode(filename, "UTF-8") + "?" + "delegation" + "=" + tokenString;
        out.print("<a name=\"viewOptions\"></a>");
        out.print("<a href=\"" + downloadUrl + "\">Download this file</a><br>");
        LocatedBlock lastBlk = blocks.get(blocks.size() - 1);
        long blockId = lastBlk.getBlock().getBlockId();
        try {
            chosenNode = jspHelper.bestNode(lastBlk);
        }
        catch (IOException e) {
            out.print(e.toString());
            dfs.close();
            return;
        }
        String fqdn = InetAddress.getByName(chosenNode.getHost()).getCanonicalHostName();
        String tailUrl = "http://" + fqdn + ":" + chosenNode.getInfoPort() + "/tail.jsp?filename=" + URLEncoder.encode(filename, "UTF-8") + "&namenodeInfoPort=" + namenodeInfoPort + "&chunkSizeToView=" + chunkSizeToView + "&referrer=" + URLEncoder.encode(req.getRequestURL() + "?" + req.getQueryString(), "UTF-8") + JspHelper.getDelegationTokenUrlParam(tokenString);
        out.print("<a href=\"" + tailUrl + "\">Tail this file</a><br>");
        out.print("<form action=\"/browseBlock.jsp\" method=GET>");
        out.print("<b>Chunk size to view (in bytes, up to file's DFS block size): </b>");
        out.print("<input type=\"hidden\" name=\"blockId\" value=\"" + currBlockId + "\">");
        out.print("<input type=\"hidden\" name=\"blockSize\" value=\"" + blockSize + "\">");
        out.print("<input type=\"hidden\" name=\"startOffset\" value=\"" + startOffset + "\">");
        out.print("<input type=\"hidden\" name=\"filename\" value=\"" + filename + "\">");
        out.print("<input type=\"hidden\" name=\"datanodePort\" value=\"" + datanodePort + "\">");
        out.print("<input type=\"hidden\" name=\"namenodeInfoPort\" value=\"" + namenodeInfoPort + "\">");
        out.print("<input type=\"text\" name=\"chunkSizeToView\" value=" + chunkSizeToView + " size=10 maxlength=10>");
        out.print("&nbsp;&nbsp;<input type=\"submit\" name=\"submit\" value=\"Refresh\">");
        out.print("</form>");
        out.print("<hr>");
        out.print("<a name=\"blockDetails\"></a>");
        out.print("<B>Total number of blocks: " + blocks.size() + "</B><br>");
        out.println("\n<table>");
        for (LocatedBlock cur : blocks) {
            out.print("<tr>");
            blockId = cur.getBlock().getBlockId();
            blockSize = cur.getBlock().getNumBytes();
            String blk = "blk_" + Long.toString(blockId);
            out.print("<td>" + Long.toString(blockId) + ":</td>");
            DatanodeInfo[] locs = cur.getLocations();
            for (int j = 0; j < locs.length; ++j) {
                String datanodeAddr = locs[j].getName();
                datanodePort = Integer.parseInt(datanodeAddr.substring(datanodeAddr.indexOf(58) + 1, datanodeAddr.length()));
                fqdn = InetAddress.getByName(locs[j].getHost()).getCanonicalHostName();
                String blockUrl = "http://" + fqdn + ":" + locs[j].getInfoPort() + "/browseBlock.jsp?blockId=" + Long.toString(blockId) + "&blockSize=" + blockSize + "&filename=" + URLEncoder.encode(filename, "UTF-8") + "&datanodePort=" + datanodePort + "&genstamp=" + cur.getBlock().getGenerationStamp() + "&namenodeInfoPort=" + namenodeInfoPort + "&chunkSizeToView=" + chunkSizeToView;
                out.print("<td>&nbsp</td><td><a href=\"" + blockUrl + "\">" + datanodeAddr + "</a></td>");
            }
            out.println("</tr>");
        }
        out.println("</table>");
        out.print("<hr>");
        String namenodeHost = JspHelper.nameNodeAddr.getHostName();
        out.print("<br><a href=\"http://" + InetAddress.getByName(namenodeHost).getCanonicalHostName() + ":" + namenodeInfoPort + "/dfshealth.jsp\">Go back to DFS home</a>");
        dfs.close();
    }

    public void generateFileChunks(JspWriter out, HttpServletRequest req, Configuration conf) throws IOException, InterruptedException {
        String filename;
        long startOffset = 0L;
        int datanodePort = 0;
        int chunkSizeToView = 0;
        String namenodeInfoPortStr = req.getParameter("namenodeInfoPort");
        int namenodeInfoPort = -1;
        if (namenodeInfoPortStr != null) {
            namenodeInfoPort = Integer.parseInt(namenodeInfoPortStr);
        }
        if ((filename = req.getParameter("filename")) == null) {
            out.print("Invalid input (filename absent)");
            return;
        }
        String blockIdStr = null;
        long blockId = 0L;
        blockIdStr = req.getParameter("blockId");
        if (blockIdStr == null) {
            out.print("Invalid input (blockId absent)");
            return;
        }
        blockId = Long.parseLong(blockIdStr);
        String tokenString = req.getParameter("delegation");
        UserGroupInformation ugi = JspHelper.getUGI(req, conf);
        DFSClient dfs = JspHelper.getDFSClient(ugi, JspHelper.nameNodeAddr, conf);
        Token<BlockTokenIdentifier> accessToken = BlockTokenSecretManager.DUMMY_TOKEN;
        if (conf.getBoolean("dfs.block.access.token.enable", false)) {
            List<LocatedBlock> blks = dfs.namenode.getBlockLocations(filename, 0L, Long.MAX_VALUE).getLocatedBlocks();
            if (blks == null || blks.size() == 0) {
                out.print("Can't locate file blocks");
                dfs.close();
                return;
            }
            for (int i = 0; i < blks.size(); ++i) {
                if (blks.get(i).getBlock().getBlockId() != blockId) continue;
                accessToken = blks.get(i).getBlockToken();
                break;
            }
        }
        String blockGenStamp = null;
        long genStamp = 0L;
        blockGenStamp = req.getParameter("genstamp");
        if (blockGenStamp == null) {
            out.print("Invalid input (genstamp absent)");
            return;
        }
        genStamp = Long.parseLong(blockGenStamp);
        long blockSize = 0L;
        String blockSizeStr = req.getParameter("blockSize");
        if (blockSizeStr == null) {
            out.print("Invalid input (blockSize absent)");
            return;
        }
        blockSize = Long.parseLong(blockSizeStr);
        String chunkSizeToViewStr = req.getParameter("chunkSizeToView");
        chunkSizeToView = chunkSizeToViewStr != null && Integer.parseInt(chunkSizeToViewStr) > 0 ? Integer.parseInt(chunkSizeToViewStr) : JspHelper.getDefaultChunkSize(conf);
        String startOffsetStr = req.getParameter("startOffset");
        startOffset = startOffsetStr == null || Long.parseLong(startOffsetStr) < 0L ? 0L : Long.parseLong(startOffsetStr);
        String datanodePortStr = req.getParameter("datanodePort");
        if (datanodePortStr == null) {
            out.print("Invalid input (datanodePort absent)");
            return;
        }
        datanodePort = Integer.parseInt(datanodePortStr);
        out.print("<h3>File: ");
        JspHelper.printPathWithLinks(filename, out, namenodeInfoPort, tokenString);
        out.print("</h3><hr>");
        String parent = new File(filename).getParent();
        JspHelper.printGotoForm(out, namenodeInfoPort, tokenString, parent);
        out.print("<hr>");
        out.print("<a href=\"http://" + req.getServerName() + ":" + req.getServerPort() + "/browseDirectory.jsp?dir=" + URLEncoder.encode(parent, "UTF-8") + "&namenodeInfoPort=" + namenodeInfoPort + "\"><i>Go back to dir listing</i></a><br>");
        out.print("<a href=\"#viewOptions\">Advanced view/download options</a><br>");
        out.print("<hr>");
        long nextStartOffset = 0L;
        long nextBlockSize = 0L;
        String nextBlockIdStr = null;
        String nextGenStamp = null;
        String nextHost = req.getServerName();
        int nextPort = req.getServerPort();
        int nextDatanodePort = datanodePort;
        if (startOffset + (long)chunkSizeToView >= blockSize) {
            List<LocatedBlock> blocks = dfs.namenode.getBlockLocations(filename, 0L, Long.MAX_VALUE).getLocatedBlocks();
            for (int i = 0; i < blocks.size(); ++i) {
                if (blocks.get(i).getBlock().getBlockId() != blockId || i == blocks.size() - 1) continue;
                LocatedBlock nextBlock = blocks.get(i + 1);
                nextBlockIdStr = Long.toString(nextBlock.getBlock().getBlockId());
                nextGenStamp = Long.toString(nextBlock.getBlock().getGenerationStamp());
                nextStartOffset = 0L;
                nextBlockSize = nextBlock.getBlock().getNumBytes();
                DatanodeInfo d = jspHelper.bestNode(nextBlock);
                String datanodeAddr = d.getName();
                nextDatanodePort = Integer.parseInt(datanodeAddr.substring(datanodeAddr.indexOf(58) + 1, datanodeAddr.length()));
                nextHost = InetAddress.getByName(d.getHost()).getCanonicalHostName();
                nextPort = d.getInfoPort();
            }
        } else {
            nextBlockIdStr = blockIdStr;
            nextStartOffset = startOffset + (long)chunkSizeToView;
            nextBlockSize = blockSize;
            nextGenStamp = blockGenStamp;
        }
        String nextUrl = null;
        if (nextBlockIdStr != null) {
            nextUrl = "http://" + nextHost + ":" + nextPort + "/browseBlock.jsp?blockId=" + nextBlockIdStr + "&blockSize=" + nextBlockSize + "&startOffset=" + nextStartOffset + "&genstamp=" + nextGenStamp + "&filename=" + URLEncoder.encode(filename, "UTF-8") + "&chunkSizeToView=" + chunkSizeToView + "&datanodePort=" + nextDatanodePort + "&namenodeInfoPort=" + namenodeInfoPort + JspHelper.getDelegationTokenUrlParam(tokenString);
            out.print("<a href=\"" + nextUrl + "\">View Next chunk</a>&nbsp;&nbsp;");
        }
        String prevBlockIdStr = null;
        String prevGenStamp = null;
        long prevStartOffset = 0L;
        long prevBlockSize = 0L;
        String prevHost = req.getServerName();
        int prevPort = req.getServerPort();
        int prevDatanodePort = datanodePort;
        if (startOffset == 0L) {
            List<LocatedBlock> blocks = dfs.namenode.getBlockLocations(filename, 0L, Long.MAX_VALUE).getLocatedBlocks();
            for (int i = 0; i < blocks.size(); ++i) {
                if (blocks.get(i).getBlock().getBlockId() != blockId || i == 0) continue;
                LocatedBlock prevBlock = blocks.get(i - 1);
                prevBlockIdStr = Long.toString(prevBlock.getBlock().getBlockId());
                prevGenStamp = Long.toString(prevBlock.getBlock().getGenerationStamp());
                prevStartOffset = prevBlock.getBlock().getNumBytes() - (long)chunkSizeToView;
                if (prevStartOffset < 0L) {
                    prevStartOffset = 0L;
                }
                prevBlockSize = prevBlock.getBlock().getNumBytes();
                DatanodeInfo d = jspHelper.bestNode(prevBlock);
                String datanodeAddr = d.getName();
                prevDatanodePort = Integer.parseInt(datanodeAddr.substring(datanodeAddr.indexOf(58) + 1, datanodeAddr.length()));
                prevHost = InetAddress.getByName(d.getHost()).getCanonicalHostName();
                prevPort = d.getInfoPort();
            }
        } else {
            prevBlockIdStr = blockIdStr;
            prevStartOffset = startOffset - (long)chunkSizeToView;
            if (prevStartOffset < 0L) {
                prevStartOffset = 0L;
            }
            prevBlockSize = blockSize;
            prevGenStamp = blockGenStamp;
        }
        String prevUrl = null;
        if (prevBlockIdStr != null) {
            prevUrl = "http://" + prevHost + ":" + prevPort + "/browseBlock.jsp?blockId=" + prevBlockIdStr + "&blockSize=" + prevBlockSize + "&startOffset=" + prevStartOffset + "&filename=" + URLEncoder.encode(filename, "UTF-8") + "&chunkSizeToView=" + chunkSizeToView + "&genstamp=" + prevGenStamp + "&datanodePort=" + prevDatanodePort + "&namenodeInfoPort=" + namenodeInfoPort + JspHelper.getDelegationTokenUrlParam(tokenString);
            out.print("<a href=\"" + prevUrl + "\">View Prev chunk</a>&nbsp;&nbsp;");
        }
        out.print("<hr>");
        out.print("<textarea cols=\"100\" rows=\"25\" wrap=\"virtual\" style=\"width:100%\" READONLY>");
        try {
            jspHelper.streamBlockInAscii(new InetSocketAddress(req.getServerName(), datanodePort), blockId, accessToken, genStamp, blockSize, startOffset, chunkSizeToView, out, conf);
        }
        catch (Exception e) {
            out.print((Object)e);
        }
        out.print("</textarea>");
        dfs.close();
    }

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PageContext pageContext = null;
        HttpSession session = null;
        ServletContext application = null;
        ServletConfig config = null;
        JspWriter out = null;
        browseBlock_jsp page = this;
        JspWriter _jspx_out = null;
        PageContext _jspx_page_context = null;
        try {
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
            out.write(10);
            out.write(10);
            out.write("\n<html>\n<head>\n");
            JspHelper.createTitle(out, request, request.getParameter("filename"));
            out.write("\n</head>\n<body onload=\"document.goto.dir.focus()\">\n");
            Configuration conf = (Configuration)this.getServletContext().getAttribute("current.conf");
            this.generateFileChunks(out, request, conf);
            out.write("\n<hr>\n");
            this.generateFileDetails(out, request, conf);
            out.write("\n\n<h2>Local logs</h2>\n<a href=\"/logs/\">Log</a> directory\n\n");
            out.println(ServletUtil.htmlFooter());
            out.write(10);
        }
        catch (Throwable t) {
            try {
                if (!(t instanceof SkipPageException)) {
                    out = _jspx_out;
                    if (out != null && out.getBufferSize() != 0) {
                        out.clearBuffer();
                    }
                    if (_jspx_page_context != null) {
                        _jspx_page_context.handlePageException(t);
                    }
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                _jspxFactory.releasePageContext(_jspx_page_context);
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
    }
}

