/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;

public class Protocol {
    public static final long VERSION = 1L;
    private String name;
    private String namespace;
    private String doc;
    private Schema.Names types = new Schema.Names();
    private Map<String, Message> messages = new LinkedHashMap<String, Message>();
    private byte[] md5;
    public static final Schema SYSTEM_ERROR = Schema.create(Schema.Type.STRING);
    public static final Schema SYSTEM_ERRORS;

    private Protocol() {
    }

    public Protocol(String name, String namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDoc() {
        return this.doc;
    }

    public Collection<Schema> getTypes() {
        return this.types.values();
    }

    public Schema getType(String name) {
        return this.types.get(name);
    }

    public void setTypes(Collection<Schema> newTypes) {
        this.types = new Schema.Names();
        for (Schema s : newTypes) {
            this.types.add(s);
        }
    }

    public Map<String, Message> getMessages() {
        return this.messages;
    }

    public Message createMessage(String name, String doc, Schema request, Schema response, Schema errors) {
        return new Message(name, doc, request, response, errors);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Protocol)) {
            return false;
        }
        Protocol that = (Protocol)o;
        return this.name.equals(that.name) && this.namespace.equals(that.namespace) && this.types.equals(that.types) && ((Object)this.messages).equals(that.messages);
    }

    public int hashCode() {
        return this.name.hashCode() + this.namespace.hashCode() + this.types.hashCode() + ((Object)this.messages).hashCode();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean pretty) {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator gen = Schema.FACTORY.createJsonGenerator((Writer)writer);
            if (pretty) {
                gen.useDefaultPrettyPrinter();
            }
            this.toJson(gen);
            gen.flush();
            return writer.toString();
        }
        catch (IOException e) {
            throw new AvroRuntimeException(e);
        }
    }

    void toJson(JsonGenerator gen) throws IOException {
        this.types.space(this.namespace);
        gen.writeStartObject();
        gen.writeStringField("protocol", this.name);
        gen.writeStringField("namespace", this.namespace);
        gen.writeArrayFieldStart("types");
        Schema.Names resolved = new Schema.Names(this.namespace);
        for (Schema schema : this.types.values()) {
            if (resolved.contains(schema)) continue;
            schema.toJson(resolved, gen);
        }
        gen.writeEndArray();
        gen.writeObjectFieldStart("messages");
        for (Map.Entry entry : this.messages.entrySet()) {
            gen.writeFieldName((String)entry.getKey());
            ((Message)entry.getValue()).toJson(gen);
        }
        gen.writeEndObject();
        gen.writeEndObject();
    }

    public byte[] getMD5() {
        if (this.md5 == null) {
            try {
                this.md5 = MessageDigest.getInstance("MD5").digest(this.toString().getBytes("UTF-8"));
            }
            catch (Exception e) {
                throw new AvroRuntimeException(e);
            }
        }
        return this.md5;
    }

    public static Protocol parse(File file) throws IOException {
        return Protocol.parse(Schema.FACTORY.createJsonParser(file));
    }

    public static Protocol parse(String string) {
        try {
            return Protocol.parse(Schema.FACTORY.createJsonParser((InputStream)new ByteArrayInputStream(string.getBytes("UTF-8"))));
        }
        catch (IOException e) {
            throw new AvroRuntimeException(e);
        }
    }

    private static Protocol parse(JsonParser parser) {
        try {
            Protocol protocol = new Protocol();
            protocol.parse(Schema.MAPPER.readTree(parser));
            return protocol;
        }
        catch (IOException e) {
            throw new SchemaParseException(e);
        }
    }

    private void parse(JsonNode json) {
        this.parseNamespace(json);
        this.parseName(json);
        this.parseTypes(json);
        this.parseMessages(json);
        this.parseDoc(json);
    }

    private void parseNamespace(JsonNode json) {
        JsonNode nameNode = json.get("namespace");
        if (nameNode == null) {
            return;
        }
        this.namespace = nameNode.getTextValue();
        this.types.space(this.namespace);
    }

    private void parseDoc(JsonNode json) {
        this.doc = this.parseDocNode(json);
    }

    private String parseDocNode(JsonNode json) {
        JsonNode nameNode = json.get("doc");
        if (nameNode == null) {
            return null;
        }
        return nameNode.getTextValue();
    }

    private void parseName(JsonNode json) {
        JsonNode nameNode = json.get("protocol");
        if (nameNode == null) {
            throw new SchemaParseException("No protocol name specified: " + json);
        }
        this.name = nameNode.getTextValue();
    }

    private void parseTypes(JsonNode json) {
        JsonNode defs = json.get("types");
        if (defs == null) {
            return;
        }
        if (!defs.isArray()) {
            throw new SchemaParseException("Types not an array: " + defs);
        }
        for (JsonNode type : defs) {
            if (!type.isObject()) {
                throw new SchemaParseException("Type not an object: " + type);
            }
            Schema.parse(type, this.types);
        }
    }

    private void parseMessages(JsonNode json) {
        JsonNode defs = json.get("messages");
        if (defs == null) {
            return;
        }
        Iterator i = defs.getFieldNames();
        while (i.hasNext()) {
            String prop = (String)i.next();
            this.messages.put(prop, this.parseMessage(prop, defs.get(prop)));
        }
    }

    private Message parseMessage(String messageName, JsonNode json) {
        JsonNode requestNode = json.get("request");
        if (requestNode == null || !requestNode.isArray()) {
            throw new SchemaParseException("No request specified: " + json);
        }
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (JsonNode field : requestNode) {
            JsonNode fieldNameNode = field.get("name");
            if (fieldNameNode == null) {
                throw new SchemaParseException("No param name: " + field);
            }
            JsonNode fieldTypeNode = field.get("type");
            if (fieldTypeNode == null) {
                throw new SchemaParseException("No param type: " + field);
            }
            String name = fieldNameNode.getTextValue();
            fields.add(new Schema.Field(name, Schema.parse(fieldTypeNode, this.types), null, field.get("default")));
        }
        Schema request = Schema.createRecord(fields);
        JsonNode responseNode = json.get("response");
        if (responseNode == null) {
            throw new SchemaParseException("No response specified: " + json);
        }
        Schema response = Schema.parse(responseNode, this.types);
        ArrayList<Schema> errs = new ArrayList<Schema>();
        errs.add(SYSTEM_ERROR);
        JsonNode decls = json.get("errors");
        if (decls != null) {
            if (!decls.isArray()) {
                throw new SchemaParseException("Errors not an array: " + json);
            }
            for (JsonNode decl : decls) {
                String name = decl.getTextValue();
                Schema schema = this.types.get(name);
                if (schema == null) {
                    throw new SchemaParseException("Undefined error: " + name);
                }
                if (!schema.isError()) {
                    throw new SchemaParseException("Not an error: " + name);
                }
                errs.add(schema);
            }
        }
        String doc = this.parseDocNode(json);
        return new Message(messageName, doc, request, response, Schema.createUnion(errs));
    }

    public static void main(String[] args) throws Exception {
        System.out.println(Protocol.parse(new File(args[0])));
    }

    static {
        ArrayList<Schema> errors = new ArrayList<Schema>();
        errors.add(SYSTEM_ERROR);
        SYSTEM_ERRORS = Schema.createUnion(errors);
    }

    public class Message {
        private String name;
        private String doc;
        private Schema request;
        private Schema response;
        private Schema errors;

        private Message(String name, String doc, Schema request, Schema response, Schema errors) {
            this.name = name;
            this.doc = doc;
            this.request = request;
            this.response = response;
            this.errors = errors;
        }

        public String getName() {
            return this.name;
        }

        public Schema getRequest() {
            return this.request;
        }

        public Schema getResponse() {
            return this.response;
        }

        public Schema getErrors() {
            return this.errors;
        }

        public String toString() {
            try {
                StringWriter writer = new StringWriter();
                JsonGenerator gen = Schema.FACTORY.createJsonGenerator((Writer)writer);
                this.toJson(gen);
                gen.flush();
                return writer.toString();
            }
            catch (IOException e) {
                throw new AvroRuntimeException(e);
            }
        }

        void toJson(JsonGenerator gen) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName("request");
            this.request.fieldsToJson(Protocol.this.types, gen);
            gen.writeFieldName("response");
            this.response.toJson(Protocol.this.types, gen);
            List<Schema> errTypes = this.errors.getTypes();
            if (errTypes.size() > 1) {
                Schema errs = Schema.createUnion(errTypes.subList(1, errTypes.size()));
                gen.writeFieldName("errors");
                errs.toJson(Protocol.this.types, gen);
            }
            gen.writeEndObject();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message that = (Message)o;
            return this.name.equals(that.name) && this.request.equals(that.request) && this.response.equals(that.response) && this.errors.equals(that.errors);
        }

        public int hashCode() {
            return this.name.hashCode() + this.request.hashCode() + this.response.hashCode() + this.errors.hashCode();
        }

        public String getDoc() {
            return this.doc;
        }
    }
}

