/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsn.util;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.wsn.wsdl.WSNWSDLLocator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSNHelper {
    public static <T> T getPort(EndpointReference ref, Class<T> serviceInterface) {
        if (!(ref instanceof W3CEndpointReference)) {
            throw new IllegalArgumentException("Unsupported endpoint reference: " + (ref != null ? ref.toString() : "null"));
        }
        W3CEndpointReference w3cEpr = (W3CEndpointReference)ref;
        String address = WSNHelper.getWSAAddress(w3cEpr);
        return WSNHelper.getPort(address, serviceInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getPort(String address, Class<T> serviceInterface) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(WSNHelper.class.getClassLoader());
            Service service = Service.create((URL)WSNWSDLLocator.getWSDLUrl(), (QName)new QName("http://cxf.apache.org/wsn/jaxws", serviceInterface.getSimpleName() + "Service"));
            Object object = service.getPort((EndpointReference)WSNHelper.createWSA(address), serviceInterface, new WebServiceFeature[0]);
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static W3CEndpointReference createWSA(String address) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(WSNHelper.class.getClassLoader());
            W3CEndpointReference w3CEndpointReference = new W3CEndpointReferenceBuilder().address(address).build();
            return w3CEndpointReference;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static String getWSAAddress(W3CEndpointReference ref) {
        Element element = DOMUtils.createDocument().createElement("elem");
        ref.writeTo((Result)new DOMResult(element));
        NodeList nl = element.getElementsByTagNameNS("http://www.w3.org/2005/08/addressing", "Address");
        if (nl != null && nl.getLength() > 0) {
            Element e = (Element)nl.item(0);
            return DOMUtils.getContent((Node)e).trim();
        }
        return null;
    }
}

