/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.managers;

import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.configuration.spring.MapProvider;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.TransportFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations(unlessNull={"bus"})
public final class DestinationFactoryManagerImpl
implements DestinationFactoryManager {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(DestinationFactoryManagerImpl.class);
    Map<String, DestinationFactory> destinationFactories;
    Set<String> failed = new CopyOnWriteArraySet<String>();
    Set<String> loaded = new CopyOnWriteArraySet<String>();
    Properties factoryNamespaceMappings;
    private Bus bus;

    public DestinationFactoryManagerImpl() {
        this.destinationFactories = new ConcurrentHashMap<String, DestinationFactory>();
    }

    public DestinationFactoryManagerImpl(Bus b) {
        this.destinationFactories = new ConcurrentHashMap<String, DestinationFactory>();
        this.setBus(b);
    }

    public DestinationFactoryManagerImpl(Map<String, DestinationFactory> destinationFactories) {
        this.destinationFactories = destinationFactories;
    }

    public DestinationFactoryManagerImpl(Map<String, DestinationFactory> destinationFactories, Bus b) {
        this.destinationFactories = destinationFactories;
        this.setBus(b);
    }

    public DestinationFactoryManagerImpl(MapProvider<String, DestinationFactory> destinationFactories) {
        this.destinationFactories = destinationFactories.createMap();
    }

    public void setMapProvider(MapProvider<String, DestinationFactory> mapProvider) {
        this.destinationFactories = mapProvider.createMap();
    }

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
        if (null != this.bus) {
            this.bus.setExtension((Object)this, DestinationFactoryManager.class);
        }
    }

    public void registerDestinationFactory(String namespace, DestinationFactory factory) {
        this.destinationFactories.put(namespace, factory);
    }

    public void deregisterDestinationFactory(String namespace) {
        this.destinationFactories.remove(namespace);
    }

    public DestinationFactory getDestinationFactory(String namespace) throws BusException {
        DestinationFactory factory = this.destinationFactories.get(namespace);
        if (factory == null && !this.failed.contains(namespace)) {
            factory = (DestinationFactory)new TransportFinder(this.bus, this.destinationFactories, this.loaded, DestinationFactory.class).findTransportForNamespace(namespace);
        }
        if (factory == null) {
            this.failed.add(namespace);
            throw new BusException(new Message("NO_DEST_FACTORY", BUNDLE, new Object[]{namespace}));
        }
        return factory;
    }

    public DestinationFactory getDestinationFactoryForUri(String uri) {
        DestinationFactory factory = (DestinationFactory)new TransportFinder(this.bus, this.destinationFactories, this.loaded, DestinationFactory.class).findTransportForURI(uri);
        return factory;
    }
}

