/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.ws.rm.AbstractEndpoint;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.v200702.Identifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Source
extends AbstractEndpoint {
    private static final Logger LOG = LogUtils.getL7dLogger(Source.class);
    private static final String REQUESTOR_SEQUENCE_ID = "";
    private Map<String, SourceSequence> map = new HashMap<String, SourceSequence>();
    private Map<String, SourceSequence> current = new HashMap<String, SourceSequence>();
    private Lock sequenceCreationLock = new ReentrantLock();
    private Condition sequenceCreationCondition = this.sequenceCreationLock.newCondition();
    private boolean sequenceCreationNotified;

    Source(RMEndpoint reliableEndpoint) {
        super(reliableEndpoint);
    }

    public SourceSequence getSequence(Identifier id) {
        return this.map.get(id.getValue());
    }

    public Collection<SourceSequence> getAllSequences() {
        return CastUtils.cast(this.map.values());
    }

    public void addSequence(SourceSequence seq) {
        this.addSequence(seq, true);
    }

    public void addSequence(SourceSequence seq, boolean persist) {
        if (seq.getProtocol() == this.getReliableEndpoint().getProtocol()) {
            RMStore store;
            seq.setSource(this);
            this.map.put(seq.getIdentifier().getValue(), seq);
            if (persist && null != (store = this.getReliableEndpoint().getManager().getStore())) {
                store.createSourceSequence(seq);
            }
        } else {
            LOG.log(Level.SEVERE, "Incompatible protocol version");
        }
    }

    public void removeSequence(SourceSequence seq) {
        this.map.remove(seq.getIdentifier().getValue());
        RMStore store = this.getReliableEndpoint().getManager().getStore();
        if (null != store) {
            store.removeSourceSequence(seq.getIdentifier());
        }
    }

    public Collection<SourceSequence> getAllUnacknowledgedSequences() {
        ArrayList<SourceSequence> seqs = new ArrayList<SourceSequence>();
        for (SourceSequence seq : this.map.values()) {
            if (seq.allAcknowledged()) continue;
            seqs.add(seq);
        }
        return seqs;
    }

    SourceSequence getCurrent() {
        return this.getCurrent(null);
    }

    public void setCurrent(SourceSequence s) {
        this.setCurrent(null, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SourceSequence getCurrent(Identifier i) {
        this.sequenceCreationLock.lock();
        try {
            SourceSequence sourceSequence = this.getAssociatedSequence(i);
            return sourceSequence;
        }
        finally {
            this.sequenceCreationLock.unlock();
        }
    }

    SourceSequence getAssociatedSequence(Identifier i) {
        return this.current.get(i == null ? REQUESTOR_SEQUENCE_ID : i.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SourceSequence awaitCurrent(Identifier i) {
        this.sequenceCreationLock.lock();
        try {
            SourceSequence seq = this.getAssociatedSequence(i);
            while (seq == null) {
                while (!this.sequenceCreationNotified) {
                    try {
                        this.sequenceCreationCondition.await();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                seq = this.getAssociatedSequence(i);
            }
            SourceSequence sourceSequence = seq;
            return sourceSequence;
        }
        finally {
            this.sequenceCreationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrent(Identifier i, SourceSequence s) {
        this.sequenceCreationLock.lock();
        try {
            this.current.put(i == null ? REQUESTOR_SEQUENCE_ID : i.getValue(), s);
            this.sequenceCreationNotified = true;
            this.sequenceCreationCondition.signal();
        }
        finally {
            this.sequenceCreationLock.unlock();
        }
    }
}

