/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.http.interceptor;

import org.apache.cxf.binding.http.URIMapper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.MessageSenderInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIParameterOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    public URIParameterOutInterceptor() {
        super("prepare-send");
        this.addBefore(MessageSenderInterceptor.class.getName());
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        boolean locationSlash;
        Endpoint ep = message.getExchange().get(Endpoint.class);
        URIMapper mapper = (URIMapper)ep.getService().get(URIMapper.class.getName());
        BindingOperationInfo bop = message.getExchange().get(BindingOperationInfo.class);
        String address = ep.getEndpointInfo().getAddress();
        String location = mapper.getLocation(bop);
        StringBuilder uri = new StringBuilder();
        uri.append(address);
        boolean addressSlash = address.charAt(address.length() - 1) == '/';
        boolean bl = locationSlash = location.charAt(0) == '/';
        if (!addressSlash && !locationSlash) {
            uri.append('/');
            uri.append(location);
        } else if (addressSlash && locationSlash) {
            uri.append(location.substring(1));
        } else {
            uri.append(location);
        }
        Document d = (Document)message.getContent(Node.class);
        String encodedUri = URIParameterOutInterceptor.encodeIri(uri.toString(), d);
        message.put(Message.ENDPOINT_ADDRESS, encodedUri);
    }

    public static String encodeIri(String uri, Document doc) {
        StringBuilder builder = new StringBuilder();
        String locPath = uri;
        Element root = doc.getDocumentElement();
        int start = 0;
        for (int idx1 = 0; idx1 < locPath.length(); ++idx1) {
            char c = locPath.charAt(idx1);
            if (c != '{') continue;
            if (locPath.charAt(idx1 + 1) == '{') {
                ++idx1;
                continue;
            }
            builder.append(locPath.substring(start, idx1));
            int locEnd = locPath.indexOf(125, idx1);
            String name = locPath.substring(idx1 + 1, locEnd);
            idx1 = locEnd;
            for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1 || !name.equals(node.getLocalName())) continue;
                builder.append(DOMUtils.getRawContent(node));
                break;
            }
            start = locEnd + 1;
        }
        if (start == 0) {
            return uri;
        }
        return builder.toString();
    }
}

