/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.rdf4j.impl;

import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;
import org.apache.commons.rdf.api.TripleLike;
import org.apache.commons.rdf.rdf4j.ClosableIterable;
import org.apache.commons.rdf.rdf4j.RDF4JBlankNodeOrIRI;
import org.apache.commons.rdf.rdf4j.RDF4JGraph;
import org.apache.commons.rdf.rdf4j.RDF4JTriple;
import org.apache.commons.rdf.rdf4j.impl.AbstractRepositoryGraphLike;
import org.apache.commons.rdf.rdf4j.impl.ConvertedStatements;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;

class RepositoryGraphImpl
extends AbstractRepositoryGraphLike<Triple>
implements RDF4JGraph {
    private final Resource[] contextMask;

    RepositoryGraphImpl(Repository repository, UUID salt, boolean handleInitAndShutdown, boolean includeInferred, Resource ... contextMask) {
        super(repository, salt, handleInitAndShutdown, includeInferred);
        this.contextMask = Objects.requireNonNull(contextMask);
    }

    public void add(Triple tripleLike) {
        Statement statement = this.rdf4jTermFactory.asStatement((TripleLike)tripleLike);
        try (RepositoryConnection conn = this.getRepositoryConnection();){
            conn.add(statement, this.contextMask);
            conn.commit();
        }
    }

    public boolean contains(Triple tripleLike) {
        Statement statement = this.rdf4jTermFactory.asStatement((TripleLike)tripleLike);
        try (RepositoryConnection conn = this.getRepositoryConnection();){
            boolean bl = conn.hasStatement(statement, this.includeInferred, this.contextMask);
            return bl;
        }
    }

    public void remove(Triple tripleLike) {
        Statement statement = this.rdf4jTermFactory.asStatement((TripleLike)tripleLike);
        try (RepositoryConnection conn = this.getRepositoryConnection();){
            conn.remove(statement, this.contextMask);
            conn.commit();
        }
    }

    public void clear() {
        try (RepositoryConnection conn = this.getRepositoryConnection();){
            conn.clear(this.contextMask);
            conn.commit();
        }
    }

    public long size() {
        if (!this.includeInferred && this.contextMask.length == 0) {
            try (RepositoryConnection conn = this.getRepositoryConnection();){
                long l = conn.size(new Resource[0]);
                return l;
            }
        }
        try (Stream<RDF4JTriple> stream = this.stream();){
            long l = stream.count();
            return l;
        }
    }

    public void add(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        Resource subj = (Resource)this.rdf4jTermFactory.asValue((RDFTerm)subject);
        org.eclipse.rdf4j.model.IRI pred = (org.eclipse.rdf4j.model.IRI)this.rdf4jTermFactory.asValue((RDFTerm)predicate);
        Value obj = this.rdf4jTermFactory.asValue(object);
        try (RepositoryConnection conn = this.getRepositoryConnection();){
            conn.add(subj, pred, obj, this.contextMask);
            conn.commit();
        }
    }

    public boolean contains(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        Resource subj = (Resource)this.rdf4jTermFactory.asValue((RDFTerm)subject);
        org.eclipse.rdf4j.model.IRI pred = (org.eclipse.rdf4j.model.IRI)this.rdf4jTermFactory.asValue((RDFTerm)predicate);
        Value obj = this.rdf4jTermFactory.asValue(object);
        try (RepositoryConnection conn = this.getRepositoryConnection();){
            boolean bl = conn.hasStatement(subj, pred, obj, this.includeInferred, this.contextMask);
            return bl;
        }
    }

    public void remove(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        Resource subj = (Resource)this.rdf4jTermFactory.asValue((RDFTerm)subject);
        org.eclipse.rdf4j.model.IRI pred = (org.eclipse.rdf4j.model.IRI)this.rdf4jTermFactory.asValue((RDFTerm)predicate);
        Value obj = this.rdf4jTermFactory.asValue(object);
        try (RepositoryConnection conn = this.getRepositoryConnection();){
            conn.remove(subj, pred, obj, this.contextMask);
            conn.commit();
        }
    }

    @Override
    public ClosableIterable<Triple> iterate() throws ConcurrentModificationException, IllegalStateException {
        return this.iterate(null, null, null);
    }

    @Override
    public ClosableIterable<Triple> iterate(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) throws ConcurrentModificationException, IllegalStateException {
        Resource subj = (Resource)this.rdf4jTermFactory.asValue((RDFTerm)subject);
        org.eclipse.rdf4j.model.IRI pred = (org.eclipse.rdf4j.model.IRI)this.rdf4jTermFactory.asValue((RDFTerm)predicate);
        Value obj = this.rdf4jTermFactory.asValue(object);
        return new ConvertedStatements<Triple>(this::getRepositoryConnection, this.rdf4jTermFactory::asTriple, subj, pred, obj, this.contextMask);
    }

    @Override
    public Stream<RDF4JTriple> stream() {
        return this.stream(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<RDF4JTriple> stream(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        Resource subj = (Resource)this.rdf4jTermFactory.asValue((RDFTerm)subject);
        org.eclipse.rdf4j.model.IRI pred = (org.eclipse.rdf4j.model.IRI)this.rdf4jTermFactory.asValue((RDFTerm)predicate);
        Value obj = this.rdf4jTermFactory.asValue(object);
        RepositoryConnection conn = this.getRepositoryConnection();
        Stream<RDF4JTriple> stream = null;
        try {
            RepositoryResult statements = conn.getStatements(subj, pred, obj, this.includeInferred, this.contextMask);
            stream = Iterations.stream((Iteration)statements).map(this::asTripleLike);
        }
        finally {
            if (stream == null) {
                conn.close();
            }
        }
        return (Stream)stream.onClose(() -> ((RepositoryConnection)conn).close());
    }

    @Override
    protected RDF4JTriple asTripleLike(Statement statement) {
        return this.rdf4jTermFactory.asTriple(statement);
    }

    @Override
    public Set<RDF4JBlankNodeOrIRI> getContextMask() {
        HashSet<RDF4JBlankNodeOrIRI> mask = new HashSet<RDF4JBlankNodeOrIRI>();
        for (Resource s : this.contextMask) {
            mask.add(this.rdf4jTermFactory.asRDFTerm(s));
        }
        return Collections.unmodifiableSet(mask);
    }
}

