/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.jpa;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.processor.idempotent.jpa.MessageProcessed;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.ServiceSupport;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@ManagedResource(description="JPA based message id repository")
public class JpaMessageIdRepository
extends ServiceSupport
implements IdempotentRepository<String> {
    protected static final String QUERY_STRING = "select x from " + MessageProcessed.class.getName() + " x where x.processorName = ?1 and x.messageId = ?2";
    private final String processorName;
    private final EntityManager entityManager;
    private final TransactionTemplate transactionTemplate;
    private boolean joinTransaction = true;

    public JpaMessageIdRepository(EntityManagerFactory entityManagerFactory, String processorName) {
        this(entityManagerFactory, JpaMessageIdRepository.createTransactionTemplate(entityManagerFactory), processorName);
    }

    public JpaMessageIdRepository(EntityManagerFactory entityManagerFactory, TransactionTemplate transactionTemplate, String processorName) {
        this.entityManager = entityManagerFactory.createEntityManager();
        this.processorName = processorName;
        this.transactionTemplate = transactionTemplate;
    }

    public static JpaMessageIdRepository jpaMessageIdRepository(String persistenceUnit, String processorName) {
        return JpaMessageIdRepository.jpaMessageIdRepository(Persistence.createEntityManagerFactory((String)persistenceUnit), processorName);
    }

    public static JpaMessageIdRepository jpaMessageIdRepository(EntityManagerFactory entityManagerFactory, String processorName) {
        return new JpaMessageIdRepository(entityManagerFactory, processorName);
    }

    private static TransactionTemplate createTransactionTemplate(EntityManagerFactory entityManagerFactory) {
        TransactionTemplate transactionTemplate = new TransactionTemplate();
        transactionTemplate.setTransactionManager((PlatformTransactionManager)new JpaTransactionManager(entityManagerFactory));
        transactionTemplate.setPropagationBehavior(0);
        return transactionTemplate;
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(final String messageId) {
        Boolean rc = (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus arg0) {
                List list;
                if (JpaMessageIdRepository.this.isJoinTransaction()) {
                    JpaMessageIdRepository.this.entityManager.joinTransaction();
                }
                if ((list = JpaMessageIdRepository.this.query(messageId)).isEmpty()) {
                    MessageProcessed processed = new MessageProcessed();
                    processed.setProcessorName(JpaMessageIdRepository.this.processorName);
                    processed.setMessageId(messageId);
                    processed.setCreatedAt(new Date());
                    JpaMessageIdRepository.this.entityManager.persist((Object)processed);
                    JpaMessageIdRepository.this.entityManager.flush();
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return rc;
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(final String messageId) {
        Boolean rc = (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus arg0) {
                List list;
                if (JpaMessageIdRepository.this.isJoinTransaction()) {
                    JpaMessageIdRepository.this.entityManager.joinTransaction();
                }
                if ((list = JpaMessageIdRepository.this.query(messageId)).isEmpty()) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        return rc;
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(final String messageId) {
        Boolean rc = (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus arg0) {
                List list;
                if (JpaMessageIdRepository.this.isJoinTransaction()) {
                    JpaMessageIdRepository.this.entityManager.joinTransaction();
                }
                if ((list = JpaMessageIdRepository.this.query(messageId)).isEmpty()) {
                    return Boolean.FALSE;
                }
                MessageProcessed processed = (MessageProcessed)list.get(0);
                JpaMessageIdRepository.this.entityManager.remove((Object)processed);
                JpaMessageIdRepository.this.entityManager.flush();
                return Boolean.TRUE;
            }
        });
        return rc;
    }

    private List<?> query(String messageId) {
        Query query = this.entityManager.createQuery(QUERY_STRING);
        query.setParameter(1, (Object)this.processorName);
        query.setParameter(2, (Object)messageId);
        return query.getResultList();
    }

    public boolean confirm(String s) {
        return true;
    }

    @ManagedAttribute(description="The processor name")
    public String getProcessorName() {
        return this.processorName;
    }

    public boolean isJoinTransaction() {
        return this.joinTransaction;
    }

    public void setJoinTransaction(boolean joinTransaction) {
        this.joinTransaction = joinTransaction;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
        this.entityManager.close();
    }
}

