/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.RecipientListProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class RecipientList
extends ServiceSupport
implements AsyncProcessor {
    private static final String IGNORE_DELIMITER_MARKER = "false";
    private final CamelContext camelContext;
    private ProducerCache producerCache;
    private Expression expression;
    private final String delimiter;
    private boolean parallelProcessing;
    private boolean stopOnException;
    private boolean ignoreInvalidEndpoints;
    private boolean streaming;
    private long timeout;
    private Processor onPrepare;
    private boolean shareUnitOfWork;
    private ExecutorService executorService;
    private boolean shutdownExecutorService;
    private ExecutorService aggregateExecutorService;
    private AggregationStrategy aggregationStrategy = new UseLatestAggregationStrategy();

    public RecipientList(CamelContext camelContext) {
        this(camelContext, ",");
    }

    public RecipientList(CamelContext camelContext, String delimiter) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notEmpty(delimiter, "delimiter");
        this.camelContext = camelContext;
        this.delimiter = delimiter;
    }

    public RecipientList(CamelContext camelContext, Expression expression) {
        this(camelContext, expression, ",");
    }

    public RecipientList(CamelContext camelContext, Expression expression, String delimiter) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(expression, "expression");
        ObjectHelper.notEmpty(delimiter, "delimiter");
        this.camelContext = camelContext;
        this.expression = expression;
        this.delimiter = delimiter;
    }

    public String toString() {
        return "RecipientList[" + (this.expression != null ? this.expression : "") + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isStarted()) {
            throw new IllegalStateException("RecipientList has not been started: " + this);
        }
        Object recipientList = exchange.removeProperty("CamelEvaluateExpressionResult");
        if (recipientList == null && this.expression != null) {
            recipientList = this.expression.evaluate(exchange, Object.class);
        }
        return this.sendToRecipientList(exchange, recipientList, callback);
    }

    public boolean sendToRecipientList(Exchange exchange, Object recipientList, AsyncCallback callback) {
        Iterator<Object> iter = this.delimiter != null && this.delimiter.equalsIgnoreCase(IGNORE_DELIMITER_MARKER) ? ObjectHelper.createIterator(recipientList, null) : ObjectHelper.createIterator(recipientList, this.delimiter);
        RecipientListProcessor rlp = new RecipientListProcessor(exchange.getContext(), this.producerCache, iter, this.getAggregationStrategy(), this.isParallelProcessing(), this.getExecutorService(), this.isShutdownExecutorService(), this.isStreaming(), this.isStopOnException(), this.getTimeout(), this.getOnPrepare(), this.isShareUnitOfWork()){

            @Override
            protected synchronized ExecutorService createAggregateExecutorService(String name) {
                if (RecipientList.this.aggregateExecutorService == null) {
                    RecipientList.this.aggregateExecutorService = super.createAggregateExecutorService("RecipientList-AggregateTask");
                }
                return RecipientList.this.aggregateExecutorService;
            }
        };
        rlp.setIgnoreInvalidEndpoints(this.isIgnoreInvalidEndpoints());
        try {
            ServiceHelper.startService(rlp);
        }
        catch (Exception e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        ServiceSupport target = rlp;
        if (this.isShareUnitOfWork()) {
            CamelInternalProcessor internalProcessor = new CamelInternalProcessor((Processor)rlp);
            internalProcessor.addAdvice(new CamelInternalProcessor.SubUnitOfWorkProcessorAdvice());
            target = internalProcessor;
        }
        return target.process(exchange, callback);
    }

    protected Endpoint resolveEndpoint(Exchange exchange, Object recipient) {
        if (recipient instanceof String) {
            recipient = ((String)recipient).trim();
        }
        return ExchangeHelper.resolveEndpoint(exchange, recipient);
    }

    @Override
    protected void doStart() throws Exception {
        if (this.producerCache == null) {
            this.producerCache = new ProducerCache(this, this.camelContext);
        }
        ServiceHelper.startServices(this.aggregationStrategy, this.producerCache);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.producerCache, this.aggregationStrategy);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.producerCache, this.aggregationStrategy);
        if (this.shutdownExecutorService && this.executorService != null) {
            this.camelContext.getExecutorServiceManager().shutdownNow(this.executorService);
        }
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    public boolean isIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public boolean isStopOnException() {
        return this.stopOnException;
    }

    public void setStopOnException(boolean stopOnException) {
        this.stopOnException = stopOnException;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public boolean isShutdownExecutorService() {
        return this.shutdownExecutorService;
    }

    public void setShutdownExecutorService(boolean shutdownExecutorService) {
        this.shutdownExecutorService = shutdownExecutorService;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Processor getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(Processor onPrepare) {
        this.onPrepare = onPrepare;
    }

    public boolean isShareUnitOfWork() {
        return this.shareUnitOfWork;
    }

    public void setShareUnitOfWork(boolean shareUnitOfWork) {
        this.shareUnitOfWork = shareUnitOfWork;
    }
}

