/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementMBeanAssembler;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultManagementAgent
extends ServiceSupport
implements ManagementAgent,
CamelContextAware {
    public static final String DEFAULT_DOMAIN = "org.apache.camel";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_REGISTRY_PORT = 1099;
    public static final int DEFAULT_CONNECTION_PORT = -1;
    public static final String DEFAULT_SERVICE_URL_PATH = "/jmxrmi/camel";
    private static final transient Logger LOG = LoggerFactory.getLogger(DefaultManagementAgent.class);
    private CamelContext camelContext;
    private MBeanServer server;
    private final ConcurrentMap<ObjectName, ObjectName> mbeansRegistered = new ConcurrentHashMap<ObjectName, ObjectName>();
    private JMXConnectorServer cs;
    private Registry registry;
    private Integer registryPort;
    private Integer connectorPort;
    private String mBeanServerDefaultDomain;
    private String mBeanObjectDomainName;
    private String serviceUrlPath;
    private Boolean usePlatformMBeanServer = true;
    private Boolean createConnector;
    private Boolean onlyRegisterProcessorWithCustomId;
    private Boolean registerAlways;
    private Boolean registerNewRoutes = true;

    public DefaultManagementAgent() {
    }

    public DefaultManagementAgent(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void finalizeSettings() {
        if (this.registryPort == null) {
            this.registryPort = Integer.getInteger("org.apache.camel.jmx.rmiConnector.registryPort", 1099);
        }
        if (this.connectorPort == null) {
            this.connectorPort = Integer.getInteger("org.apache.camel.jmx.rmiConnector.connectorPort", -1);
        }
        if (this.mBeanServerDefaultDomain == null) {
            this.mBeanServerDefaultDomain = System.getProperty("org.apache.camel.jmx.mbeanServerDefaultDomain", DEFAULT_DOMAIN);
        }
        if (this.mBeanObjectDomainName == null) {
            this.mBeanObjectDomainName = System.getProperty("org.apache.camel.jmx.mbeanObjectDomainName", DEFAULT_DOMAIN);
        }
        if (this.serviceUrlPath == null) {
            this.serviceUrlPath = System.getProperty("org.apache.camel.jmx.serviceUrlPath", DEFAULT_SERVICE_URL_PATH);
        }
        if (this.createConnector == null) {
            this.createConnector = Boolean.getBoolean("org.apache.camel.jmx.createRmiConnector");
        }
        if (this.onlyRegisterProcessorWithCustomId == null) {
            this.onlyRegisterProcessorWithCustomId = Boolean.getBoolean("org.apache.camel.jmx.onlyRegisterProcessorWithCustomId");
        }
        if (System.getProperty("org.apache.camel.jmx.usePlatformMBeanServer") != null) {
            this.usePlatformMBeanServer = Boolean.getBoolean("org.apache.camel.jmx.usePlatformMBeanServer");
        }
        if (System.getProperty("org.apache.camel.jmx.registerAlways") != null) {
            this.registerAlways = Boolean.getBoolean("org.apache.camel.jmx.registerAlways");
        }
        if (System.getProperty("org.apache.camel.jmx.registerNewRoutes") != null) {
            this.registerNewRoutes = Boolean.getBoolean("org.apache.camel.jmx.registerNewRoutes");
        }
        if (System.getProperty("org.apache.camel.jmx.createRmiConnector") != null) {
            this.createConnector = Boolean.getBoolean("org.apache.camel.jmx.createRmiConnector");
        }
    }

    @Override
    public void setRegistryPort(Integer port) {
        this.registryPort = port;
    }

    @Override
    public Integer getRegistryPort() {
        return this.registryPort;
    }

    @Override
    public void setConnectorPort(Integer port) {
        this.connectorPort = port;
    }

    @Override
    public Integer getConnectorPort() {
        return this.connectorPort;
    }

    @Override
    public void setMBeanServerDefaultDomain(String domain) {
        this.mBeanServerDefaultDomain = domain;
    }

    @Override
    public String getMBeanServerDefaultDomain() {
        return this.mBeanServerDefaultDomain;
    }

    @Override
    public void setMBeanObjectDomainName(String domainName) {
        this.mBeanObjectDomainName = domainName;
    }

    @Override
    public String getMBeanObjectDomainName() {
        return this.mBeanObjectDomainName;
    }

    @Override
    public void setServiceUrlPath(String url) {
        this.serviceUrlPath = url;
    }

    @Override
    public String getServiceUrlPath() {
        return this.serviceUrlPath;
    }

    @Override
    public void setCreateConnector(Boolean flag) {
        this.createConnector = flag;
    }

    @Override
    public Boolean getCreateConnector() {
        return this.createConnector;
    }

    @Override
    public void setUsePlatformMBeanServer(Boolean flag) {
        this.usePlatformMBeanServer = flag;
    }

    @Override
    public Boolean getUsePlatformMBeanServer() {
        return this.usePlatformMBeanServer;
    }

    @Override
    public Boolean getOnlyRegisterProcessorWithCustomId() {
        return this.onlyRegisterProcessorWithCustomId;
    }

    @Override
    public void setOnlyRegisterProcessorWithCustomId(Boolean onlyRegisterProcessorWithCustomId) {
        this.onlyRegisterProcessorWithCustomId = onlyRegisterProcessorWithCustomId;
    }

    @Override
    public void setMBeanServer(MBeanServer mbeanServer) {
        this.server = mbeanServer;
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.server;
    }

    @Override
    public Boolean getRegisterAlways() {
        return this.registerAlways != null && this.registerAlways != false;
    }

    @Override
    public void setRegisterAlways(Boolean registerAlways) {
        this.registerAlways = registerAlways;
    }

    @Override
    public Boolean getRegisterNewRoutes() {
        return this.registerNewRoutes != null && this.registerNewRoutes != false;
    }

    @Override
    public void setRegisterNewRoutes(Boolean registerNewRoutes) {
        this.registerNewRoutes = registerNewRoutes;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void register(Object obj, ObjectName name) throws JMException {
        this.register(obj, name, false);
    }

    @Override
    public void register(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        block2: {
            try {
                this.registerMBeanWithServer(obj, name, forceRegistration);
            }
            catch (NotCompliantMBeanException e) {
                ManagementMBeanAssembler assembler = this.camelContext.getManagementMBeanAssembler();
                ObjectHelper.notNull(assembler, "ManagementMBeanAssembler", this.camelContext);
                ModelMBean mbean = assembler.assemble(this.server, obj, name);
                if (mbean == null) break block2;
                this.registerMBeanWithServer(mbean, name, forceRegistration);
            }
        }
    }

    @Override
    public void unregister(ObjectName name) throws JMException {
        if (this.isRegistered(name)) {
            ObjectName on = (ObjectName)this.mbeansRegistered.remove(name);
            this.server.unregisterMBean(on);
            LOG.debug("Unregistered MBean with ObjectName: {}", (Object)name);
        } else {
            this.mbeansRegistered.remove(name);
        }
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        ObjectName on = (ObjectName)this.mbeansRegistered.get(name);
        return on != null && this.server.isRegistered(on) || this.server.isRegistered(name);
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.camelContext, "CamelContext");
        if (this.server == null) {
            this.finalizeSettings();
            this.createMBeanServer();
        }
        LOG.debug("Starting JMX agent on server: {}", (Object)this.getMBeanServer());
    }

    @Override
    protected void doStop() throws Exception {
        if (this.cs != null) {
            try {
                this.cs.stop();
                LOG.debug("Stopped JMX Connector");
            }
            catch (IOException e) {
                LOG.debug("Error occurred during stopping JMXConnectorService: " + this.cs + ". This exception will be ignored.");
            }
            this.cs = null;
        }
        if (this.registry != null) {
            try {
                UnicastRemoteObject.unexportObject(this.registry, true);
                LOG.debug("Unexported JMX RMI Registry");
            }
            catch (NoSuchObjectException e) {
                LOG.debug("Error occurred while unexporting JMX RMI registry. This exception will be ignored.");
            }
        }
        if (this.mbeansRegistered.isEmpty()) {
            return;
        }
        ObjectName[] mBeans = this.mbeansRegistered.keySet().toArray(new ObjectName[this.mbeansRegistered.size()]);
        int caught = 0;
        for (ObjectName name : mBeans) {
            try {
                this.unregister(name);
            }
            catch (Exception e) {
                LOG.info("Exception unregistering MBean with name " + name, (Throwable)e);
                ++caught;
            }
        }
        if (caught > 0) {
            LOG.warn("A number of " + caught + " exceptions caught while unregistering MBeans during stop operation." + " See INFO log for details.");
        }
    }

    private void registerMBeanWithServer(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        boolean exists = this.isRegistered(name);
        if (exists) {
            if (forceRegistration) {
                LOG.info("ForceRegistration enabled, unregistering existing MBean with ObjectName: {}", (Object)name);
                this.server.unregisterMBean(name);
            } else {
                LOG.debug("MBean already registered with ObjectName: {}", (Object)name);
            }
        }
        ObjectInstance instance = null;
        if (forceRegistration || !exists) {
            LOG.trace("Registering MBean with ObjectName: {}", (Object)name);
            instance = this.server.registerMBean(obj, name);
        }
        if (instance != null) {
            ObjectName registeredName = instance.getObjectName();
            LOG.debug("Registered MBean with ObjectName: {}", (Object)registeredName);
            this.mbeansRegistered.put(name, registeredName);
        }
    }

    protected void createMBeanServer() {
        String hostName;
        boolean canAccessSystemProps = true;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPropertiesAccess();
            }
        }
        catch (SecurityException se) {
            canAccessSystemProps = false;
        }
        if (canAccessSystemProps) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException uhe) {
                LOG.info("Cannot determine localhost name. Using default: 1099", (Throwable)uhe);
                hostName = DEFAULT_HOST;
            }
        } else {
            hostName = DEFAULT_HOST;
        }
        this.server = this.findOrCreateMBeanServer();
        try {
            if (this.createConnector.booleanValue()) {
                this.createJmxConnector(hostName);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Could not create and start JMX connector.", (Throwable)ioe);
        }
    }

    protected MBeanServer findOrCreateMBeanServer() {
        if (this.usePlatformMBeanServer.booleanValue()) {
            return ManagementFactory.getPlatformMBeanServer();
        }
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        for (MBeanServer server : servers) {
            LOG.debug("Found MBeanServer with default domain {}", (Object)server.getDefaultDomain());
            if (!this.mBeanServerDefaultDomain.equals(server.getDefaultDomain())) continue;
            return server;
        }
        return MBeanServerFactory.createMBeanServer(this.mBeanServerDefaultDomain);
    }

    protected void createJmxConnector(String host) throws IOException {
        ObjectHelper.notEmpty(this.serviceUrlPath, "serviceUrlPath");
        ObjectHelper.notNull(this.registryPort, "registryPort");
        try {
            this.registry = LocateRegistry.createRegistry(this.registryPort);
            LOG.debug("Created JMXConnector RMI registry on port {}", (Object)this.registryPort);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        String path = this.serviceUrlPath.startsWith("/") ? this.serviceUrlPath : "/" + this.serviceUrlPath;
        final JMXServiceURL url = this.connectorPort > 0 ? new JMXServiceURL("service:jmx:rmi://" + host + ":" + this.connectorPort + "/jndi/rmi://" + host + ":" + this.registryPort + path) : new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + host + ":" + this.registryPort + path);
        this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.server);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.debug("Staring JMX Connector thread to listen at: {}", (Object)url);
                    DefaultManagementAgent.this.cs.start();
                    LOG.info("JMX Connector thread started and listening at: {}", (Object)url);
                }
                catch (IOException ioe) {
                    LOG.warn("Could not start JMXConnector thread at: " + url + ". JMX Connector not in use.", (Throwable)ioe);
                }
            }
        });
        thread.setDaemon(true);
        String threadName = this.camelContext.getExecutorServiceManager().resolveThreadName("JMXConnector: " + url);
        thread.setName(threadName);
        thread.start();
    }
}

