/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.spi.Registry;

public class CompositeRegistry
implements Registry {
    private List<Registry> registryList;

    public CompositeRegistry() {
        this.registryList = new ArrayList<Registry>();
    }

    public CompositeRegistry(List<Registry> registries) {
        this.registryList = registries;
    }

    public void addRegistry(Registry registry) {
        this.registryList.add(registry);
    }

    @Override
    public <T> T lookup(String name, Class<T> type) {
        T answer = null;
        NoSuchBeanException ex = null;
        for (Registry registry : this.registryList) {
            try {
                answer = registry.lookup(name, type);
            }
            catch (Throwable e) {
                ex = e instanceof NoSuchBeanException ? (NoSuchBeanException)e : new NoSuchBeanException(name, "Cannot lookup: " + name + " from registry: " + registry + " with expected type: " + type + " due: " + e.getMessage(), e);
            }
            if (answer == null) continue;
            return answer;
        }
        if (ex != null) {
            throw ex;
        }
        return answer;
    }

    @Override
    public Object lookup(String name) {
        Registry registry;
        Object answer = null;
        Iterator<Registry> i$ = this.registryList.iterator();
        while (i$.hasNext() && (answer = (registry = i$.next()).lookup(name)) == null) {
        }
        return answer;
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        Registry registry;
        Map<Object, Object> answer = Collections.emptyMap();
        Iterator<Registry> i$ = this.registryList.iterator();
        while (i$.hasNext() && (answer = (registry = i$.next()).lookupByType(type)).isEmpty()) {
        }
        return answer;
    }
}

